/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class SqlUnnestUtils {
    public static UnnestTableFunction createUnnestFunction(LogicalType t) {
        switch (t.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)t;
                return new CollectionUnnestTableFunction(arrayType, arrayType.getElementType(), ArrayData.createElementGetter(arrayType.getElementType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)t;
                return new CollectionUnnestTableFunction(multisetType, multisetType.getElementType(), ArrayData.createElementGetter(multisetType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)t;
                return new MapUnnestTableFunction(mapType, RowType.of(false, mapType.getKeyType(), mapType.getValueType()), ArrayData.createElementGetter(mapType.getKeyType()), ArrayData.createElementGetter(mapType.getKeyType()));
            }
        }
        throw new UnsupportedOperationException("Unsupported type for UNNEST: " + t);
    }

    private SqlUnnestUtils() {
    }

    public static final class MapUnnestTableFunction
    extends UnnestTableFunction {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        public MapUnnestTableFunction(LogicalType inputType, LogicalType outputType, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
            super(inputType, outputType);
            this.keyGetter = keyGetter;
            this.valueGetter = valueGetter;
        }

        public void eval(MapData mapData) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keyArray = mapData.keyArray();
            ArrayData valueArray = mapData.valueArray();
            for (int i = 0; i < size; ++i) {
                this.collect(GenericRowData.of(this.keyGetter.getElementOrNull(keyArray, i), this.valueGetter.getElementOrNull(valueArray, i)));
            }
        }
    }

    public static final class CollectionUnnestTableFunction
    extends UnnestTableFunction {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter elementGetter;

        public CollectionUnnestTableFunction(LogicalType inputType, LogicalType outputType, ArrayData.ElementGetter elementGetter) {
            super(inputType, outputType);
            this.elementGetter = elementGetter;
        }

        public void eval(ArrayData arrayData) {
            if (arrayData == null) {
                return;
            }
            int size = arrayData.size();
            for (int pos = 0; pos < size; ++pos) {
                this.collect(this.elementGetter.getElementOrNull(arrayData, pos));
            }
        }

        public void eval(MapData mapData) {
            if (mapData == null) {
                return;
            }
            int size = mapData.size();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            for (int pos = 0; pos < size; ++pos) {
                int multiplier = values.getInt(pos);
                Object key = this.elementGetter.getElementOrNull(keys, pos);
                for (int i = 0; i < multiplier; ++i) {
                    this.collect(key);
                }
            }
        }
    }

    public static abstract class UnnestTableFunction
    extends TableFunction<Object> {
        private final transient LogicalType inputType;
        private final transient LogicalType outputType;

        UnnestTableFunction(LogicalType inputType, LogicalType outputType) {
            this.inputType = inputType;
            this.outputType = outputType;
        }

        public LogicalType getWrappedOutputType() {
            if (LogicalTypeChecks.hasRoot(this.outputType, LogicalTypeRoot.ROW) || LogicalTypeChecks.hasRoot(this.outputType, LogicalTypeRoot.STRUCTURED_TYPE)) {
                return this.outputType;
            }
            return RowType.of(this.outputType);
        }

        @Override
        public TypeInference getTypeInference(DataTypeFactory typeFactory) {
            DataType inputDataType = DataTypeUtils.toInternalDataType(this.inputType);
            DataType outputDataType = DataTypeUtils.toInternalDataType(this.outputType);
            return TypeInference.newBuilder().typedArguments(inputDataType).outputTypeStrategy(TypeStrategies.explicit(outputDataType)).build();
        }
    }
}

