/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

class DeduplicateFunctionHelper {
    static void processLastRowOnProcTime(RowData currentRow2, boolean generateUpdateBefore, boolean generateInsert, ValueState<RowData> state, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow2);
        if (generateUpdateBefore || generateInsert) {
            RowData preRow = (RowData)state.value();
            state.update((Object)currentRow2);
            if (preRow == null) {
                currentRow2.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow2);
            } else {
                if (generateUpdateBefore) {
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                }
                currentRow2.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow2);
            }
        } else {
            currentRow2.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)currentRow2);
        }
    }

    static void processLastRowOnChangelog(RowData currentRow2, boolean generateUpdateBefore, ValueState<RowData> state, Collector<RowData> out) throws Exception {
        RowData preRow = (RowData)state.value();
        RowKind currentKind = currentRow2.getRowKind();
        if (currentKind == RowKind.INSERT || currentKind == RowKind.UPDATE_AFTER) {
            if (preRow == null) {
                currentRow2.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow2);
            } else {
                if (generateUpdateBefore) {
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                }
                currentRow2.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow2);
            }
            currentRow2.setRowKind(RowKind.INSERT);
            state.update((Object)currentRow2);
        } else if (preRow != null) {
            preRow.setRowKind(RowKind.DELETE);
            out.collect((Object)preRow);
            state.clear();
        }
    }

    static void processFirstRowOnProcTime(RowData currentRow2, ValueState<Boolean> state, Collector<RowData> out) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow2);
        if (state.value() != null) {
            return;
        }
        state.update((Object)true);
        out.collect((Object)currentRow2);
    }

    static void updateDeduplicateResult(boolean generateUpdateBefore, boolean generateInsert, RowData preRow, RowData currentRow2, Collector<RowData> out) {
        if (generateUpdateBefore || generateInsert) {
            if (preRow == null) {
                currentRow2.setRowKind(RowKind.INSERT);
                out.collect((Object)currentRow2);
            } else {
                if (generateUpdateBefore) {
                    RowKind preRowKind = preRow.getRowKind();
                    preRow.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)preRow);
                    preRow.setRowKind(preRowKind);
                }
                currentRow2.setRowKind(RowKind.UPDATE_AFTER);
                out.collect((Object)currentRow2);
            }
        } else {
            currentRow2.setRowKind(RowKind.UPDATE_AFTER);
            out.collect((Object)currentRow2);
        }
    }

    static boolean isDuplicate(RowData preRow, RowData currentRow2, int rowtimeIndex, boolean keepLastRow) {
        if (keepLastRow) {
            return preRow == null || DeduplicateFunctionHelper.getRowtime(preRow, rowtimeIndex) <= DeduplicateFunctionHelper.getRowtime(currentRow2, rowtimeIndex);
        }
        return preRow == null || DeduplicateFunctionHelper.getRowtime(currentRow2, rowtimeIndex) < DeduplicateFunctionHelper.getRowtime(preRow, rowtimeIndex);
    }

    private static long getRowtime(RowData input, int rowtimeIndex) {
        return input.getLong(rowtimeIndex);
    }

    static void checkInsertOnly(RowData currentRow2) {
        Preconditions.checkArgument((currentRow2.getRowKind() == RowKind.INSERT ? 1 : 0) != 0);
    }

    private DeduplicateFunctionHelper() {
    }
}

