/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.operators.deduplicate.MiniBatchDeduplicateFunctionBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class ProcTimeMiniBatchDeduplicateKeepLastRowFunction
extends MiniBatchDeduplicateFunctionBase<RowData, RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -8981813609115029119L;
    private final TypeSerializer<RowData> serializer;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final boolean inputInsertOnly;

    public ProcTimeMiniBatchDeduplicateKeepLastRowFunction(InternalTypeInfo<RowData> typeInfo, TypeSerializer<RowData> serializer, long stateRetentionTime, boolean generateUpdateBefore, boolean generateInsert, boolean inputInsertOnly2) {
        super(typeInfo, stateRetentionTime);
        this.serializer = serializer;
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.inputInsertOnly = inputInsertOnly2;
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) {
        return (RowData)this.serializer.copy((Object)input);
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentRow2 = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            if (this.inputInsertOnly) {
                DeduplicateFunctionHelper.processLastRowOnProcTime(currentRow2, this.generateUpdateBefore, this.generateInsert, (ValueState<RowData>)this.state, out);
                continue;
            }
            DeduplicateFunctionHelper.processLastRowOnChangelog(currentRow2, this.generateUpdateBefore, (ValueState<RowData>)this.state, out);
        }
    }
}

