/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionBase;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class RowTimeDeduplicateFunction
extends DeduplicateFunctionBase<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final boolean generateUpdateBefore;
    private final boolean generateInsert;
    private final int rowtimeIndex;
    private final boolean keepLastRow;

    public RowTimeDeduplicateFunction(InternalTypeInfo<RowData> typeInfo, long minRetentionTime, int rowtimeIndex, boolean generateUpdateBefore, boolean generateInsert, boolean keepLastRow) {
        super(typeInfo, null, minRetentionTime);
        this.generateUpdateBefore = generateUpdateBefore;
        this.generateInsert = generateInsert;
        this.rowtimeIndex = rowtimeIndex;
        this.keepLastRow = keepLastRow;
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowTimeDeduplicateFunction.deduplicateOnRowTime((ValueState<RowData>)this.state, input, out, this.generateUpdateBefore, this.generateInsert, this.rowtimeIndex, this.keepLastRow);
    }

    public static void deduplicateOnRowTime(ValueState<RowData> state, RowData currentRow2, Collector<RowData> out, boolean generateUpdateBefore, boolean generateInsert, int rowtimeIndex, boolean keepLastRow) throws Exception {
        DeduplicateFunctionHelper.checkInsertOnly(currentRow2);
        RowData preRow = (RowData)state.value();
        if (DeduplicateFunctionHelper.isDuplicate(preRow, currentRow2, rowtimeIndex, keepLastRow)) {
            DeduplicateFunctionHelper.updateDeduplicateResult(generateUpdateBefore, generateInsert, preRow, currentRow2, out);
            state.update((Object)currentRow2);
        }
    }
}

