/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyInstantTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyLocalDateTimeTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyTimestampTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.TimestampDataTypeInfo;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Deprecated
public class TypeInfoDataTypeConverter {
    private static final Map<String, TypeInformation<?>> primitiveDataTypeTypeInfoMap = new HashMap();

    private static void addDefaultTypeInfo(Class<?> clazz, TypeInformation<?> typeInformation) {
        Preconditions.checkArgument((boolean)clazz.isPrimitive());
        primitiveDataTypeTypeInfoMap.put(clazz.getName(), typeInformation);
    }

    public static TypeInformation<?> fromDataTypeToTypeInfo(DataType dataType2) {
        TypeInformation<?> foundTypeInfo;
        Class<?> clazz = dataType2.getConversionClass();
        if (clazz.isPrimitive() && (foundTypeInfo = primitiveDataTypeTypeInfoMap.get(clazz.getName())) != null) {
            return foundTypeInfo;
        }
        LogicalType logicalType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(dataType2);
        switch (logicalType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)logicalType;
                int precision = timestampType.getPrecision();
                if (timestampType.getKind() == TimestampKind.REGULAR) {
                    return clazz == TimestampData.class ? new TimestampDataTypeInfo(precision) : (clazz == LocalDateTime.class ? (3 == precision ? Types.LOCAL_DATE_TIME : new LegacyLocalDateTimeTypeInfo(precision)) : (3 == precision ? Types.SQL_TIMESTAMP : new LegacyTimestampTypeInfo(precision)));
                }
                return TypeConversions.fromDataTypeToLegacyInfo(dataType2);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType lzTs = (LocalZonedTimestampType)logicalType;
                int precisionLzTs = lzTs.getPrecision();
                return clazz == TimestampData.class ? new TimestampDataTypeInfo(precisionLzTs) : (clazz == Instant.class ? (3 == precisionLzTs ? Types.INSTANT : new LegacyInstantTypeInfo(precisionLzTs)) : TypeConversions.fromDataTypeToLegacyInfo(dataType2));
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)logicalType;
                return clazz == DecimalData.class ? new DecimalDataTypeInfo(decimalType.getPrecision(), decimalType.getScale()) : new BigDecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
            }
            case CHAR: 
            case VARCHAR: {
                return clazz == StringData.class ? StringDataTypeInfo.INSTANCE : BasicTypeInfo.STRING_TYPE_INFO;
            }
            case BINARY: 
            case VARBINARY: {
                return PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            }
            case INTERVAL_YEAR_MONTH: {
                return TimeIntervalTypeInfo.INTERVAL_MONTHS;
            }
            case INTERVAL_DAY_TIME: {
                return TimeIntervalTypeInfo.INTERVAL_MILLIS;
            }
            case ARRAY: {
                if (dataType2 instanceof CollectionDataType && !PlannerTypeUtils.isPrimitive(((CollectionDataType)dataType2).getElementDataType().getLogicalType())) {
                    return ObjectArrayTypeInfo.getInfoFor(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(((CollectionDataType)dataType2).getElementDataType()));
                }
                return TypeConversions.fromDataTypeToLegacyInfo(dataType2);
            }
            case MAP: {
                KeyValueDataType mapType = (KeyValueDataType)dataType2;
                return new MapTypeInfo(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(mapType.getKeyDataType()), TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(mapType.getValueDataType()));
            }
            case MULTISET: {
                return MultisetTypeInfo.getInfoFor(TypeInfoDataTypeConverter.fromDataTypeToTypeInfo(((CollectionDataType)dataType2).getElementDataType()));
            }
            case ROW: {
                if (RowData.class.isAssignableFrom(dataType2.getConversionClass())) {
                    return InternalTypeInfo.of((RowType)LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(dataType2));
                }
                if (Row.class == dataType2.getConversionClass()) {
                    RowType logicalRowType = (RowType)logicalType;
                    return new RowTypeInfo((TypeInformation[])dataType2.getChildren().stream().map(TypeInfoDataTypeConverter::fromDataTypeToTypeInfo).toArray(TypeInformation[]::new), logicalRowType.getFieldNames().toArray(new String[0]));
                }
                return TypeConversions.fromDataTypeToLegacyInfo(dataType2);
            }
            case RAW: {
                if (logicalType instanceof RawType) {
                    return ExternalTypeInfo.of(dataType2);
                }
                return TypeConversions.fromDataTypeToLegacyInfo(dataType2);
            }
        }
        return TypeConversions.fromDataTypeToLegacyInfo(dataType2);
    }

    static {
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Boolean.TYPE, Types.BOOLEAN);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Byte.TYPE, Types.BYTE);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Short.TYPE, Types.SHORT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Integer.TYPE, Types.INT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Long.TYPE, Types.LONG);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Float.TYPE, Types.FLOAT);
        TypeInfoDataTypeConverter.addDefaultTypeInfo(Double.TYPE, Types.DOUBLE);
    }
}

