/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class ExternalSerializer<I, E>
extends TypeSerializer<E> {
    private final DataType dataType;
    private final TypeSerializer<I> internalSerializer;
    private final boolean isReuseEnabled;
    private transient I reuse;
    private transient DataStructureConverter<I, E> converter;

    private ExternalSerializer(DataType dataType2, TypeSerializer<I> internalSerializer) {
        this.dataType = dataType2;
        this.internalSerializer = internalSerializer;
        this.isReuseEnabled = !ExternalSerializer.hasBinaryData(dataType2);
        this.initializeConverter();
    }

    public static <I, E> ExternalSerializer<I, E> of(DataType dataType2) {
        return new ExternalSerializer(dataType2, InternalSerializers.create(dataType2.getLogicalType()));
    }

    public boolean isImmutableType() {
        return this.internalSerializer.isImmutableType();
    }

    public TypeSerializer<E> duplicate() {
        return new ExternalSerializer<I, E>(this.dataType, this.internalSerializer.duplicate());
    }

    public E createInstance() {
        try {
            Object instance = this.internalSerializer.createInstance();
            return this.converter.toExternal(instance);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public E copy(E from) {
        I internalFrom = this.converter.toInternal(from);
        Object copy = this.internalSerializer.copy(internalFrom);
        return this.converter.toExternal(copy);
    }

    public E copy(E from, E reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return this.internalSerializer.getLength();
    }

    public void serialize(E record, DataOutputView target) throws IOException {
        I internalRecord = this.converter.toInternal(record);
        this.internalSerializer.serialize(internalRecord, target);
    }

    public E deserialize(DataInputView source) throws IOException {
        if (this.isReuseEnabled) {
            this.reuse = this.internalSerializer.deserialize(this.reuse, source);
            return this.converter.toExternal(this.reuse);
        }
        Object internalRecord = this.internalSerializer.deserialize(source);
        return this.converter.toExternal(internalRecord);
    }

    public E deserialize(E reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.internalSerializer.copy(source, target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ExternalSerializer that = (ExternalSerializer)((Object)o);
        return this.dataType.equals(that.dataType) && this.internalSerializer.equals(that.internalSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.dataType, this.internalSerializer);
    }

    public TypeSerializerSnapshot<E> snapshotConfiguration() {
        return new ExternalSerializerSnapshot(this);
    }

    private void readObject(ObjectInputStream serialized) throws IOException, ClassNotFoundException {
        serialized.defaultReadObject();
        this.initializeConverter();
    }

    private void initializeConverter() {
        this.converter = DataStructureConverters.getConverter(this.dataType);
        this.converter.open(Thread.currentThread().getContextClassLoader());
    }

    private static boolean hasBinaryData(DataType dataType2) {
        if (dataType2.getChildren().stream().anyMatch(ExternalSerializer::hasBinaryData)) {
            return true;
        }
        Class<?> clazz = dataType2.getConversionClass();
        return clazz == RowData.class || clazz == StringData.class || clazz == ArrayData.class || clazz == MapData.class || clazz == RawValueData.class;
    }

    public static final class ExternalSerializerSnapshot<I, E>
    extends CompositeTypeSerializerSnapshot<E, ExternalSerializer<I, E>> {
        private static final int VERSION = 1;
        private DataType dataType;

        public ExternalSerializerSnapshot() {
            super(ExternalSerializer.class);
        }

        public ExternalSerializerSnapshot(ExternalSerializer<I, E> externalSerializer) {
            super(externalSerializer);
            this.dataType = ((ExternalSerializer)externalSerializer).dataType;
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream stream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)stream, (Object)this.dataType);
        }

        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            DataInputViewStream stream = new DataInputViewStream(in);
            try {
                this.dataType = (DataType)InstantiationUtil.deserializeObject((InputStream)stream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        protected TypeSerializer<?>[] getNestedSerializers(ExternalSerializer<I, E> outerSerializer) {
            return new TypeSerializer[]{((ExternalSerializer)outerSerializer).internalSerializer};
        }

        protected ExternalSerializer<I, E> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new ExternalSerializer(this.dataType, nestedSerializers[0]);
        }
    }
}

