/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections;

import org.apache.flink.table.runtime.util.MurmurHashUtil;
import org.apache.flink.table.runtime.util.collections.OptimizableHashSet;

public class ShortHashSet
extends OptimizableHashSet {
    private short[] key;
    private short min = (short)Short.MAX_VALUE;
    private short max = (short)Short.MIN_VALUE;

    public ShortHashSet(int expected, float f) {
        super(expected, f);
        this.key = new short[this.n + 1];
    }

    public ShortHashSet(int expected) {
        this(expected, 0.75f);
    }

    public ShortHashSet() {
        this(16, 0.75f);
    }

    public boolean add(short k) {
        if (k == 0) {
            if (this.containsZero) {
                return false;
            }
            this.containsZero = true;
        } else {
            short[] key = this.key;
            int pos = MurmurHashUtil.fmix(k) & this.mask;
            short curr = key[pos];
            if (curr != 0) {
                if (curr == k) {
                    return false;
                }
                while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
                    if (curr != k) continue;
                    return false;
                }
            }
            key[pos] = k;
        }
        if (this.size++ >= this.maxFill) {
            this.rehash(OptimizableHashSet.arraySize(this.size + 1, this.f));
        }
        if (k < this.min) {
            this.min = k;
        }
        if (k > this.max) {
            this.max = k;
        }
        return true;
    }

    public boolean contains(short k) {
        if (this.isDense) {
            return k >= this.min && k <= this.max && this.used[k - this.min];
        }
        if (k == 0) {
            return this.containsZero;
        }
        short[] key = this.key;
        int pos = MurmurHashUtil.fmix(k) & this.mask;
        short curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        while ((curr = key[pos = pos + 1 & this.mask]) != 0) {
            if (k != curr) continue;
            return true;
        }
        return false;
    }

    private void rehash(int newN) {
        short[] key = this.key;
        int mask = newN - 1;
        short[] newKey = new short[newN + 1];
        int i = this.n;
        int j2 = this.realSize();
        while (j2-- != 0) {
            while (key[--i] == 0) {
            }
            int pos = MurmurHashUtil.fmix(key[i]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = OptimizableHashSet.maxFill(this.n, this.f);
        this.key = newKey;
    }

    @Override
    public void optimize() {
        int range2 = this.max - this.min;
        if (range2 >= 0 && (range2 < this.key.length || range2 < 8192)) {
            this.used = new boolean[this.max - this.min + 1];
            for (short v : this.key) {
                if (v == 0) continue;
                this.used[v - this.min] = true;
            }
            if (this.containsZero) {
                this.used[-this.min] = true;
            }
            this.isDense = true;
            this.key = null;
        }
    }
}

