/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.InputGroup;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;

@Internal
final class FunctionArgumentTemplate {
    @Nullable
    final DataType dataType;
    @Nullable
    final InputGroup inputGroup;

    private FunctionArgumentTemplate(@Nullable DataType dataType2, @Nullable InputGroup inputGroup) {
        this.dataType = dataType2;
        this.inputGroup = inputGroup;
    }

    static FunctionArgumentTemplate of(DataType dataType2) {
        return new FunctionArgumentTemplate(dataType2, null);
    }

    static FunctionArgumentTemplate of(InputGroup inputGroup) {
        return new FunctionArgumentTemplate(null, inputGroup);
    }

    ArgumentTypeStrategy toArgumentTypeStrategy() {
        if (this.dataType != null) {
            return InputTypeStrategies.explicit(this.dataType);
        }
        assert (this.inputGroup != null);
        switch (this.inputGroup) {
            case ANY: {
                return InputTypeStrategies.ANY;
            }
        }
        throw ExtractionUtils.extractionError("Unsupported input group.", new Object[0]);
    }

    Class<?> toConversionClass() {
        if (this.dataType != null) {
            return this.dataType.getConversionClass();
        }
        assert (this.inputGroup != null);
        switch (this.inputGroup) {
            case ANY: {
                return Object.class;
            }
        }
        throw ExtractionUtils.extractionError("Unsupported input group.", new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionArgumentTemplate that = (FunctionArgumentTemplate)o;
        return Objects.equals(this.dataType, that.dataType) && this.inputGroup == that.inputGroup;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataType, this.inputGroup});
    }
}

