/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.UserDefinedType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class StructuredType
extends UserDefinedType {
    private static final Set<String> INPUT_OUTPUT_CONVERSION = StructuredType.conversionSet(Row.class.getName(), RowData.class.getName());
    private static final Class<?> FALLBACK_CONVERSION = Row.class;
    private final List<StructuredAttribute> attributes;
    private final boolean isInstantiable;
    private final StructuredComparision comparision;
    @Nullable
    private final StructuredType superType;
    @Nullable
    private final Class<?> implementationClass;

    private StructuredType(boolean isNullable, ObjectIdentifier objectIdentifier, List<StructuredAttribute> attributes, boolean isFinal, boolean isInstantiable, StructuredComparision comparision, @Nullable StructuredType superType, @Nullable String description, @Nullable Class<?> implementationClass) {
        super(isNullable, LogicalTypeRoot.STRUCTURED_TYPE, objectIdentifier, isFinal, description);
        Preconditions.checkArgument((objectIdentifier != null || implementationClass != null ? 1 : 0) != 0, (Object)"An identifier is missing.");
        this.attributes = attributes;
        this.isInstantiable = isInstantiable;
        this.comparision = comparision;
        this.superType = superType;
        this.implementationClass = implementationClass;
    }

    public static Builder newBuilder(ObjectIdentifier objectIdentifier) {
        return new Builder(objectIdentifier);
    }

    public static Builder newBuilder(ObjectIdentifier objectIdentifier, Class<?> implementationClass) {
        return new Builder(objectIdentifier, implementationClass);
    }

    public static Builder newBuilder(Class<?> implementationClass) {
        return new Builder(implementationClass);
    }

    public List<StructuredAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean isInstantiable() {
        return this.isInstantiable;
    }

    public StructuredComparision getComparision() {
        return this.comparision;
    }

    public Optional<StructuredType> getSuperType() {
        return Optional.ofNullable(this.superType);
    }

    public Optional<Class<?>> getImplementationClass() {
        return Optional.ofNullable(this.implementationClass);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new StructuredType(isNullable, this.getObjectIdentifier().orElse(null), this.attributes, this.isFinal(), this.isInstantiable, this.comparision, this.superType == null ? null : (StructuredType)this.superType.copy(), this.getDescription().orElse(null), this.implementationClass);
    }

    @Override
    public String asSummaryString() {
        if (this.getObjectIdentifier().isPresent()) {
            return this.asSerializableString();
        }
        assert (this.implementationClass != null);
        return "*" + this.implementationClass.getName() + "*";
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.implementationClass != null && this.implementationClass.isAssignableFrom(clazz) || INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        StructuredType currentType = this;
        while (currentType != null) {
            if (currentType.implementationClass != null && clazz.isAssignableFrom(currentType.implementationClass)) {
                return true;
            }
            currentType = currentType.superType;
        }
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        if (this.implementationClass != null) {
            return this.implementationClass;
        }
        return FALLBACK_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        ArrayList<LogicalType> children = new ArrayList<LogicalType>();
        if (this.superType != null) {
            children.addAll(this.superType.getChildren());
        }
        children.addAll(this.attributes.stream().map(StructuredAttribute::getType).collect(Collectors.toList()));
        return Collections.unmodifiableList(children);
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructuredType that = (StructuredType)o;
        return this.isInstantiable == that.isInstantiable && this.attributes.equals(that.attributes) && this.comparision == that.comparision && Objects.equals(this.superType, that.superType) && Objects.equals(this.implementationClass, that.implementationClass);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.attributes, this.isInstantiable, this.comparision, this.superType, this.implementationClass});
    }

    public static final class Builder {
        @Nullable
        private final ObjectIdentifier objectIdentifier;
        @Nullable
        private final Class<?> implementationClass;
        private List<StructuredAttribute> attributes = new ArrayList<StructuredAttribute>();
        private boolean isNullable = true;
        private boolean isFinal = true;
        private boolean isInstantiable = true;
        private StructuredComparision comparision = StructuredComparision.NONE;
        @Nullable
        private StructuredType superType;
        @Nullable
        private String description;

        public Builder(Class<?> implementationClass) {
            this.objectIdentifier = null;
            this.implementationClass = (Class)Preconditions.checkNotNull(implementationClass, (String)"Implementation class must not be null.");
        }

        public Builder(ObjectIdentifier objectIdentifier) {
            this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
            this.implementationClass = null;
        }

        public Builder(ObjectIdentifier objectIdentifier, Class<?> implementationClass) {
            this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
            this.implementationClass = (Class)Preconditions.checkNotNull(implementationClass, (String)"Implementation class must not be null.");
        }

        public Builder attributes(List<StructuredAttribute> attributes) {
            this.attributes = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(attributes, (String)"Attributes must not be null.")));
            return this;
        }

        public Builder setNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (String)"Description must not be null.");
            return this;
        }

        public Builder setFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder setInstantiable(boolean isInstantiable) {
            this.isInstantiable = isInstantiable;
            return this;
        }

        public Builder comparision(StructuredComparision comparision) {
            this.comparision = (StructuredComparision)((Object)Preconditions.checkNotNull((Object)((Object)comparision), (String)"Comparision must not be null."));
            return this;
        }

        public Builder superType(StructuredType superType) {
            this.superType = (StructuredType)Preconditions.checkNotNull((Object)superType, (String)"Super type must not be null.");
            return this;
        }

        public StructuredType build() {
            return new StructuredType(this.isNullable, this.objectIdentifier, this.attributes, this.isFinal, this.isInstantiable, this.comparision, this.superType, this.description, this.implementationClass);
        }
    }

    public static enum StructuredComparision {
        EQUALS(true, false),
        FULL(true, true),
        NONE(false, false);

        private final boolean equality;
        private final boolean comparison;

        private StructuredComparision(boolean equality, boolean comparison2) {
            this.equality = equality;
            this.comparison = comparison2;
        }

        public boolean isEquality() {
            return this.equality;
        }

        public boolean isComparison() {
            return this.comparison;
        }
    }

    public static final class StructuredAttribute
    implements Serializable {
        private final String name;
        private final LogicalType type;
        @Nullable
        private final String description;

        public StructuredAttribute(String name, LogicalType type, @Nullable String description) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Attribute name must not be null.");
            this.type = (LogicalType)Preconditions.checkNotNull((Object)type, (String)"Attribute type must not be null.");
            this.description = description;
        }

        public StructuredAttribute(String name, LogicalType type) {
            this(name, type, null);
        }

        public String getName() {
            return this.name;
        }

        public LogicalType getType() {
            return this.type;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public StructuredAttribute copy() {
            return new StructuredAttribute(this.name, this.type.copy(), this.description);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructuredAttribute that = (StructuredAttribute)o;
            return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.description, that.description);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.description);
        }
    }
}

