/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.OverWindowedTable;
import org.apache.flink.table.api.QueryConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.WindowedTable;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Alias$;
import org.apache.flink.table.expressions.Asc;
import org.apache.flink.table.expressions.Attribute;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.NamedExpression;
import org.apache.flink.table.expressions.Ordering;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.expressions.UnresolvedAlias$;
import org.apache.flink.table.expressions.UnresolvedFieldReference;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.TemporalTableFunction$;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.ProjectionTranslator$;
import org.apache.flink.table.plan.logical.Aggregate;
import org.apache.flink.table.plan.logical.AliasNode;
import org.apache.flink.table.plan.logical.BinaryNode;
import org.apache.flink.table.plan.logical.Distinct;
import org.apache.flink.table.plan.logical.Filter;
import org.apache.flink.table.plan.logical.Intersect;
import org.apache.flink.table.plan.logical.Join;
import org.apache.flink.table.plan.logical.LeafNode;
import org.apache.flink.table.plan.logical.Limit;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.LogicalTableFunctionCall;
import org.apache.flink.table.plan.logical.Minus;
import org.apache.flink.table.plan.logical.Project;
import org.apache.flink.table.plan.logical.Project$;
import org.apache.flink.table.plan.logical.Sort;
import org.apache.flink.table.plan.logical.TemporalTable;
import org.apache.flink.table.plan.logical.UnaryNode;
import org.apache.flink.table.plan.logical.Union;
import org.apache.flink.table.sinks.TableSink;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u0001\u0003\u00015\u0011Q\u0001V1cY\u0016T!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0006\r\u0005)A/\u00192mK*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0007-\u0005AA/\u00192mK\u0016sg/F\u0001\u0018!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"AA\u0004\u0001B\u0001B\u0003%q#A\u0005uC\ndW-\u00128wA!Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\fY><\u0017nY1m!2\fg.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0004m_\u001eL7-\u00197\u000b\u0005\u0015\"\u0011\u0001\u00029mC:L!a\n\u0012\u0003\u00171{w-[2bY:{G-\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005A\u0005aAn\\4jG\u0006d\u0007\u000b\\1oA!)1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!\f\u00180!\tA\u0002\u0001C\u0003\u0016U\u0001\u0007q\u0003C\u0003\u001fU\u0001\u0007\u0001\u0005C\u0003,\u0001\u0011\u0005\u0011\u0007F\u0002.eMBQ!\u0006\u0019A\u0002]AQ\u0001\u000e\u0019A\u0002U\n\u0001\"\u001e3uM\u000e\u000bG\u000e\u001c\t\u0003mer!aD\u001c\n\u0005a\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\t\t\u0011u\u0002\u0001R1A\u0005\ny\n1\u0002^1cY\u0016\u001c6\r[3nCV\tq\b\u0005\u0002\u0019\u0001&\u0011\u0011I\u0001\u0002\f)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0003\u0005D\u0001!\u0005\t\u0015)\u0003@\u00031!\u0018M\u00197f'\u000eDW-\\1!\u0011\u0015)\u0005\u0001\"\u0001G\u0003)\u0011X\r\u001c\"vS2$WM]\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nB\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0015JA\bGY&t7NU3m\u0005VLG\u000eZ3s\u0011\u0015q\u0005\u0001\"\u0001P\u0003)9W\r\u001e*fY:{G-Z\u000b\u0002!B\u0011\u0011+V\u0007\u0002%*\u00111\u000bV\u0001\u0004e\u0016d'B\u0001&\t\u0013\t1&KA\u0004SK2tu\u000eZ3\t\u000ba\u0003A\u0011\u0001 \u0002\u0013\u001d,GoU2iK6\f\u0007\"\u0002.\u0001\t\u0003Y\u0016a\u00039sS:$8k\u00195f[\u0006$\u0012\u0001\u0018\t\u0003\u001fuK!A\u0018\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\u0002!\t!Y\u0001\u0007g\u0016dWm\u0019;\u0015\u00055\u0012\u0007\"B2`\u0001\u0004!\u0017A\u00024jK2$7\u000fE\u0002\u0010K\u001eL!A\u001a\t\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002iW6\t\u0011N\u0003\u0002k\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\ta\u0017N\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u0019\u0001\u0005\u00029$\"!L8\t\u000b\rl\u0007\u0019A\u001b\t\u000bE\u0004A\u0011\u0001:\u00027\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bYR\u000b'\r\\3Gk:\u001cG/[8o)\r\u0019\u0018p\u001f\t\u0003i^l\u0011!\u001e\u0006\u0003m\u0012\t\u0011BZ;oGRLwN\\:\n\u0005a,(!\u0006+f[B|'/\u00197UC\ndWMR;oGRLwN\u001c\u0005\u0006uB\u0004\r!N\u0001\u000ei&lW-\u0011;ue&\u0014W\u000f^3\t\u000bq\u0004\b\u0019A\u001b\u0002\u0015A\u0014\u0018.\\1ss.+\u0017\u0010C\u0003r\u0001\u0011\u0005a\u0010\u0006\u0003t\u007f\u0006\u0005\u0001\"\u0002>~\u0001\u00049\u0007\"\u0002?~\u0001\u00049\u0007bBA\u0003\u0001\u0011%\u0011qA\u0001\u001dm\u0006d\u0017\u000eZ1uKB\u0013\u0018.\\1ss.+\u00170\u0012=qe\u0016\u001c8/[8o)\r)\u0014\u0011\u0002\u0005\b\u0003\u0017\t\u0019\u00011\u0001h\u0003))\u0007\u0010\u001d:fgNLwN\u001c\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003\t\t7\u000fF\u0002.\u0003'AaaYA\u0007\u0001\u0004!\u0007bBA\b\u0001\u0011\u0005\u0011q\u0003\u000b\u0004[\u0005e\u0001BB2\u0002\u0016\u0001\u0007Q\u0007C\u0004\u0002\u001e\u0001!\t!a\b\u0002\r\u0019LG\u000e^3s)\ri\u0013\u0011\u0005\u0005\b\u0003G\tY\u00021\u0001h\u0003%\u0001(/\u001a3jG\u0006$X\rC\u0004\u0002\u001e\u0001!\t!a\n\u0015\u00075\nI\u0003C\u0004\u0002$\u0005\u0015\u0002\u0019A\u001b\t\u000f\u00055\u0002\u0001\"\u0001\u00020\u0005)q\u000f[3sKR\u0019Q&!\r\t\u000f\u0005\r\u00121\u0006a\u0001O\"9\u0011Q\u0006\u0001\u0005\u0002\u0005UBcA\u0017\u00028!9\u00111EA\u001a\u0001\u0004)\u0004bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\bOJ|W\u000f\u001d\"z)\u0011\ty$!\u0012\u0011\u0007a\t\t%C\u0002\u0002D\t\u0011Ab\u0012:pkB,G\rV1cY\u0016DaaYA\u001d\u0001\u0004!\u0007bBA\u001e\u0001\u0011\u0005\u0011\u0011\n\u000b\u0005\u0003\u007f\tY\u0005\u0003\u0004d\u0003\u000f\u0002\r!\u000e\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003!!\u0017n\u001d;j]\u000e$H#A\u0017\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005!!n\\5o)\ri\u0013\u0011\f\u0005\b\u00037\n\u0019\u00061\u0001.\u0003\u0015\u0011\u0018n\u001a5u\u0011\u001d\t)\u0006\u0001C\u0001\u0003?\"R!LA1\u0003GBq!a\u0017\u0002^\u0001\u0007Q\u0006C\u0004\u0002f\u0005u\u0003\u0019A\u001b\u0002\u001b)|\u0017N\u001c)sK\u0012L7-\u0019;f\u0011\u001d\t)\u0006\u0001C\u0001\u0003S\"R!LA6\u0003[Bq!a\u0017\u0002h\u0001\u0007Q\u0006C\u0004\u0002f\u0005\u001d\u0004\u0019A4\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005iA.\u001a4u\u001fV$XM\u001d&pS:$2!LA;\u0011\u001d\tY&a\u001cA\u00025Bq!!\u001d\u0001\t\u0003\tI\bF\u0003.\u0003w\ni\bC\u0004\u0002\\\u0005]\u0004\u0019A\u0017\t\u000f\u0005\u0015\u0014q\u000fa\u0001k!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005\u0005E#B\u0017\u0002\u0004\u0006\u0015\u0005bBA.\u0003\u007f\u0002\r!\f\u0005\b\u0003K\ny\b1\u0001h\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000baB]5hQR|U\u000f^3s\u0015>Lg\u000eF\u0003.\u0003\u001b\u000by\tC\u0004\u0002\\\u0005\u001d\u0005\u0019A\u0017\t\u000f\u0005\u0015\u0014q\u0011a\u0001k!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005ME#B\u0017\u0002\u0016\u0006]\u0005bBA.\u0003#\u0003\r!\f\u0005\b\u0003K\n\t\n1\u0001h\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000bQBZ;mY>+H/\u001a:K_&tG#B\u0017\u0002 \u0006\u0005\u0006bBA.\u00033\u0003\r!\f\u0005\b\u0003K\nI\n1\u00016\u0011\u001d\tY\n\u0001C\u0001\u0003K#R!LAT\u0003SCq!a\u0017\u0002$\u0002\u0007Q\u0006C\u0004\u0002f\u0005\r\u0006\u0019A4\t\u000f\u0005U\u0003\u0001\"\u0003\u0002.R9Q&a,\u00022\u0006M\u0006bBA.\u0003W\u0003\r!\f\u0005\b\u0003K\nY\u000b1\u00016\u0011!\t),a+A\u0002\u0005]\u0016\u0001\u00036pS:$\u0016\u0010]3\u0011\t\u0005e\u0016qY\u0007\u0003\u0003wSA!!\u0016\u0002>*!\u0011qXAa\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0003\u0002D\u0006\u0015\u0017\u0001\u00026bm\u0006T!a\u0001\u0004\n\t\u0005%\u00171\u0018\u0002\t\u0015>Lg\u000eV=qK\"9\u0011Q\u000b\u0001\u0005\n\u00055GcB\u0017\u0002P\u0006E\u0017\u0011\u001c\u0005\b\u00037\nY\r1\u0001.\u0011!\t)'a3A\u0002\u0005M\u0007\u0003B\b\u0002V\u001eL1!a6\u0011\u0005\u0019y\u0005\u000f^5p]\"A\u0011QWAf\u0001\u0004\t9\fC\u0004\u0002^\u0002!\t!a8\u0002\u000b5Lg.^:\u0015\u00075\n\t\u000fC\u0004\u0002\\\u0005m\u0007\u0019A\u0017\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006AQ.\u001b8vg\u0006cG\u000eF\u0002.\u0003SDq!a\u0017\u0002d\u0002\u0007Q\u0006C\u0004\u0002n\u0002!\t!a<\u0002\u000bUt\u0017n\u001c8\u0015\u00075\n\t\u0010C\u0004\u0002\\\u0005-\b\u0019A\u0017\t\u000f\u0005U\b\u0001\"\u0001\u0002x\u0006AQO\\5p]\u0006cG\u000eF\u0002.\u0003sDq!a\u0017\u0002t\u0002\u0007Q\u0006C\u0004\u0002~\u0002!\t!a@\u0002\u0013%tG/\u001a:tK\u000e$HcA\u0017\u0003\u0002!9\u00111LA~\u0001\u0004i\u0003b\u0002B\u0003\u0001\u0011\u0005!qA\u0001\rS:$XM]:fGR\fE\u000e\u001c\u000b\u0004[\t%\u0001bBA.\u0005\u0007\u0001\r!\f\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003\u001dy'\u000fZ3s\u0005f$2!\fB\t\u0011\u0019\u0019'1\u0002a\u0001I\"9!Q\u0002\u0001\u0005\u0002\tUAcA\u0017\u0003\u0018!11Ma\u0005A\u0002UBqAa\u0007\u0001\t\u0003\u0011i\"\u0001\u0004pM\u001a\u001cX\r\u001e\u000b\u0004[\t}\u0001\u0002\u0003B\u000e\u00053\u0001\rA!\t\u0011\u0007=\u0011\u0019#C\u0002\u0003&A\u00111!\u00138u\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005W\tQAZ3uG\"$2!\fB\u0017\u0011!\u0011ICa\nA\u0002\t\u0005\u0002b\u0002B\u0019\u0001\u0011\u0005!1G\u0001\foJLG/\u001a+p'&t7.\u0006\u0003\u00036\t-Cc\u0001/\u00038!A!\u0011\bB\u0018\u0001\u0004\u0011Y$\u0001\u0003tS:\\\u0007C\u0002B\u001f\u0005\u0007\u00129%\u0004\u0002\u0003@)\u0019!\u0011\t\u0003\u0002\u000bMLgn[:\n\t\t\u0015#q\b\u0002\n)\u0006\u0014G.Z*j].\u0004BA!\u0013\u0003L1\u0001A\u0001\u0003B'\u0005_\u0011\rAa\u0014\u0003\u0003Q\u000bBA!\u0015\u0003XA\u0019qBa\u0015\n\u0007\tU\u0003CA\u0004O_RD\u0017N\\4\u0011\u0007=\u0011I&C\u0002\u0003\\A\u00111!\u00118zQ\u0011\u0011yCa\u0018\u0011\t\t\u0005$\u0011N\u0007\u0003\u0005GRAA!\u001a\u0003h\u0005!A.\u00198h\u0015\t\t\u0019-\u0003\u0003\u0003l\t\r$A\u0003#faJ,7-\u0019;fI\"B!q\u0006B8\u0005k\u0012I\bE\u0002\u0010\u0005cJ1Aa\u001d\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0005o\na\u000b\u00165jg\u0002jW\r\u001e5pI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$g\u0006\t)mK\u0006\u001cX\r\t:fO&\u001cH/\u001a:!i\",\u0007\u0005V1cY\u0016\u001c\u0016N\\6!C:$\u0007%^:fAQ\u000b'\r\\3/S:\u001cXM\u001d;J]R|\u0007&\u000b\u0018\"\u0005\tm\u0014!B\u0019/o9\u0002\u0004b\u0002B\u0019\u0001\u0011\u0005!qP\u000b\u0005\u0005\u0003\u0013I\tF\u0003]\u0005\u0007\u0013Y\t\u0003\u0005\u0003:\tu\u0004\u0019\u0001BC!\u0019\u0011iDa\u0011\u0003\bB!!\u0011\nBE\t!\u0011iE! C\u0002\t=\u0003\u0002\u0003BG\u0005{\u0002\rAa$\u0002\t\r|gN\u001a\t\u00041\tE\u0015b\u0001BJ\u0005\tY\u0011+^3ss\u000e{gNZ5hQ\u0011\u0011iHa\u0018)\u0011\tu$q\u000eB;\u0005sBqAa'\u0001\t\u0003\u0011i*\u0001\u0006j]N,'\u000f^%oi>$2\u0001\u0018BP\u0011\u001d\u0011\tK!'A\u0002U\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\tm\u0005\u0001\"\u0001\u0003&R)ALa*\u0003*\"9!\u0011\u0015BR\u0001\u0004)\u0004\u0002\u0003BG\u0005G\u0003\rAa$\t\u000f\t5\u0006\u0001\"\u0001\u00030\u00061q/\u001b8e_^$BA!-\u00038B\u0019\u0001Da-\n\u0007\tU&AA\u0007XS:$wn^3e)\u0006\u0014G.\u001a\u0005\t\u0005[\u0013Y\u000b1\u0001\u0003:B\u0019\u0001Da/\n\u0007\tu&A\u0001\u0004XS:$wn\u001e\u0005\b\u0005[\u0003A\u0011\u0001Ba)\u0011\u0011\u0019M!3\u0011\u0007a\u0011)-C\u0002\u0003H\n\u0011\u0011c\u0014<fe^Kg\u000eZ8xK\u0012$\u0016M\u00197f\u0011!\u0011YMa0A\u0002\t5\u0017aC8wKJ<\u0016N\u001c3poN\u0004BaD3\u0003PB\u0019\u0001D!5\n\u0007\tM'A\u0001\u0006Pm\u0016\u0014x+\u001b8e_^DCAa0\u0003XB!!\u0011\u001cBp\u001b\t\u0011YNC\u0002\u0003^B\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tOa7\u0003\u000fY\f'/\u0019:hg\"Y!\u0011\u0015\u0001A\u0002\u0003\u0007I\u0011\u0001Bs+\u0005)\u0004b\u0003Bu\u0001\u0001\u0007\t\u0019!C\u0001\u0005W\fQ\u0002^1cY\u0016t\u0015-\\3`I\u0015\fHc\u0001/\u0003n\"I!q\u001eBt\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0004b\u0002Bz\u0001\u0001\u0006K!N\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003b\u0002B|\u0001\u0011\u0005#\u0011`\u0001\ti>\u001cFO]5oOR\tQ\u0007C\u0004\u0003~\u0002!IAa@\u00023\r|g\u000e^1j]N,fNY8v]\u0012,G-\u0016#U\r\u000e\u000bG\u000e\u001c\u000b\u0005\u0007\u0003\u00199\u0001E\u0002\u0010\u0007\u0007I1a!\u0002\u0011\u0005\u001d\u0011un\u001c7fC:Dqa!\u0003\u0003|\u0002\u0007\u0001%A\u0001o\u0001")
public class Table {
    private final TableEnvironment tableEnv;
    private final LogicalNode logicalPlan;
    private TableSchema tableSchema;
    private String tableName;
    private volatile boolean bitmap$0;

    private TableSchema tableSchema$lzycompute() {
        Table table = this;
        synchronized (table) {
            if (!this.bitmap$0) {
                this.tableSchema = new TableSchema((String[])((TraversableOnce)this.logicalPlan().output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Attribute x$1) {
                        return x$1.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((TraversableOnce)this.logicalPlan().output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeInformation<?> apply(Attribute x$2) {
                        return x$2.resultType();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
                this.bitmap$0 = true;
            }
            return this.tableSchema;
        }
    }

    public OverWindowedTable window(OverWindow ... overWindows) {
        return this.window((Seq<OverWindow>)Predef$.MODULE$.wrapRefArray((Object[])overWindows));
    }

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public LogicalNode logicalPlan() {
        return this.logicalPlan;
    }

    private TableSchema tableSchema() {
        return this.bitmap$0 ? this.tableSchema : this.tableSchema$lzycompute();
    }

    public FlinkRelBuilder relBuilder() {
        return this.tableEnv().getRelBuilder();
    }

    public RelNode getRelNode() {
        if (this.containsUnboundedUDTFCall(this.logicalPlan())) {
            throw new ValidationException("Cannot translate a query with an unbounded table function call.");
        }
        return this.logicalPlan().toRelNode(this.relBuilder());
    }

    public TableSchema getSchema() {
        return this.tableSchema();
    }

    public void printSchema() {
        Predef$.MODULE$.print((Object)this.tableSchema().toString());
    }

    public Table select(Seq<Expression> fields) {
        Seq<Expression> expandedFields = ProjectionTranslator$.MODULE$.expandProjectList(fields, this.logicalPlan(), this.tableEnv());
        Tuple2<Map<Expression, String>, Map<Expression, String>> tuple2 = ProjectionTranslator$.MODULE$.extractAggregationsAndProperties(expandedFields, this.tableEnv());
        if (tuple2 != null) {
            Table table;
            Tuple2 tuple22;
            Map aggNames = (Map)tuple2._1();
            Map propNames = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)aggNames, (Object)propNames);
            Map aggNames2 = (Map)tuple23._1();
            Map propNames2 = (Map)tuple23._2();
            if (propNames2.nonEmpty()) {
                throw new ValidationException("Window properties can only be used on windowed tables.");
            }
            if (aggNames2.nonEmpty()) {
                Seq<NamedExpression> projectsOnAgg = ProjectionTranslator$.MODULE$.replaceAggregationsAndProperties(expandedFields, this.tableEnv(), (Map<Expression, String>)aggNames2, (Map<Expression, String>)propNames2);
                Seq<NamedExpression> projectFields = ProjectionTranslator$.MODULE$.extractFieldReferences(expandedFields);
                table = new Table(this.tableEnv(), new Project(projectsOnAgg, new Aggregate((Seq<Expression>)Nil$.MODULE$, (Seq<NamedExpression>)((TraversableOnce)aggNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Alias apply(Tuple2<Expression, String> a) {
                        return new Alias((Expression)a._1(), (String)a._2(), Alias$.MODULE$.apply$default$3());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq(), new Project(projectFields, this.logicalPlan(), Project$.MODULE$.apply$default$3()).validate(this.tableEnv())).validate(this.tableEnv()), Project$.MODULE$.apply$default$3()).validate(this.tableEnv()));
            } else {
                table = new Table(this.tableEnv(), new Project((Seq<NamedExpression>)((Seq)expandedFields.map((Function1)UnresolvedAlias$.MODULE$, Seq$.MODULE$.canBuildFrom())), this.logicalPlan(), Project$.MODULE$.apply$default$3()).validate(this.tableEnv()));
            }
            return table;
        }
        throw new MatchError(tuple2);
    }

    public Table select(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        List withResolvedAggFunctionCall = (List)fieldExprs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Table $outer;

            public final Expression apply(Expression x$4) {
                return ProjectionTranslator$.MODULE$.replaceAggFunctionCall(x$4, this.$outer.tableEnv());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return this.select((Seq<Expression>)withResolvedAggFunctionCall);
    }

    public TemporalTableFunction createTemporalTableFunction(String timeAttribute, String primaryKey) {
        return this.createTemporalTableFunction(ExpressionParser$.MODULE$.parseExpression(timeAttribute), ExpressionParser$.MODULE$.parseExpression(primaryKey));
    }

    public TemporalTableFunction createTemporalTableFunction(Expression timeAttribute, Expression primaryKey) {
        TemporalTable temporalTable = (TemporalTable)new TemporalTable(timeAttribute, primaryKey, this.logicalPlan()).validate(this.tableEnv());
        return TemporalTableFunction$.MODULE$.create(this, temporalTable.timeAttribute(), this.validatePrimaryKeyExpression(temporalTable.primaryKey()));
    }

    private String validatePrimaryKeyExpression(Expression expression2) {
        Expression expression3 = expression2;
        if (expression3 instanceof ResolvedFieldReference) {
            ResolvedFieldReference resolvedFieldReference = (ResolvedFieldReference)expression3;
            String string = resolvedFieldReference.name();
            return string;
        }
        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported expression [", "] as primary key. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expression2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only top-level (not nested) field references are supported."})).s((Seq)Nil$.MODULE$)).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table as(Seq<Expression> fields) {
        LogicalNode logicalNode = this.logicalPlan();
        if (!(logicalNode instanceof LogicalTableFunctionCall)) return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
        LogicalTableFunctionCall logicalTableFunctionCall = (LogicalTableFunctionCall)logicalNode;
        if (logicalTableFunctionCall.child() != null) return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
        if (fields.length() != logicalTableFunctionCall.output().length()) {
            throw new ValidationException("List of column aliases must have same degree as TableFunction's output");
        }
        if (!fields.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$5) {
                return x$5 instanceof UnresolvedFieldReference;
            }
        })) throw new ValidationException("Alias field must be an instance of UnresolvedFieldReference");
        return new Table(this.tableEnv(), new LogicalTableFunctionCall(logicalTableFunctionCall.functionName(), logicalTableFunctionCall.tableFunction(), logicalTableFunctionCall.parameters(), logicalTableFunctionCall.resultType(), (String[])((TraversableOnce)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$6) {
                return ((UnresolvedFieldReference)x$6).name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), logicalTableFunctionCall.child()));
    }

    public Table as(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.as((Seq<Expression>)fieldExprs);
    }

    public Table filter(Expression predicate) {
        return new Table(this.tableEnv(), new Filter(predicate, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table filter(String predicate) {
        Expression predicateExpr = ExpressionParser$.MODULE$.parseExpression(predicate);
        return this.filter(predicateExpr);
    }

    public Table where(Expression predicate) {
        return this.filter(predicate);
    }

    public Table where(String predicate) {
        return this.filter(predicate);
    }

    public GroupedTable groupBy(Seq<Expression> fields) {
        return new GroupedTable(this, fields);
    }

    public GroupedTable groupBy(String fields) {
        List<Expression> fieldsExpr = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.groupBy((Seq<Expression>)fieldsExpr);
    }

    public Table distinct() {
        return new Table(this.tableEnv(), new Distinct(this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table join(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.INNER);
    }

    public Table join(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.INNER);
    }

    public Table join(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.INNER);
    }

    public Table leftOuterJoin(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.LEFT_OUTER);
    }

    public Table rightOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.RIGHT_OUTER);
    }

    public Table rightOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.RIGHT_OUTER);
    }

    public Table fullOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.FULL_OUTER);
    }

    public Table fullOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.FULL_OUTER);
    }

    private Table join(Table right, String joinPredicate, JoinType joinType) {
        Expression joinPredicateExpr = ExpressionParser$.MODULE$.parseExpression(joinPredicate);
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicateExpr), joinType);
    }

    private Table join(Table right, Option<Expression> joinPredicate, JoinType joinType) {
        block6: {
            Table table;
            block5: {
                block2: {
                    block4: {
                        block3: {
                            if (!this.containsUnboundedUDTFCall(right.logicalPlan())) break block2;
                            JoinType joinType2 = joinType;
                            JoinType joinType3 = JoinType.INNER;
                            if (!(joinType2 == null ? joinType3 != null : !joinType2.equals(joinType3))) break block3;
                            JoinType joinType4 = joinType;
                            JoinType joinType5 = JoinType.LEFT_OUTER;
                            if (joinType4 != null ? !joinType4.equals(joinType5) : joinType5 != null) break block4;
                        }
                        LogicalTableFunctionCall udtf = (LogicalTableFunctionCall)right.logicalPlan();
                        LogicalNode udtfCall = new LogicalTableFunctionCall(udtf.functionName(), udtf.tableFunction(), udtf.parameters(), udtf.resultType(), udtf.fieldNames(), this.logicalPlan()).validate(this.tableEnv());
                        table = new Table(this.tableEnv(), new Join(this.logicalPlan(), udtfCall, joinType, joinPredicate, true).validate(this.tableEnv()));
                        break block5;
                    }
                    throw new ValidationException("TableFunctions are currently supported for join and leftOuterJoin.");
                }
                TableEnvironment tableEnvironment = right.tableEnv();
                TableEnvironment tableEnvironment2 = this.tableEnv();
                if (tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null) break block6;
                table = new Table(this.tableEnv(), new Join(this.logicalPlan(), right.logicalPlan(), joinType, joinPredicate, false).validate(this.tableEnv()));
            }
            return table;
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be joined.");
    }

    public Table minus(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table minusAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table union(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table unionAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table intersect(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table intersectAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table orderBy(Seq<Expression> fields) {
        Seq order = (Seq)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Ordering apply(Expression x0$1) {
                Ordering ordering;
                Expression expression2 = x0$1;
                Ordering ordering2 = expression2 instanceof Ordering ? (ordering = (Ordering)expression2) : new Asc(expression2);
                return ordering2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Table(this.tableEnv(), new Sort((Seq<Ordering>)order, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table orderBy(String fields) {
        List<Expression> parsedFields = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.orderBy((Seq<Expression>)parsedFields);
    }

    public Table offset(int offset) {
        return new Table(this.tableEnv(), new Limit(offset, -1, this.logicalPlan()).validate(this.tableEnv()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table fetch(int fetch) {
        if (fetch < 0) {
            throw new ValidationException("FETCH count must be equal or larger than 0.");
        }
        boolean bl = false;
        Limit limit = null;
        LogicalNode logicalNode = this.logicalPlan();
        if (logicalNode instanceof Limit) {
            bl = true;
            limit = (Limit)logicalNode;
            int o = limit.offset();
            int n = limit.fetch();
            LogicalNode c = limit.child();
            if (-1 == n) {
                return new Table(this.tableEnv(), new Limit(o, fetch, c).validate(this.tableEnv()));
            }
        }
        if (!bl) return new Table(this.tableEnv(), new Limit(0, fetch, this.logicalPlan()).validate(this.tableEnv()));
        throw new ValidationException("FETCH is already defined.");
    }

    @Deprecated
    public <T> void writeToSink(TableSink<T> sink) {
        Option option = Option$.MODULE$.apply((Object)this.tableEnv());
        QueryConfig queryConfig = None$.MODULE$.equals(option) ? null : this.tableEnv().queryConfig();
        QueryConfig queryConfig2 = queryConfig;
        this.writeToSink(sink, queryConfig2);
    }

    @Deprecated
    public <T> void writeToSink(TableSink<T> sink, QueryConfig conf) {
        RelDataType rowType = this.getRelNode().getRowType();
        String[] fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataTypeField field) {
                return FlinkTypeFactory$.MODULE$.toTypeInfo(field.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(TypeInformation<?> x0$2) {
                TypeInformation<?> typeInformation;
                block4: {
                    Object object;
                    block3: {
                        TypeInformation<?> typeInformation2;
                        block2: {
                            TypeInformation<?> typeInformation3;
                            typeInformation = x0$2;
                            if (typeInformation == null || !FlinkTypeFactory$.MODULE$.isTimeIndicatorType(typeInformation3 = typeInformation)) break block2;
                            object = Types$.MODULE$.SQL_TIMESTAMP();
                            break block3;
                        }
                        if (typeInformation == null) break block4;
                        object = typeInformation2 = typeInformation;
                    }
                    return object;
                }
                throw new MatchError(typeInformation);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
        TableSink<T> configuredSink = sink.configure(fieldNames, fieldTypes);
        this.tableEnv().writeToSink(this, configuredSink, conf);
    }

    public void insertInto(String tableName) {
        LogicalNode logicalNode = this.logicalPlan();
        if (logicalNode instanceof LogicalTableFunctionCall) {
            throw new ValidationException("TableFunction can only be used in join and leftOuterJoin.");
        }
        this.tableEnv().insertInto(this, tableName, this.tableEnv().queryConfig());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void insertInto(String tableName, QueryConfig conf) {
        LogicalNode logicalNode = this.logicalPlan();
        if (logicalNode instanceof LogicalTableFunctionCall) {
            throw new ValidationException("TableFunction can only be used in join and leftOuterJoin.");
        }
        this.tableEnv().insertInto(this, tableName, conf);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public WindowedTable window(Window window) {
        return new WindowedTable(this, window);
    }

    public OverWindowedTable window(Seq<OverWindow> overWindows) {
        if (this.tableEnv() instanceof BatchTableEnvironment) {
            throw new TableException("Over-windows for batch tables are currently not supported.");
        }
        if (overWindows.size() != 1) {
            throw new TableException("Over-Windows are currently only supported single window.");
        }
        return new OverWindowedTable(this, (OverWindow[])overWindows.toArray(ClassTag$.MODULE$.apply(OverWindow.class)));
    }

    public String tableName() {
        return this.tableName;
    }

    public void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public String toString() {
        if (this.tableName() == null) {
            this.tableName_$eq(new StringBuilder().append((Object)"UnnamedTable$").append((Object)BoxesRunTime.boxToInteger((int)this.tableEnv().attrNameCntr().getAndIncrement())).toString());
            this.tableEnv().registerTable(this.tableName(), this);
        }
        return this.tableName();
    }

    private boolean containsUnboundedUDTFCall(LogicalNode n) {
        LogicalNode logicalNode;
        block9: {
            boolean bl;
            block8: {
                while (true) {
                    LogicalTableFunctionCall logicalTableFunctionCall;
                    if ((logicalNode = n) instanceof LogicalTableFunctionCall && (logicalTableFunctionCall = (LogicalTableFunctionCall)logicalNode).child() == null) {
                        bl = true;
                        break block8;
                    }
                    if (logicalNode instanceof UnaryNode) {
                        UnaryNode unaryNode = (UnaryNode)logicalNode;
                        n = unaryNode.child();
                        continue;
                    }
                    if (!(logicalNode instanceof BinaryNode)) break;
                    BinaryNode binaryNode = (BinaryNode)logicalNode;
                    if (this.containsUnboundedUDTFCall(binaryNode.left())) {
                        bl = true;
                        break block8;
                    }
                    n = binaryNode.right();
                }
                if (!(logicalNode instanceof LeafNode)) break block9;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)logicalNode);
    }

    public Table(TableEnvironment tableEnv, LogicalNode logicalPlan) {
        this.tableEnv = tableEnv;
        this.logicalPlan = logicalPlan;
        if (this.containsUnboundedUDTFCall(logicalPlan) && !(logicalPlan instanceof LogicalTableFunctionCall)) {
            throw new ValidationException("TableFunction can only be used in join and leftOuterJoin.");
        }
    }

    public Table(TableEnvironment tableEnv, String udtfCall) {
        this(tableEnv, UserDefinedFunctionUtils$.MODULE$.createLogicalFunctionCall(tableEnv, udtfCall));
    }
}

