/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001=\u0011!DU8x)&lWmU8siB\u0013xnY3tg\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u0005\u0019\u0011\r]5\u000b\u0005]A\u0011!C:ue\u0016\fW.\u001b8h\u0013\tI\"CA\bQe>\u001cWm]:Gk:\u001cG/[8o!\tYb$D\u0001\u001d\u0015\tiB!A\u0003usB,7/\u0003\u0002 9\t!1IU8x\u0011!\t\u0003A!b\u0001\n\u0013\u0011\u0013\u0001D5oaV$(k\\<UsB,W#A\u0012\u0011\u0005m!\u0013BA\u0013\u001d\u00051\u0019%k\\<UsB,\u0017J\u001c4p\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!D5oaV$(k\\<UsB,\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0003+\u0003)\u0011xn\u001e;j[\u0016LE\r_\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t\u0019\u0011J\u001c;\t\u0011I\u0002!\u0011!Q\u0001\n-\n1B]8xi&lW-\u00133yA!AA\u0007\u0001BC\u0002\u0013%Q'A\u0007s_^\u001cu.\u001c9be\u0006$xN]\u000b\u0002mA\u0019AfN\u001d\n\u0005aj#AB(qi&|g\u000e\u0005\u0002;w5\t!!\u0003\u0002=\u0005\t92i\u001c7mK\u000e$\u0018n\u001c8S_^\u001cu.\u001c9be\u0006$xN\u001d\u0005\t}\u0001\u0011\t\u0011)A\u0005m\u0005q!o\\<D_6\u0004\u0018M]1u_J\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u001e\u0001\u0011\u0015\ts\b1\u0001$\u0011\u0015Is\b1\u0001,\u0011\u0015!t\b1\u00017\u0011%9\u0005\u00011AA\u0002\u0013%\u0001*A\u0005eCR\f7\u000b^1uKV\t\u0011\n\u0005\u0003K!J+V\"A&\u000b\u00051k\u0015!B:uCR,'B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011Q\u0003C\u0005\u0003#.\u0013\u0001\"T1q'R\fG/\u001a\t\u0003YMK!\u0001V\u0017\u0003\t1{gn\u001a\t\u0004-nkV\"A,\u000b\u0005aK\u0016\u0001B;uS2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n!A*[:u!\tq\u0006-D\u0001`\u0015\ti\u0002\"\u0003\u0002b?\n\u0019!k\\<\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0017!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002fQB\u0011AFZ\u0005\u0003O6\u0012A!\u00168ji\"9\u0011NYA\u0001\u0002\u0004I\u0015a\u0001=%c!11\u000e\u0001Q!\n%\u000b!\u0002Z1uCN#\u0018\r^3!\u0011%i\u0007\u00011AA\u0002\u0013%a.A\u000bmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3\u0016\u0003=\u00042A\u00139S\u0013\t\t8J\u0001\u0006WC2,Xm\u0015;bi\u0016D\u0011b\u001d\u0001A\u0002\u0003\u0007I\u0011\u0002;\u000231\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK~#S-\u001d\u000b\u0003KVDq!\u001b:\u0002\u0002\u0003\u0007q\u000e\u0003\u0004x\u0001\u0001\u0006Ka\\\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!I\u0011\u0010\u0001a\u0001\u0002\u0004%IA_\u0001\b_V$\b/\u001e;D+\u0005Q\u0002\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0003-yW\u000f\u001e9vi\u000e{F%Z9\u0015\u0005\u0015t\bbB5|\u0003\u0003\u0005\rA\u0007\u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003\u001b\u0003!yW\u000f\u001e9vi\u000e\u0003\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\u0005_B,g\u000eF\u0002f\u0003\u0013A\u0001\"a\u0003\u0002\u0004\u0001\u0007\u0011QB\u0001\u0007G>tg-[4\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011qCA\t\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111\u0004\u0001\u0005B\u0005u\u0011A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\bK\u0006}\u00111EA\u0017\u0011\u001d\t\t#!\u0007A\u0002i\ta!\u001b8qkR\u001c\u0005\u0002CA\u0013\u00033\u0001\r!a\n\u0002\u0007\r$\b\u0010E\u0002\u0011\u0003SI1!a\u000b\u0019\u0005\u001d\u0019uN\u001c;fqRD\u0001\"a\f\u0002\u001a\u0001\u0007\u0011\u0011G\u0001\u0004_V$\b#BA\u001a\u0003oQRBAA\u001b\u0015\tA\u0006\"\u0003\u0003\u0002:\u0005U\"!C\"pY2,7\r^8s\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\tqa\u001c8US6,'\u000fF\u0004f\u0003\u0003\n)%!\u0014\t\u000f\u0005\r\u00131\ba\u0001%\u0006IA/[7fgR\fW\u000e\u001d\u0005\t\u0003K\tY\u00041\u0001\u0002HA\u0019\u0001#!\u0013\n\u0007\u0005-\u0003D\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005=\u00121\ba\u0001\u0003c\u0001")
public class RowTimeSortProcessFunction
extends ProcessFunction<CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final int rowtimeIdx;
    private final Option<CollectionRowComparator> rowComparator;
    private MapState<Object, List<Row>> dataState;
    private ValueState<Object> lastTriggeringTsState;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private Option<CollectionRowComparator> rowComparator() {
        return this.rowComparator;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType().rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long lastTriggeringTs;
        Row input = inputC.row();
        long rowtime2 = BoxesRunTime.unboxToLong((Object)input.getField(this.rowtimeIdx()));
        if (rowtime2 > (lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value()))) {
            List rows = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)rowtime2));
            if (rows == null) {
                ArrayList<Row> rows2 = new ArrayList<Row>();
                rows2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime2), rows2);
                ctx.timerService().registerEventTimeTimer(rowtime2);
            } else {
                rows.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime2), (Object)rows);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            if (this.rowComparator().isDefined()) {
                Collections.sort(inputs, (Comparator)this.rowComparator().get());
            }
            for (int i = 0; i < inputs.size(); ++i) {
                this.outputC().row_$eq((Row)inputs.get(i));
                out.collect((Object)this.outputC());
            }
            this.dataState().remove((Object)BoxesRunTime.boxToLong((long)timestamp));
            this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        }
    }

    public RowTimeSortProcessFunction(CRowTypeInfo inputRowType, int rowtimeIdx, Option<CollectionRowComparator> rowComparator) {
        this.inputRowType = inputRowType;
        this.rowtimeIdx = rowtimeIdx;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull(rowComparator);
    }
}

