/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.runtime.CRowWrappingCollector;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tug\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001\u0002eI\u001aH!\r\t\u0002DG\u0007\u0002%)\u00111\u0003F\u0001\n_B,'/\u0019;peNT!!\u0006\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0018\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00033I\u0011a#\u00112tiJ\f7\r^*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\tQ\u0001^=qKNL!a\b\u000f\u0003\t\r\u0013vn\u001e\t\u0006#\u0005R\"DG\u0005\u0003EI\u0011a\u0003V<p\u0013:\u0004X\u000f^*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u0005#\u00112C&\u0003\u0002&%\tYAK]5hO\u0016\u0014\u0018M\u00197f!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\r\te.\u001f\t\u0003[Ej\u0011A\f\u0006\u0003_A\nQa\u001d;bi\u0016T!!\u0002\u0005\n\u0005Ir#!\u0004,pS\u0012t\u0015-\\3ta\u0006\u001cW\rE\u00025oej\u0011!\u000e\u0006\u0003m\u0019\tqaY8eK\u001e,g.\u0003\u00029k\tA1i\\7qS2,'\u000fE\u0003;\u0001\n\u0013%)D\u0001<\u0015\taT(A\u0005gk:\u001cG/[8og*\u0011ahP\u0001\u0007G>lWn\u001c8\u000b\u0005UA\u0011BA!<\u0005A1E.\u0019;K_&tg)\u001e8di&|g\u000e\u0005\u0002D\u000b6\tAI\u0003\u0002\u001e\u0011%\u0011a\t\u0012\u0002\u0004%><\bC\u0001%L\u001b\u0005I%B\u0001&\u0007\u0003\u0011)H/\u001b7\n\u00051K%a\u0002'pO\u001eLgn\u001a\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\u0006AA.\u001a4u)f\u0004X\rE\u0002Q'\nk\u0011!\u0015\u0006\u0003%v\n\u0001\u0002^=qK&tgm\\\u0005\u0003)F\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001f\u0006I!/[4iiRK\b/\u001a\u0005\t1\u0002\u0011\t\u0011)A\u00053\u0006yq-\u001a8K_&tg)\u001e8d\u001d\u0006lW\r\u0005\u0002[;:\u0011qeW\u0005\u00039\"\na\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A\f\u000b\u0005\tC\u0002\u0011\t\u0011)A\u00053\u0006yq-\u001a8K_&tg)\u001e8d\u0007>$W\r\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0003-\tX/\u001a:z\u0007>tg-[4\u0011\u0005\u0015<W\"\u00014\u000b\u0005U1\u0011B\u00015g\u0005E\u0019FO]3b[F+XM]=D_:4\u0017n\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\u0006\tB.\u001a4u)&lW-\u0011;ue&\u0014W\u000f^3\u0011\u0005\u001db\u0017BA7)\u0005\rIe\u000e\u001e\u0005\t_\u0002\u0011\t\u0011)A\u0005W\u0006\u0011\"/[4iiRKW.Z!uiJL'-\u001e;f\u0011\u0015\t\b\u0001\"\u0001s\u0003\u0019a\u0014N\\5u}QA1/\u001e<xqfT8\u0010\u0005\u0002u\u00015\t!\u0001C\u0003Oa\u0002\u0007q\nC\u0003Wa\u0002\u0007q\nC\u0003Ya\u0002\u0007\u0011\fC\u0003ba\u0002\u0007\u0011\fC\u0003da\u0002\u0007A\rC\u0003ka\u0002\u00071\u000eC\u0003pa\u0002\u00071\u000eC\u0004~\u0001\t\u0007I\u0011\u0002@\u000259+\u0005\fV0M\u000b\u001a#v,\u0013(E\u000bb{6\u000bV!U\u000b~s\u0015)T#\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003mC:<'BAA\u0005\u0003\u0011Q\u0017M^1\n\u0007y\u000b\u0019\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\u000279+\u0005\fV0M\u000b\u001a#v,\u0013(E\u000bb{6\u000bV!U\u000b~s\u0015)T#!\u0011!\t\u0019\u0002\u0001b\u0001\n\u0013q\u0018a\u0004'F\rR{6\u000bV!U\u000b~s\u0015)T#\t\u000f\u0005]\u0001\u0001)A\u0005\u007f\u0006\u0001B*\u0012$U?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\t\u00037\u0001!\u0019!C\u0005}\u0006\u0001\"+S$I)~\u001bF+\u0011+F?:\u000bU*\u0012\u0005\b\u0003?\u0001\u0001\u0015!\u0003\u0000\u0003E\u0011\u0016j\u0012%U?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\t\u0003G\u0001!\u0019!C\u0005}\u0006Y\"+R$J'R+%+\u0012#`)&kUIU0T)\u0006#Vi\u0018(B\u001b\u0016Cq!a\n\u0001A\u0003%q0\u0001\u000fS\u000b\u001eK5\u000bV#S\u000b\u0012{F+S'F%~\u001bF+\u0011+F?:\u000bU*\u0012\u0011\t\u0011\u0005-\u0002A1A\u0005\ny\f\u0011\u0003V%N\u000bJ\u001bvl\u0015+B)\u0016{f*Q'F\u0011\u001d\ty\u0003\u0001Q\u0001\n}\f!\u0003V%N\u000bJ\u001bvl\u0015+B)\u0016{f*Q'FA!I\u00111\u0007\u0001C\u0002\u0013%\u0011QG\u0001\u0017e&<\u0007\u000e\u001e*poRLW.Z\"p[B\f'/\u0019;peV\u0011\u0011q\u0007\t\u0004i\u0006e\u0012bAA\u001e\u0005\t\t\"k\\<uS6,7i\\7qCJ\fGo\u001c:\t\u0011\u0005}\u0002\u0001)A\u0005\u0003o\tqC]5hQR\u0014vn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0011\t\u0017\u0005\r\u0003\u00011AA\u0002\u0013%\u0011QI\u0001\u000e]\u0016DH\u000fT3gi&sG-\u001a=\u0016\u0005\u0005\u001d\u0003CBA%\u0003\u001b\n\t&\u0004\u0002\u0002L)\u0011q&P\u0005\u0005\u0003\u001f\nYE\u0001\u0006WC2,Xm\u0015;bi\u0016\u0004B!!\u0001\u0002T%!\u0011QKA\u0002\u0005\u0011auN\\4\t\u0017\u0005e\u0003\u00011AA\u0002\u0013%\u00111L\u0001\u0012]\u0016DH\u000fT3gi&sG-\u001a=`I\u0015\fH\u0003BA/\u0003G\u00022aJA0\u0013\r\t\t\u0007\u000b\u0002\u0005+:LG\u000f\u0003\u0006\u0002f\u0005]\u0013\u0011!a\u0001\u0003\u000f\n1\u0001\u001f\u00132\u0011!\tI\u0007\u0001Q!\n\u0005\u001d\u0013A\u00048fqRdUM\u001a;J]\u0012,\u0007\u0010\t\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0013\ty'A\u0005mK\u001a$8\u000b^1uKV\u0011\u0011\u0011\u000f\t\b\u0003\u0013\n\u0019(!\u0015C\u0013\u0011\t)(a\u0013\u0003\u00115\u000b\u0007o\u0015;bi\u0016D1\"!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002|\u0005iA.\u001a4u'R\fG/Z0%KF$B!!\u0018\u0002~!Q\u0011QMA<\u0003\u0003\u0005\r!!\u001d\t\u0011\u0005\u0005\u0005\u0001)Q\u0005\u0003c\n!\u0002\\3giN#\u0018\r^3!\u0011-\t)\t\u0001a\u0001\u0002\u0004%I!a\u001c\u0002\u0015ILw\r\u001b;Ti\u0006$X\rC\u0006\u0002\n\u0002\u0001\r\u00111A\u0005\n\u0005-\u0015A\u0004:jO\"$8\u000b^1uK~#S-\u001d\u000b\u0005\u0003;\ni\t\u0003\u0006\u0002f\u0005\u001d\u0015\u0011!a\u0001\u0003cB\u0001\"!%\u0001A\u0003&\u0011\u0011O\u0001\fe&<\u0007\u000e^*uCR,\u0007\u0005C\u0006\u0002\u0016\u0002\u0001\r\u00111A\u0005\n\u0005\u0015\u0013a\u0004:fO&\u001cH/\u001a:fIRKW.\u001a:\t\u0017\u0005e\u0005\u00011AA\u0002\u0013%\u00111T\u0001\u0014e\u0016<\u0017n\u001d;fe\u0016$G+[7fe~#S-\u001d\u000b\u0005\u0003;\ni\n\u0003\u0006\u0002f\u0005]\u0015\u0011!a\u0001\u0003\u000fB\u0001\"!)\u0001A\u0003&\u0011qI\u0001\u0011e\u0016<\u0017n\u001d;fe\u0016$G+[7fe\u0002B1\"!*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(\u0006Y1MU8x/J\f\u0007\u000f]3s+\t\tI\u000b\u0005\u0003\u0002,\u00065V\"\u0001\u0003\n\u0007\u0005=FAA\u000bD%><xK]1qa&twmQ8mY\u0016\u001cGo\u001c:\t\u0017\u0005M\u0006\u00011AA\u0002\u0013%\u0011QW\u0001\u0010GJ{wo\u0016:baB,'o\u0018\u0013fcR!\u0011QLA\\\u0011)\t)'!-\u0002\u0002\u0003\u0007\u0011\u0011\u0016\u0005\t\u0003w\u0003\u0001\u0015)\u0003\u0002*\u0006a1MU8x/J\f\u0007\u000f]3sA!Y\u0011q\u0018\u0001A\u0002\u0003\u0007I\u0011BAa\u0003%\u0019w\u000e\u001c7fGR|'/\u0006\u0002\u0002DB!\u0011#!2\u001b\u0013\r\t9M\u0005\u0002\u0015)&lWm\u001d;b[B,GmQ8mY\u0016\u001cGo\u001c:\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011QZ\u0001\u000eG>dG.Z2u_J|F%Z9\u0015\t\u0005u\u0013q\u001a\u0005\u000b\u0003K\nI-!AA\u0002\u0005\r\u0007\u0002CAj\u0001\u0001\u0006K!a1\u0002\u0015\r|G\u000e\\3di>\u0014\b\u0005C\u0006\u0002X\u0002\u0001\r\u00111A\u0005\n\u0005e\u0017\u0001\u0004;j[\u0016\u00148+\u001a:wS\u000e,WCAAn!\u0011\ti.a8\u000e\u0003QI1!!9\u0015\u0005I\u0019\u0016.\u001c9mKRKW.\u001a:TKJ4\u0018nY3\t\u0017\u0005\u0015\b\u00011AA\u0002\u0013%\u0011q]\u0001\u0011i&lWM]*feZL7-Z0%KF$B!!\u0018\u0002j\"Q\u0011QMAr\u0003\u0003\u0005\r!a7\t\u0011\u00055\b\u0001)Q\u0005\u00037\fQ\u0002^5nKJ\u001cVM\u001d<jG\u0016\u0004\u0003bCAy\u0001\u0001\u0007\t\u0019!C\u0005\u0003g\fAB[8j]\u001a+hn\u0019;j_:,\u0012!\u000f\u0005\f\u0003o\u0004\u0001\u0019!a\u0001\n\u0013\tI0\u0001\tk_&tg)\u001e8di&|gn\u0018\u0013fcR!\u0011QLA~\u0011%\t)'!>\u0002\u0002\u0003\u0007\u0011\bC\u0004\u0002\u0000\u0002\u0001\u000b\u0015B\u001d\u0002\u001b)|\u0017N\u001c$v]\u000e$\u0018n\u001c8!\u0011\u001d\u0011\u0019\u0001\u0001C!\u0005\u000b\tAa\u001c9f]R\u0011\u0011Q\f\u0005\b\u0005\u0013\u0001A\u0011\tB\u0006\u0003=\u0001(o\\2fgN,E.Z7f]R\fD\u0003BA/\u0005\u001bA\u0001Ba\u0004\u0003\b\u0001\u0007!\u0011C\u0001\bK2,W.\u001a8u!\u0015\u0011\u0019Ba\u0007\u001b\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011\u0001D:ue\u0016\fWN]3d_J$'BA\u0003\u0017\u0013\u0011\u0011iB!\u0006\u0003\u0019M#(/Z1n%\u0016\u001cwN\u001d3\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$\u0005y\u0001O]8dKN\u001cX\t\\3nK:$(\u0007\u0006\u0003\u0002^\t\u0015\u0002\u0002\u0003B\b\u0005?\u0001\rA!\u0005\t\u000f\t%\u0002\u0001\"\u0011\u0003,\u0005\u0001rN\u001c)s_\u000e,7o]5oORKW.\u001a\u000b\u0005\u0003;\u0012i\u0003\u0003\u0005\u00030\t\u001d\u0002\u0019\u0001B\u0019\u0003\u0015!\u0018.\\3s!\u0015\t\"1\u0007\u0014-\u0013\r\u0011)D\u0005\u0002\u000e\u0013:$XM\u001d8bYRKW.\u001a:\t\u000f\te\u0002\u0001\"\u0011\u0003<\u0005YqN\\#wK:$H+[7f)\u0011\tiF!\u0010\t\u0011\t=\"q\u0007a\u0001\u0005cAqA!\u0011\u0001\t\u0003\u0012)!A\u0003dY>\u001cX\rC\u0004\u0003F\u0001!IAa\u0012\u0002+I,w-[:uKJ\u001cV.\u00197mKN$H+[7feR!\u0011Q\fB%\u0011!\u0011YEa\u0011A\u0002\t5\u0013!\u0003;j[\u0016\u001cH/Y7q!\r9#qJ\u0005\u0004\u0003+B\u0003b\u0002B*\u0001\u0011%!QK\u0001\u000ee\u0016<\u0017n\u001d;feRKW.\u001a:\u0015\t\u0005u#q\u000b\u0005\t\u0005\u0017\u0012\t\u00061\u0001\u0003N!9!1\f\u0001\u0005\n\tu\u0013!G3nSR\u0014Vm];mi\u0006sGm\u00117fC:,\u0006o\u0015;bi\u0016$BA!\u0014\u0003`!A!\u0011\rB-\u0001\u0004\u0011i%\u0001\buS6,'\u000fV5nKN$\u0018-\u001c9\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h\u0005a1\r\\3b]V\u00038\u000b^1uKR1\u0011Q\fB5\u0005WB\u0001B!\u0019\u0003d\u0001\u0007!Q\n\u0005\t\u0005[\u0012\u0019\u00071\u0001\u0003p\u0005y!/[4iiJ{wo]*peR,G\rE\u0003\u0003r\tU$)\u0004\u0002\u0003t)\u0019!*a\u0002\n\t\t]$1\u000f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003|\u0001!IA! \u0002!\u0019L'o\u001d;J]\u0012,\u0007\u0010V8LK\u0016\u0004H#B6\u0003\u0000\t\u0005\u0005\u0002\u0003B1\u0005s\u0002\rA!\u0014\t\u0011\t5$\u0011\u0010a\u0001\u0005_BqA!\"\u0001\t\u0013\u00119)A\u0011j]\u0012,\u0007p\u00144GSJ\u001cH/\u00127f[\u0016tGOT3xKJ$\u0006.\u00198US6,'\u000fF\u0003l\u0005\u0013\u0013Y\t\u0003\u0005\u0003b\t\r\u0005\u0019\u0001B'\u0011!\u0011iIa!A\u0002\t=\u0014\u0001\u00027jgRDqA!%\u0001\t\u0013\u0011\u0019*\u0001\u000bmCR,7\u000f\u001e*jO\"$(k\\<U_*{\u0017N\u001c\u000b\u0007\u0005+\u0013YJ!(\u0011\u000b\tE$q\u0013\"\n\t\te%1\u000f\u0002\t\u001fB$\u0018n\u001c8bY\"A!Q\u000eBH\u0001\u0004\u0011y\u0007\u0003\u0005\u0003 \n=\u0005\u0019\u0001B'\u0003!aWM\u001a;US6,\u0007b\u0002BI\u0001\u0011%!1\u0015\u000b\u000b\u0005+\u0013)Ka*\u0003,\n=\u0006\u0002\u0003B7\u0005C\u0003\rAa\u001c\t\u000f\t%&\u0011\u0015a\u0001W\u0006\u0019An\\<\t\u000f\t5&\u0011\u0015a\u0001W\u0006!\u0001.[4i\u0011!\u0011yJ!)A\u0002\t5\u0003b\u0002BZ\u0001\u0011%!QW\u0001\u0013O\u0016$(+[4iiJ{wo]*peR,G\r\u0006\u0003\u0003p\t]\u0006\u0002\u0003B]\u0005c\u0003\r!a\u000e\u0002#I|w\u000f^5nK\u000e{W\u000e]1sCR|'\u000fC\u0004\u0003>\u0002!IAa0\u0002!\u001d,GOT3yi2+g\r^%oI\u0016DXCAA)\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000b\f1bZ3u\u0019\u00164G\u000fV5nKR!!Q\nBd\u0011\u001d\u0011IM!1A\u0002\t\u000bq\u0001\\3giJ{w\u000fC\u0004\u0003N\u0002!IAa4\u0002\u0019\u001d,GOU5hQR$\u0016.\\3\u0015\t\t5#\u0011\u001b\u0005\b\u0005'\u0014Y\r1\u0001C\u0003!\u0011\u0018n\u001a5u%><\bb\u0002Bl\u0001\u0011%!\u0011\\\u0001\u0013G\",7m\u001b(piJ+GO]1di&|g\u000e\u0006\u0003\u0002^\tm\u0007\u0002\u0003B\b\u0005+\u0004\rA!\u0005")
public class TemporalRowtimeJoin
extends AbstractStreamOperator<CRow>
implements TwoInputStreamOperator<CRow, CRow, CRow>,
Triggerable<Object, VoidNamespace>,
Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, Row> leftState;
    private MapState<Long, Row> rightState;
    private ValueState<Long> registeredTimer;
    private CRowWrappingCollector cRowWrapper;
    private TimestampedCollector<CRow> collector;
    private SimpleTimerService timerService;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, Row> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, Row> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, Row> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, Row> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    private CRowWrappingCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    private void cRowWrapper_$eq(CRowWrappingCollector x$1) {
        this.cRowWrapper = x$1;
    }

    private TimestampedCollector<CRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<CRow> x$1) {
        this.collector = x$1;
    }

    private SimpleTimerService timerService() {
        return this.timerService;
    }

    private void timerService_$eq(SimpleTimerService x$1) {
        this.timerService = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    public void open() {
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling FlatJoinFunction: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName, this.genJoinFuncCode})));
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating FlatJoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)new Configuration());
        this.nextLeftIndex_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.NEXT_LEFT_INDEX_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.LEFT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.RIGHT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.REGISTERED_TIMER_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<CRow>)new TimestampedCollector(this.output));
        this.cRowWrapper_$eq(new CRowWrappingCollector());
        this.cRowWrapper().out_$eq((Collector<CRow>)this.collector());
        this.cRowWrapper().setChange(true);
        InternalTimerService internalTimerService = this.getInternalTimerService(this.TIMERS_STATE_NAME(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.timerService_$eq(new SimpleTimerService(internalTimerService));
    }

    public void processElement1(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        this.leftState().put((Object)this.getNextLeftIndex(), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(this.getLeftTime(((CRow)element.getValue()).row()));
    }

    public void processElement2(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        long rowTime = this.getRightTime(((CRow)element.getValue()).row());
        this.rightState().put((Object)Predef$.MODULE$.long2Long(rowTime), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(rowTime);
    }

    public void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        throw new IllegalStateException("This should never happen");
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        this.registeredTimer().clear();
        long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
        if (lastUnprocessedTime < Long.MAX_VALUE) {
            this.registerTimer(lastUnprocessedTime);
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private void registerSmallestTimer(long timestamp) {
        Long currentRegisteredTimer = (Long)this.registeredTimer().value();
        if (currentRegisteredTimer == null) {
            this.registerTimer(timestamp);
        } else if (currentRegisteredTimer != null && Predef$.MODULE$.Long2long(currentRegisteredTimer) > timestamp) {
            this.timerService().deleteEventTimeTimer(Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update((Object)Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer(timestamp);
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<Row> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry leftEntry = (Map.Entry)leftIterator.next();
            Row leftRow = (Row)leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<Row> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join((Object)leftRow, (Object)rightRow.get(), (Collector)this.cRowWrapper());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<Row> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove((Object)Predef$.MODULE$.long2Long(rightTime));
        }
    }

    private int firstIndexToKeep(long timerTimestamp, List<Row> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<Row> list) {
        ListIterator<Row> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, int low, int high, long leftTime) {
        Optional<Row> optional;
        block3: {
            Row midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<Row> rightRows = new ArrayList<Row>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(this.rightState().values()).foreach((Function1)new Serializable(this, rightRows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rightRows$1;

            public final boolean apply(Row row2) {
                return this.rightRows$1.add(row2);
            }
            {
                this.rightRows$1 = rightRows$1;
            }
        });
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = (Long)this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update((Object)Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(Row leftRow) {
        return BoxesRunTime.unboxToLong((Object)leftRow.getField(this.leftTimeAttribute));
    }

    private long getRightTime(Row rightRow) {
        return BoxesRunTime.unboxToLong((Object)rightRow.getField(this.rightTimeAttribute));
    }

    private void checkNotRetraction(StreamRecord<CRow> element) {
        if (((CRow)element.getValue()).change()) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retractions are not supported by [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TemporalRowtimeJoin.class.getSimpleName()}))).append((Object)"If this can happen it should be validated during planning!").toString());
    }

    public TemporalRowtimeJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

