/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.test.util.MiniClusterPipelineExecutorServiceLoader;

public class TestStreamEnvironment
extends StreamExecutionEnvironment {
    public TestStreamEnvironment(MiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classPaths) {
        super((PipelineExecutorServiceLoader)new MiniClusterPipelineExecutorServiceLoader(miniCluster), MiniClusterPipelineExecutorServiceLoader.createConfiguration(jarFiles, classPaths), null);
        this.setParallelism(parallelism);
    }

    public TestStreamEnvironment(MiniCluster miniCluster, int parallelism) {
        this(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism, Collection<Path> jarFiles, Collection<URL> classpaths) {
        StreamExecutionEnvironmentFactory factory = conf -> {
            TestStreamEnvironment env = new TestStreamEnvironment(miniCluster, parallelism, jarFiles, classpaths);
            env.configure((ReadableConfig)conf, env.getUserClassloader());
            return env;
        };
        TestStreamEnvironment.initializeContextEnvironment((StreamExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(MiniCluster miniCluster, int parallelism) {
        TestStreamEnvironment.setAsContext(miniCluster, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestStreamEnvironment.resetContextEnvironment();
    }
}

