/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.test.util.TestEnvironment;

public class MiniClusterWithClientResource
extends MiniClusterResource {
    private ClusterClient<?> clusterClient;
    private TestEnvironment executionEnvironment;

    public MiniClusterWithClientResource(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        super(miniClusterResourceConfiguration);
    }

    public ClusterClient<?> getClusterClient() {
        return this.clusterClient;
    }

    public TestEnvironment getTestEnvironment() {
        return this.executionEnvironment;
    }

    public void before() throws Exception {
        super.before();
        this.clusterClient = this.createMiniClusterClient();
        this.executionEnvironment = new TestEnvironment((JobExecutor)this.getMiniCluster(), this.getNumberSlots(), false);
        this.executionEnvironment.setAsContext();
        TestStreamEnvironment.setAsContext((JobExecutor)this.getMiniCluster(), this.getNumberSlots());
    }

    public void after() {
        this.log.info("Finalization triggered: Cluster shutdown is going to be initiated.");
        TestStreamEnvironment.unsetAsContext();
        TestEnvironment.unsetAsContext();
        Exception exception = null;
        if (this.clusterClient != null) {
            try {
                this.clusterClient.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        this.clusterClient = null;
        super.after();
        if (exception != null) {
            this.log.warn("Could not properly shut down the MiniClusterWithClientResource.", (Throwable)exception);
        }
    }

    private MiniClusterClient createMiniClusterClient() {
        return new MiniClusterClient((Configuration)this.getClientConfiguration(), this.getMiniCluster());
    }
}

