/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plantranslate.JobGraphGenerator;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.JobExecutor;
import org.apache.flink.util.Preconditions;

public class TestEnvironment
extends ExecutionEnvironment {
    private final JobExecutor jobExecutor;
    private final Collection<Path> jarFiles;
    private final Collection<URL> classPaths;
    private TestEnvironment lastEnv;

    public TestEnvironment(JobExecutor jobExecutor, int parallelism, boolean isObjectReuseEnabled, Collection<Path> jarFiles, Collection<URL> classPaths) {
        this.jobExecutor = (JobExecutor)Preconditions.checkNotNull((Object)jobExecutor);
        this.jarFiles = (Collection)Preconditions.checkNotNull(jarFiles);
        this.classPaths = (Collection)Preconditions.checkNotNull(classPaths);
        this.getConfiguration().set(DeploymentOptions.TARGET, (Object)"local");
        this.getConfiguration().set(DeploymentOptions.ATTACHED, (Object)true);
        this.setParallelism(parallelism);
        if (isObjectReuseEnabled) {
            this.getConfig().enableObjectReuse();
        } else {
            this.getConfig().disableObjectReuse();
        }
        this.lastEnv = null;
    }

    public TestEnvironment(JobExecutor executor, int parallelism, boolean isObjectReuseEnabled) {
        this(executor, parallelism, isObjectReuseEnabled, Collections.emptyList(), Collections.emptyList());
    }

    public JobExecutionResult getLastJobExecutionResult() {
        if (this.lastEnv == null) {
            return this.lastJobExecutionResult;
        }
        return this.lastEnv.getLastJobExecutionResult();
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        OptimizedPlan op = this.compileProgram(jobName);
        JobGraphGenerator jgg = new JobGraphGenerator();
        JobGraph jobGraph = jgg.compileJobGraph(op);
        for (Path jarFile : this.jarFiles) {
            jobGraph.addJar(jarFile);
        }
        jobGraph.setClasspaths(new ArrayList<URL>(this.classPaths));
        this.lastJobExecutionResult = this.jobExecutor.executeJobBlocking(jobGraph);
        return this.lastJobExecutionResult;
    }

    private OptimizedPlan compileProgram(String jobName) {
        Plan p = this.createProgramPlan(jobName);
        Optimizer pc = new Optimizer(new DataStatistics(), new Configuration());
        return pc.compile(p);
    }

    public void setAsContext() {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                TestEnvironment.this.lastEnv = new TestEnvironment(TestEnvironment.this.jobExecutor, TestEnvironment.this.getParallelism(), TestEnvironment.this.getConfig().isObjectReuseEnabled());
                return TestEnvironment.this.lastEnv;
            }
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(final JobExecutor jobExecutor, final int parallelism, final Collection<Path> jarFiles, final Collection<URL> classPaths) {
        ExecutionEnvironmentFactory factory = new ExecutionEnvironmentFactory(){

            public ExecutionEnvironment createExecutionEnvironment() {
                return new TestEnvironment(jobExecutor, parallelism, false, jarFiles, classPaths);
            }
        };
        TestEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    public static void setAsContext(JobExecutor jobExecutor, int parallelism) {
        TestEnvironment.setAsContext(jobExecutor, parallelism, Collections.emptyList(), Collections.emptyList());
    }

    public static void unsetAsContext() {
        TestEnvironment.resetContextEnvironment();
    }
}

