/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.Preconditions;

public class TestProcessBuilder {
    private final String javaCommand = (String)Preconditions.checkNotNull((Object)CommonTestUtils.getJavaCommandPath());
    private final ArrayList<String> jvmArgs = new ArrayList();
    private final ArrayList<String> mainClassArgs = new ArrayList();
    private final String mainClass;
    private MemorySize jvmMemory = MemorySize.parse((String)"80mb");

    public TestProcessBuilder(String mainClass) throws IOException {
        File tempLogFile = File.createTempFile(this.getClass().getSimpleName() + "-", "-log4j.properties");
        tempLogFile.deleteOnExit();
        CommonTestUtils.printLog4jDebugConfig((File)tempLogFile);
        this.jvmArgs.add("-Dlog.level=DEBUG");
        this.jvmArgs.add("-Dlog4j.configurationFile=file:" + tempLogFile.getAbsolutePath());
        this.jvmArgs.add("-classpath");
        this.jvmArgs.add(CommonTestUtils.getCurrentClasspath());
        this.mainClass = mainClass;
    }

    public TestProcess start() throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.javaCommand);
        commands.add(String.format("-Xms%dm", this.jvmMemory.getMebiBytes()));
        commands.add(String.format("-Xmx%dm", this.jvmMemory.getMebiBytes()));
        commands.addAll(this.jvmArgs);
        commands.add(this.mainClass);
        commands.addAll(this.mainClassArgs);
        StringWriter processOutput = new StringWriter();
        StringWriter errorOutput = new StringWriter();
        Process process = new ProcessBuilder(commands).start();
        new CommonTestUtils.PipeForwarder(process.getInputStream(), processOutput);
        new CommonTestUtils.PipeForwarder(process.getErrorStream(), errorOutput);
        return new TestProcess(process, processOutput, errorOutput);
    }

    public TestProcessBuilder setJvmMemory(MemorySize jvmMemory) {
        this.jvmMemory = jvmMemory;
        return this;
    }

    public TestProcessBuilder addJvmArg(String arg) {
        this.jvmArgs.add(arg);
        return this;
    }

    public TestProcessBuilder addMainClassArg(String arg) {
        this.mainClassArgs.add(arg);
        return this;
    }

    public TestProcessBuilder addConfigAsMainClassArgs(Configuration config) {
        for (Map.Entry keyValue : config.toMap().entrySet()) {
            this.addMainClassArg("--" + (String)keyValue.getKey());
            this.addMainClassArg((String)keyValue.getValue());
        }
        return this;
    }

    public static class TestProcess {
        private final Process process;
        private final StringWriter processOutput;
        private final StringWriter errorOutput;

        public TestProcess(Process process, StringWriter processOutput, StringWriter errorOutput) {
            this.process = process;
            this.processOutput = processOutput;
            this.errorOutput = errorOutput;
        }

        public Process getProcess() {
            return this.process;
        }

        public StringWriter getProcessOutput() {
            return this.processOutput;
        }

        public StringWriter getErrorOutput() {
            return this.errorOutput;
        }

        public void destroy() {
            this.process.destroy();
        }
    }
}

