/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http;

import org.apache.flink.shaded.testutils.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.compression.JdkZlibEncoder;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.compression.ZlibWrapper;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.embedder.EncoderEmbedder;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.HttpContentEncoder;
import org.apache.flink.shaded.testutils.org.jboss.netty.handler.codec.http.HttpMessage;
import org.apache.flink.shaded.testutils.org.jboss.netty.logging.InternalLogger;
import org.apache.flink.shaded.testutils.org.jboss.netty.logging.InternalLoggerFactory;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.internal.DetectionUtil;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.internal.StringUtil;
import org.apache.flink.shaded.testutils.org.jboss.netty.util.internal.SystemPropertyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpContentCompressor
extends HttpContentEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpContentCompressor.class);
    private static final int DEFAULT_JDK_WINDOW_SIZE = 15;
    private static final int DEFAULT_JDK_MEM_LEVEL = 8;
    private static final boolean noJdkZlibEncoder = SystemPropertyUtil.getBoolean("io.netty.noJdkZlibEncoder", false);
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;

    public HttpContentCompressor() {
        this(6);
    }

    public HttpContentCompressor(int compressionLevel) {
        this(compressionLevel, 15, 8);
    }

    public HttpContentCompressor(int compressionLevel, int windowBits, int memLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        if (windowBits < 9 || windowBits > 15) {
            throw new IllegalArgumentException("windowBits: " + windowBits + " (expected: 9-15)");
        }
        if (memLevel < 1 || memLevel > 9) {
            throw new IllegalArgumentException("memLevel: " + memLevel + " (expected: 1-9)");
        }
        this.compressionLevel = compressionLevel;
        this.windowBits = windowBits;
        this.memLevel = memLevel;
    }

    @Override
    protected EncoderEmbedder<ChannelBuffer> newContentEncoder(HttpMessage msg, String acceptEncoding) throws Exception {
        String contentEncoding = msg.headers().get("Content-Encoding");
        if (contentEncoding != null && !"identity".equalsIgnoreCase(contentEncoding)) {
            return null;
        }
        ZlibWrapper wrapper = HttpContentCompressor.determineWrapper(acceptEncoding);
        if (wrapper == null) {
            return null;
        }
        if (DetectionUtil.javaVersion() < 7 || noJdkZlibEncoder || this.windowBits != 15 || this.memLevel != 8) {
            return new EncoderEmbedder<ChannelBuffer>(new ZlibEncoder(wrapper, this.compressionLevel, this.windowBits, this.memLevel));
        }
        return new EncoderEmbedder<ChannelBuffer>(new JdkZlibEncoder(wrapper, this.compressionLevel));
    }

    @Override
    protected String getTargetContentEncoding(String acceptEncoding) throws Exception {
        ZlibWrapper wrapper = HttpContentCompressor.determineWrapper(acceptEncoding);
        if (wrapper == null) {
            return null;
        }
        switch (wrapper) {
            case GZIP: {
                return "gzip";
            }
            case ZLIB: {
                return "deflate";
            }
        }
        throw new Error();
    }

    private static ZlibWrapper determineWrapper(String acceptEncoding) {
        float starQ = -1.0f;
        float gzipQ = -1.0f;
        float deflateQ = -1.0f;
        for (String encoding : StringUtil.split(acceptEncoding, ',')) {
            float q = 1.0f;
            int equalsPos = encoding.indexOf(61);
            if (equalsPos != -1) {
                try {
                    q = Float.valueOf(encoding.substring(equalsPos + 1)).floatValue();
                }
                catch (NumberFormatException e) {
                    q = 0.0f;
                }
            }
            if (encoding.indexOf(42) >= 0) {
                starQ = q;
                continue;
            }
            if (encoding.contains("gzip") && q > gzipQ) {
                gzipQ = q;
                continue;
            }
            if (!encoding.contains("deflate") || !(q > deflateQ)) continue;
            deflateQ = q;
        }
        if (gzipQ > 0.0f || deflateQ > 0.0f) {
            if (gzipQ >= deflateQ) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (starQ > 0.0f) {
            if (gzipQ == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (deflateQ == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noJdkZlibEncoder: " + noJdkZlibEncoder);
        }
    }
}

