/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.test.util;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.util.MiniClusterWithClientResource;
import org.apache.flink.test.util.TestBaseUtils;
import org.apache.flink.util.FileUtils;
import org.junit.After;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestBase
extends TestBaseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTestBase.class);
    private static final int DEFAULT_PARALLELISM = 4;
    @ClassRule
    public static MiniClusterWithClientResource miniClusterResource = new MiniClusterWithClientResource(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(4).build());
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @After
    public final void cleanupRunningJobs() throws Exception {
        if (!miniClusterResource.getMiniCluster().isRunning()) {
            LOG.warn("Mini cluster is not running after the test!");
            return;
        }
        for (JobStatusMessage path : (Collection)miniClusterResource.getClusterClient().listJobs().get()) {
            if (path.getJobState().isTerminalState()) continue;
            try {
                miniClusterResource.getClusterClient().cancel(path.getJobId()).get();
            }
            catch (Exception exception) {}
        }
    }

    public String getTempDirPath(String dirName) throws IOException {
        File f = this.createAndRegisterTempFile(dirName);
        return f.toURI().toString();
    }

    public String getTempFilePath(String fileName) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        return f.toURI().toString();
    }

    public String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileUtils.writeFileUtf8((File)f, (String)contents);
        return f.toURI().toString();
    }

    public File createAndRegisterTempFile(String fileName) throws IOException {
        return new File(TEMPORARY_FOLDER.newFolder(), fileName);
    }
}

