/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.ResourceInformationReflector;
import org.apache.hadoop.yarn.api.records.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkerSpecContainerResourceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerSpecContainerResourceAdapter.class);
    private final Configuration flinkConfig;
    private final int minMemMB;
    private final int maxMemMB;
    private final int unitMemMB;
    private final int minVcore;
    private final int maxVcore;
    private final int unitVcore;
    private final Map<String, Long> externalResourceConfigs;
    private final Map<WorkerResourceSpec, InternalContainerResource> workerSpecToContainerResource;
    private final Map<InternalContainerResource, Set<WorkerResourceSpec>> containerResourceToWorkerSpecs;
    private final Map<Integer, Set<InternalContainerResource>> containerMemoryToContainerResource;

    WorkerSpecContainerResourceAdapter(Configuration flinkConfig, int minMemMB, int minVcore, int maxMemMB, int maxVcore, int unitMemMB, int unitVcore, Map<String, Long> externalResourceConfigs) {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
        this.minMemMB = minMemMB;
        this.minVcore = minVcore;
        this.maxMemMB = maxMemMB;
        this.maxVcore = maxVcore;
        this.unitMemMB = unitMemMB;
        this.unitVcore = unitVcore;
        this.externalResourceConfigs = (Map)Preconditions.checkNotNull(externalResourceConfigs);
        this.workerSpecToContainerResource = new HashMap<WorkerResourceSpec, InternalContainerResource>();
        this.containerResourceToWorkerSpecs = new HashMap<InternalContainerResource, Set<WorkerResourceSpec>>();
        this.containerMemoryToContainerResource = new HashMap<Integer, Set<InternalContainerResource>>();
    }

    Optional<Resource> tryComputeContainerResource(WorkerResourceSpec workerResourceSpec) {
        InternalContainerResource internalContainerResource = this.workerSpecToContainerResource.computeIfAbsent((WorkerResourceSpec)Preconditions.checkNotNull((Object)workerResourceSpec), this::createAndMapContainerResource);
        if (internalContainerResource != null) {
            return Optional.of(internalContainerResource.toResource());
        }
        return Optional.empty();
    }

    Set<WorkerResourceSpec> getWorkerSpecs(Resource containerResource, MatchingStrategy matchingStrategy) {
        InternalContainerResource internalContainerResource = new InternalContainerResource(containerResource);
        return this.getEquivalentInternalContainerResource(internalContainerResource, matchingStrategy).stream().flatMap(resource -> this.containerResourceToWorkerSpecs.getOrDefault(resource, Collections.emptySet()).stream()).collect(Collectors.toSet());
    }

    Set<Resource> getEquivalentContainerResource(Resource containerResource, MatchingStrategy matchingStrategy) {
        InternalContainerResource internalContainerResource = new InternalContainerResource(containerResource);
        return this.getEquivalentInternalContainerResource(internalContainerResource, matchingStrategy).stream().map(rec$ -> ((InternalContainerResource)rec$).toResource()).collect(Collectors.toSet());
    }

    private Set<InternalContainerResource> getEquivalentInternalContainerResource(InternalContainerResource internalContainerResource, MatchingStrategy matchingStrategy) {
        Set<InternalContainerResource> equivalentInternalContainerResources;
        switch (matchingStrategy) {
            case MATCH_VCORE: {
                equivalentInternalContainerResources = Collections.singleton(internalContainerResource);
                break;
            }
            default: {
                equivalentInternalContainerResources = this.containerMemoryToContainerResource.getOrDefault(internalContainerResource.memory, Collections.emptySet());
            }
        }
        return equivalentInternalContainerResources;
    }

    @Nullable
    private InternalContainerResource createAndMapContainerResource(WorkerResourceSpec workerResourceSpec) {
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromWorkerResourceSpec((Configuration)this.flinkConfig, (WorkerResourceSpec)workerResourceSpec);
        InternalContainerResource internalContainerResource = new InternalContainerResource(this.normalize(taskExecutorProcessSpec.getTotalProcessMemorySize().getMebiBytes(), this.minMemMB, this.unitMemMB), this.normalize(taskExecutorProcessSpec.getCpuCores().getValue().intValue(), this.minVcore, this.unitVcore), this.externalResourceConfigs);
        if (this.resourceWithinMaxAllocation(internalContainerResource)) {
            this.containerResourceToWorkerSpecs.computeIfAbsent(internalContainerResource, ignored -> new HashSet()).add(workerResourceSpec);
            this.containerMemoryToContainerResource.computeIfAbsent(internalContainerResource.memory, ignored -> new HashSet()).add(internalContainerResource);
            return internalContainerResource;
        }
        LOG.warn("Requested container resource {} exceeds yarn max allocation {}. Will not allocate resource.", (Object)internalContainerResource, (Object)new InternalContainerResource(this.maxMemMB, this.maxVcore, Collections.emptyMap()));
        return null;
    }

    private int normalize(int value, int minValue, int unitValue) {
        int rValue = Math.max(value, minValue);
        return Math.max(MathUtils.divideRoundUp((int)rValue, (int)unitValue), 1) * unitValue;
    }

    private boolean resourceWithinMaxAllocation(InternalContainerResource resource) {
        return resource.memory <= this.maxMemMB && resource.vcores <= this.maxVcore;
    }

    private static void trySetExternalResources(Map<String, Long> externalResources, Resource resource) {
        for (Map.Entry<String, Long> externalResource : externalResources.entrySet()) {
            ResourceInformationReflector.INSTANCE.setResourceInformation(resource, externalResource.getKey(), externalResource.getValue());
        }
    }

    @VisibleForTesting
    static final class InternalContainerResource {
        private final int memory;
        private final int vcores;
        private final Map<String, Long> externalResources;

        @VisibleForTesting
        InternalContainerResource(int memory, int vcores, Map<String, Long> externalResources) {
            this.memory = memory;
            this.vcores = vcores;
            this.externalResources = externalResources.entrySet().stream().filter(entry -> !((Long)entry.getValue()).equals(0L)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private InternalContainerResource(Resource resource) {
            this(((Resource)Preconditions.checkNotNull((Object)resource)).getMemory(), ((Resource)Preconditions.checkNotNull((Object)resource)).getVirtualCores(), ResourceInformationReflector.INSTANCE.getExternalResources(resource));
        }

        private Resource toResource() {
            Resource resource = Resource.newInstance((int)this.memory, (int)this.vcores);
            WorkerSpecContainerResourceAdapter.trySetExternalResources(this.externalResources, resource);
            return resource;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InternalContainerResource) {
                InternalContainerResource other = (InternalContainerResource)obj;
                return this.memory == other.memory && this.vcores == other.vcores && this.externalResources.equals(other.externalResources);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = Integer.hashCode(this.memory);
            result = 31 * result + Integer.hashCode(this.vcores);
            result = 31 * result + this.externalResources.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<memory:").append(this.memory).append(", vCores:").append(this.vcores);
            TreeSet<String> externalResourceNames = new TreeSet<String>(this.externalResources.keySet());
            for (String externalResourceName : externalResourceNames) {
                sb.append(", ").append(externalResourceName).append(": ").append(this.externalResources.get(externalResourceName));
            }
            sb.append(">");
            return sb.toString();
        }
    }

    static enum MatchingStrategy {
        MATCH_VCORE,
        IGNORE_VCORE;

    }
}

