/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.Utils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;

class YarnLocalResourceDescriptor {
    private static final String STRING_FORMAT = "YarnLocalResourceDescriptor{key=%s, path=%s, size=%d, modificationTime=%d, visibility=%s}";
    private static final Pattern LOCAL_RESOURCE_DESC_FORMAT = Pattern.compile("YarnLocalResourceDescriptor\\{key=(\\S+), path=(\\S+), size=([\\d]+), modificationTime=([\\d]+), visibility=(\\S+)}");
    private final String resourceKey;
    private final Path path;
    private final long size;
    private final long modificationTime;
    private final LocalResourceVisibility visibility;

    YarnLocalResourceDescriptor(String resourceKey, Path path, long resourceSize, long modificationTime, LocalResourceVisibility visibility) {
        this.resourceKey = (String)Preconditions.checkNotNull((Object)resourceKey);
        this.path = (Path)Preconditions.checkNotNull((Object)path);
        this.size = resourceSize;
        this.modificationTime = modificationTime;
        this.visibility = (LocalResourceVisibility)Preconditions.checkNotNull((Object)visibility);
    }

    boolean alreadyRegisteredAsLocalResource() {
        return this.visibility.equals((Object)LocalResourceVisibility.PUBLIC);
    }

    String getResourceKey() {
        return this.resourceKey;
    }

    Path getPath() {
        return this.path;
    }

    long getSize() {
        return this.size;
    }

    long getModificationTime() {
        return this.modificationTime;
    }

    LocalResourceVisibility getVisibility() {
        return this.visibility;
    }

    static YarnLocalResourceDescriptor fromString(String desc) throws Exception {
        Matcher m = LOCAL_RESOURCE_DESC_FORMAT.matcher(desc);
        boolean mat = m.find();
        if (mat) {
            return new YarnLocalResourceDescriptor(m.group(1), new Path(m.group(2)), Long.parseLong(m.group(3)), Long.parseLong(m.group(4)), LocalResourceVisibility.valueOf((String)m.group(5)));
        }
        throw new FlinkException("Error to parse YarnLocalResourceDescriptor from " + desc);
    }

    static YarnLocalResourceDescriptor fromFileStatus(String key, FileStatus fileStatus, LocalResourceVisibility visibility) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)fileStatus);
        Preconditions.checkNotNull((Object)visibility);
        return new YarnLocalResourceDescriptor(key, fileStatus.getPath(), fileStatus.getLen(), fileStatus.getModificationTime(), visibility);
    }

    public String toString() {
        return String.format(STRING_FORMAT, this.resourceKey, this.path.toString(), this.size, this.modificationTime, this.visibility);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.resourceKey);
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.modificationTime);
        result = 31 * result + Objects.hashCode(this.visibility.toString());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == YarnLocalResourceDescriptor.class) {
            YarnLocalResourceDescriptor that = (YarnLocalResourceDescriptor)obj;
            return Objects.equals(this.resourceKey, that.resourceKey) && Objects.equals(this.path, that.path) && Objects.equals(this.size, that.size) && Objects.equals(this.modificationTime, that.modificationTime) && Objects.equals(this.visibility, that.visibility);
        }
        return false;
    }

    public LocalResource toLocalResource() {
        return Utils.registerLocalResource(this.path, this.size, this.modificationTime, this.visibility);
    }
}

