/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnTaskExecutorRunner {
    protected static final Logger LOG = LoggerFactory.getLogger(YarnTaskExecutorRunner.class);
    private static final Map<String, String> ENV = System.getenv();
    private static final int INIT_ERROR_EXIT_CODE = 31;

    public static void main(String[] args) {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"YARN TaskExecutor runner", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        YarnTaskExecutorRunner.runTaskManagerSecurely(args);
    }

    private static void runTaskManagerSecurely(String[] args) {
        Configuration configuration = null;
        String containerId = null;
        try {
            LOG.debug("All environment variables: {}", ENV);
            String currDir = ENV.get(ApplicationConstants.Environment.PWD.key());
            LOG.info("Current working Directory: {}", (Object)currDir);
            configuration = TaskManagerRunner.loadConfiguration((String[])args);
            YarnTaskExecutorRunner.setupAndModifyConfiguration(configuration, currDir, ENV);
            containerId = ENV.get("_FLINK_CONTAINER_ID");
            Preconditions.checkArgument((containerId != null ? 1 : 0) != 0, (String)"ContainerId variable %s not set", (Object[])new Object[]{"_FLINK_CONTAINER_ID"});
        }
        catch (Throwable t) {
            LOG.error("YARN TaskManager initialization failed.", t);
            System.exit(31);
        }
        TaskManagerRunner.runTaskManagerProcessSecurely((Configuration)((Configuration)Preconditions.checkNotNull(configuration)), (ResourceID)new ResourceID((String)Preconditions.checkNotNull(containerId)));
    }

    @VisibleForTesting
    static void setupAndModifyConfiguration(Configuration configuration, String currDir, Map<String, String> variables) throws Exception {
        String localDirs = variables.get(ApplicationConstants.Environment.LOCAL_DIRS.key());
        LOG.info("Current working/local Directory: {}", (Object)localDirs);
        BootstrapTools.updateTmpDirectoriesInConfiguration((Configuration)configuration, (String)localDirs);
        YarnTaskExecutorRunner.setupConfigurationFromVariables(configuration, currDir, variables);
    }

    private static void setupConfigurationFromVariables(Configuration configuration, String currDir, Map<String, String> variables) throws IOException {
        String taskExecutorHostname;
        String yarnClientUsername = variables.get("HADOOP_USER_NAME");
        String localKeytabPath = variables.get("_LOCAL_KEYTAB_PATH");
        LOG.info("TM: local keytab path obtained {}", (Object)localKeytabPath);
        String keytabPrincipal = variables.get("_KEYTAB_PRINCIPAL");
        LOG.info("TM: keytab principal obtained {}", (Object)keytabPrincipal);
        configuration.setBoolean(AkkaOptions.JVM_EXIT_ON_FATAL_ERROR, true);
        String keytabPath = Utils.resolveKeytabPath(currDir, localKeytabPath);
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.info("YARN daemon is running as: {} Yarn client user obtainer: {}", (Object)currentUser.getShortUserName(), (Object)yarnClientUsername);
        if (keytabPath != null && keytabPrincipal != null) {
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keytabPath);
            configuration.setString(SecurityOptions.KERBEROS_LOGIN_PRINCIPAL, keytabPrincipal);
        }
        if ((taskExecutorHostname = variables.get("_FLINK_NODE_ID")) != null) {
            configuration.setString(TaskManagerOptions.HOST, taskExecutorHostname);
        }
    }
}

