/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import org.apache.hadoop.hdfs.util.XMLUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestXMLUtils {
    private static void testRoundTripImpl(String str, String expectedMangled, boolean encodeEntityRefs) {
        String mangled = XMLUtils.mangleXmlString((String)str, (boolean)encodeEntityRefs);
        Assert.assertEquals((Object)expectedMangled, (Object)mangled);
        String unmangled = XMLUtils.unmangleXmlString((String)mangled, (boolean)encodeEntityRefs);
        Assert.assertEquals((Object)str, (Object)unmangled);
    }

    private static void testRoundTrip(String str, String expectedMangled) {
        TestXMLUtils.testRoundTripImpl(str, expectedMangled, false);
    }

    private static void testRoundTripWithEntityRefs(String str, String expectedMangled) {
        TestXMLUtils.testRoundTripImpl(str, expectedMangled, true);
    }

    @Test
    public void testMangleEmptyString() throws Exception {
        TestXMLUtils.testRoundTrip("", "");
    }

    @Test
    public void testMangleVanillaString() throws Exception {
        TestXMLUtils.testRoundTrip("abcdef", "abcdef");
    }

    @Test
    public void testMangleStringWithBackSlash() throws Exception {
        TestXMLUtils.testRoundTrip("a\\bcdef", "a\\005c;bcdef");
        TestXMLUtils.testRoundTrip("\\\\", "\\005c;\\005c;");
    }

    @Test
    public void testMangleStringWithForbiddenCodePoint() throws Exception {
        TestXMLUtils.testRoundTrip("a\u0001bcdef", "a\\0001;bcdef");
        TestXMLUtils.testRoundTrip("a\u0002\ud800bcdef", "a\\0002;\\d800;bcdef");
    }

    @Test
    public void testInvalidSequence() throws Exception {
        try {
            XMLUtils.unmangleXmlString((String)"\\000g;foo", (boolean)false);
            Assert.fail((String)"expected an unmangling error");
        }
        catch (XMLUtils.UnmanglingError e) {
            // empty catch block
        }
        try {
            XMLUtils.unmangleXmlString((String)"\\0", (boolean)false);
            Assert.fail((String)"expected an unmangling error");
        }
        catch (XMLUtils.UnmanglingError unmanglingError) {
            // empty catch block
        }
    }

    @Test
    public void testAddEntityRefs() throws Exception {
        TestXMLUtils.testRoundTripWithEntityRefs("The Itchy & Scratchy Show", "The Itchy &amp; Scratchy Show");
        TestXMLUtils.testRoundTripWithEntityRefs("\"He said '1 < 2, but 2 > 1'\"", "&quot;He said &apos;1 &lt; 2, but 2 &gt; 1&apos;&quot;");
        TestXMLUtils.testRoundTripWithEntityRefs("\u0001 < \u0002", "\\0001; &lt; \\0002;");
    }
}

