/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.LinkedList;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.IterativePlanner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocatorGreedy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocatorLowCostAligned;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageEarliestStartByDemand;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageEarliestStartByJobArrival;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.TryManyReservationAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedPlannerWithGreedy
implements ReservationAgent {
    private static final int DEFAULT_SMOOTHNESS_FACTOR = 10;
    private static final Logger LOG = LoggerFactory.getLogger(AlignedPlannerWithGreedy.class);
    private final ReservationAgent planner;

    public AlignedPlannerWithGreedy() {
        this(10);
    }

    public AlignedPlannerWithGreedy(int smoothnessFactor) {
        LinkedList<ReservationAgent> listAlg = new LinkedList<ReservationAgent>();
        IterativePlanner algAligned = new IterativePlanner(new StageEarliestStartByDemand(), new StageAllocatorLowCostAligned(smoothnessFactor), false);
        listAlg.add(algAligned);
        IterativePlanner algGreedy = new IterativePlanner(new StageEarliestStartByJobArrival(), new StageAllocatorGreedy(), false);
        listAlg.add(algGreedy);
        this.planner = new TryManyReservationAgents(listAlg);
    }

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("placing the following ReservationRequest: " + contract);
        try {
            boolean res = this.planner.createReservation(reservationId, user, plan, contract);
            if (res) {
                LOG.info("OUTCOME: SUCCESS, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            } else {
                LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            }
            return res;
        }
        catch (PlanningException e) {
            LOG.info("OUTCOME: FAILURE, Reservation ID: " + reservationId.toString() + ", Contract: " + contract.toString());
            throw e;
        }
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        LOG.info("updating the following ReservationRequest: " + contract);
        return this.planner.updateReservation(reservationId, user, plan, contract);
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        LOG.info("removing the following ReservationId: " + reservationId);
        return this.planner.deleteReservation(reservationId, user, plan);
    }
}

