/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.StageAllocator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class StageAllocatorGreedy
implements StageAllocator {
    @Override
    public Map<ReservationInterval, Resource> computeStageAllocation(Plan plan, Map<Long, Resource> planLoads, RLESparseResourceAllocation planModifications, ReservationRequest rr, long stageEarliestStart, long stageDeadline, String user, ReservationId oldId) throws PlanningException {
        long step;
        Resource totalCapacity = plan.getTotalCapacity();
        HashMap<ReservationInterval, Resource> allocationRequests = new HashMap<ReservationInterval, Resource>();
        Resource gang = Resources.multiply((Resource)rr.getCapability(), (double)rr.getConcurrency());
        long dur = rr.getDuration();
        if (dur % (step = plan.getStep()) != 0L) {
            dur += step - dur % step;
        }
        int gangsToPlace = rr.getNumContainers() / rr.getConcurrency();
        int maxGang = 0;
        RLESparseResourceAllocation netAvailable = plan.getAvailableResourceOverTime(user, oldId, stageEarliestStart, stageDeadline);
        netAvailable = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), netAvailable, planModifications, RLESparseResourceAllocation.RLEOperator.subtract, stageEarliestStart, stageDeadline);
        while (gangsToPlace > 0 && stageDeadline - dur >= stageEarliestStart) {
            maxGang = gangsToPlace;
            long minPoint = stageDeadline;
            int curMaxGang = maxGang;
            for (long t = stageDeadline - plan.getStep(); t >= stageDeadline - dur && maxGang > 0; t -= plan.getStep()) {
                Resource netAvailableRes = netAvailable.getCapacityAtTime(t);
                curMaxGang = (int)Math.floor(Resources.divide((ResourceCalculator)plan.getResourceCalculator(), (Resource)totalCapacity, (Resource)netAvailableRes, (Resource)gang));
                if ((curMaxGang = Math.min(gangsToPlace, curMaxGang)) > maxGang) continue;
                maxGang = curMaxGang;
                minPoint = t;
            }
            if (maxGang > 0) {
                gangsToPlace -= maxGang;
                ReservationInterval reservationInt = new ReservationInterval(stageDeadline - dur, stageDeadline);
                Resource reservationRes = Resources.multiply((Resource)rr.getCapability(), (double)(rr.getConcurrency() * maxGang));
                planModifications.addInterval(reservationInt, reservationRes);
                allocationRequests.put(reservationInt, reservationRes);
            }
            stageDeadline = minPoint;
        }
        if (gangsToPlace == 0) {
            return allocationRequests;
        }
        for (Map.Entry tempAllocation : allocationRequests.entrySet()) {
            planModifications.removeInterval((ReservationInterval)tempAllocation.getKey(), (Resource)tempAllocation.getValue());
        }
        return null;
    }
}

