/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation.planning;

import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;

public class TryManyReservationAgents
implements ReservationAgent {
    private final List<ReservationAgent> algs;

    public TryManyReservationAgents(List<ReservationAgent> algs) {
        this.algs = new LinkedList<ReservationAgent>(algs);
    }

    @Override
    public boolean createReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        PlanningException planningException = null;
        for (ReservationAgent alg : this.algs) {
            try {
                if (!alg.createReservation(reservationId, user, plan, contract)) continue;
                return true;
            }
            catch (PlanningException e) {
                planningException = e;
            }
        }
        if (planningException != null) {
            throw planningException;
        }
        return false;
    }

    @Override
    public boolean updateReservation(ReservationId reservationId, String user, Plan plan, ReservationDefinition contract) throws PlanningException {
        PlanningException planningException = null;
        for (ReservationAgent alg : this.algs) {
            try {
                if (!alg.updateReservation(reservationId, user, plan, contract)) continue;
                return true;
            }
            catch (PlanningException e) {
                planningException = e;
            }
        }
        if (planningException != null) {
            throw planningException;
        }
        return false;
    }

    @Override
    public boolean deleteReservation(ReservationId reservationId, String user, Plan plan) throws PlanningException {
        return plan.deleteReservation(reservationId);
    }
}

