/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoOrderingPolicyForPendingApps;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private float absoluteUsedCapacity = 0.0f;
    private int userLimit;
    private float userLimitFactor;
    protected int maxApplications;
    protected int maxApplicationsPerUser;
    private float maxAMResourcePerQueuePercent;
    private volatile int nodeLocalityDelay;
    private volatile boolean rackLocalityFullReset;
    Map<ApplicationAttemptId, FiCaSchedulerApp> applicationAttemptMap = new HashMap<ApplicationAttemptId, FiCaSchedulerApp>();
    private Priority defaultAppPriorityPerQueue;
    private OrderingPolicy<FiCaSchedulerApp> pendingOrderingPolicy = null;
    private volatile float minimumAllocationFactor;
    private Map<String, User> users = new HashMap<String, User>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    private final ActiveUsersManager activeUsersManager;
    private Resource lastClusterResource = Resources.none();
    private final QueueResourceLimitsInfo queueResourceLimitsInfo = new QueueResourceLimitsInfo();
    private volatile ResourceLimits cachedResourceLimitsForHeadroom = null;
    private OrderingPolicy<FiCaSchedulerApp> orderingPolicy = null;
    private float totalUserConsumedRatio = 0.0f;
    private UsageRatios qUsageRatios;
    private Map<String, TreeSet<RMContainer>> ignorePartitionExclusivityRMContainers = new HashMap<String, TreeSet<RMContainer>>();

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.activeUsersManager = new ActiveUsersManager(this.metrics);
        this.pendingOrderingPolicy = new FifoOrderingPolicyForPendingApps<FiCaSchedulerApp>();
        this.qUsageRatios = new UsageRatios();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        this.setupQueueConfigs(cs.getClusterResource());
    }

    @Override
    protected synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        super.setupQueueConfigs(clusterResource);
        this.lastClusterResource = clusterResource;
        this.cachedResourceLimitsForHeadroom = new ResourceLimits(clusterResource);
        this.setQueueResourceLimitsInfo(clusterResource);
        CapacitySchedulerConfiguration conf = this.csContext.getConfiguration();
        this.setOrderingPolicy(conf.getOrderingPolicy(this.getQueuePath()));
        this.userLimit = conf.getUserLimit(this.getQueuePath());
        this.userLimitFactor = conf.getUserLimitFactor(this.getQueuePath());
        this.maxApplications = conf.getMaximumApplicationsPerQueue(this.getQueuePath());
        if (this.maxApplications < 0) {
            int maxSystemApps = conf.getMaximumSystemApplications();
            this.maxApplications = (int)((float)maxSystemApps * this.queueCapacities.getAbsoluteCapacity());
        }
        this.maxApplicationsPerUser = Math.min(this.maxApplications, (int)((float)this.maxApplications * ((float)this.userLimit / 100.0f) * this.userLimitFactor));
        this.maxAMResourcePerQueuePercent = conf.getMaximumApplicationMasterResourcePerQueuePercent(this.getQueuePath());
        if (!SchedulerUtils.checkQueueLabelExpression(this.accessibleLabels, this.defaultLabelExpression, null)) {
            throw new IOException("Invalid default label expression of  queue=" + this.getQueueName() + " doesn't have permission to access all labels " + "in default label expression. labelExpression of resource request=" + (this.defaultLabelExpression == null ? "" : this.defaultLabelExpression) + ". Queue labels=" + (this.getAccessibleNodeLabels() == null ? "" : StringUtils.join(this.getAccessibleNodeLabels().iterator(), (char)',')));
        }
        this.nodeLocalityDelay = conf.getNodeLocalityDelay();
        this.rackLocalityFullReset = conf.getRackLocalityFullReset();
        this.minimumAllocationFactor = Resources.ratio((ResourceCalculator)this.resourceCalculator, (Resource)Resources.subtract((Resource)this.maximumAllocation, (Resource)this.minimumAllocation), (Resource)this.maximumAllocation);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry e : this.acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + ((AccessControlList)e.getValue()).getAclString());
        }
        StringBuilder labelStrBuilder = new StringBuilder();
        if (this.accessibleLabels != null) {
            for (String s : this.accessibleLabels) {
                labelStrBuilder.append(s);
                labelStrBuilder.append(",");
            }
        }
        this.defaultAppPriorityPerQueue = Priority.newInstance((int)conf.getDefaultApplicationPriorityConfPerQueue(this.getQueuePath()));
        LOG.info((Object)("Initializing " + this.queueName + "\n" + "capacity = " + this.queueCapacities.getCapacity() + " [= (float) configuredCapacity / 100 ]" + "\n" + "asboluteCapacity = " + this.queueCapacities.getAbsoluteCapacity() + " [= parentAbsoluteCapacity * capacity ]" + "\n" + "maxCapacity = " + this.queueCapacities.getMaximumCapacity() + " [= configuredMaxCapacity ]" + "\n" + "absoluteMaxCapacity = " + this.queueCapacities.getAbsoluteMaximumCapacity() + " [= 1.0 maximumCapacity undefined, " + "(parentAbsoluteMaxCapacity * maximumCapacity) / 100 otherwise ]" + "\n" + "userLimit = " + this.userLimit + " [= configuredUserLimit ]" + "\n" + "userLimitFactor = " + this.userLimitFactor + " [= configuredUserLimitFactor ]" + "\n" + "maxApplications = " + this.maxApplications + " [= configuredMaximumSystemApplicationsPerQueue or" + " (int)(configuredMaximumSystemApplications * absoluteCapacity)]" + "\n" + "maxApplicationsPerUser = " + this.maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * " + "userLimitFactor) ]" + "\n" + "usedCapacity = " + this.queueCapacities.getUsedCapacity() + " [= usedResourcesMemory / " + "(clusterResourceMemory * absoluteCapacity)]" + "\n" + "absoluteUsedCapacity = " + this.absoluteUsedCapacity + " [= usedResourcesMemory / clusterResourceMemory]" + "\n" + "maxAMResourcePerQueuePercent = " + this.maxAMResourcePerQueuePercent + " [= configuredMaximumAMResourcePercent ]" + "\n" + "minimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / " + "maximumAllocationMemory ]" + "\n" + "maximumAllocation = " + this.maximumAllocation + " [= configuredMaxAllocation ]" + "\n" + "numContainers = " + this.numContainers + " [= currentNumContainers ]" + "\n" + "state = " + this.state + " [= configuredState ]" + "\n" + "acls = " + aclsString + " [= configuredAcls ]" + "\n" + "nodeLocalityDelay = " + this.nodeLocalityDelay + "\n" + "labels=" + labelStrBuilder.toString() + "\n" + "reservationsContinueLooking = " + this.reservationsContinueLooking + "\n" + "preemptionDisabled = " + this.getPreemptionDisabled() + "\n" + "defaultAppPriorityPerQueue = " + this.defaultAppPriorityPerQueue));
    }

    @Override
    public String getQueuePath() {
        return this.getParent().getQueuePath() + "." + this.getQueueName();
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    @InterfaceAudience.Private
    public float getMaxAMResourcePerQueuePercent() {
        return this.maxAMResourcePerQueuePercent;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public synchronized int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return this.activeUsersManager;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    synchronized void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    synchronized void setUserLimitFactor(float userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.getNumPendingApplications() + this.getNumActiveApplications();
    }

    public synchronized int getNumPendingApplications() {
        return this.pendingOrderingPolicy.getNumSchedulableEntities();
    }

    public synchronized int getNumActiveApplications() {
        return this.orderingPolicy.getNumSchedulableEntities();
    }

    @InterfaceAudience.Private
    public synchronized int getNumApplications(String user) {
        return this.getUser(user).getTotalApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumPendingApplications(String user) {
        return this.getUser(user).getPendingApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumActiveApplications(String user) {
        return this.getUser(user).getActiveApplications();
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @InterfaceAudience.Private
    public synchronized int getUserLimit() {
        return this.userLimit;
    }

    @InterfaceAudience.Private
    public synchronized float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        return queueInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public String toString() {
        return this.queueName + ": " + "capacity=" + this.queueCapacities.getCapacity() + ", " + "absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", " + "usedResources=" + this.queueUsage.getUsed() + ", " + "usedCapacity=" + this.getUsedCapacity() + ", " + "absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + ", " + "numApps=" + this.getNumApplications() + ", " + "numContainers=" + this.getNumContainers();
    }

    @VisibleForTesting
    public synchronized void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.labelManager = mgr;
    }

    @VisibleForTesting
    public synchronized User getUser(String userName) {
        User user = this.users.get(userName);
        if (user == null) {
            user = new User();
            this.users.put(userName, user);
        }
        return user;
    }

    public synchronized ArrayList<UserInfo> getUsers() {
        ArrayList<UserInfo> usersToReturn = new ArrayList<UserInfo>();
        for (Map.Entry<String, User> entry : this.users.entrySet()) {
            User user = entry.getValue();
            usersToReturn.add(new UserInfo(entry.getKey(), Resources.clone((Resource)user.getAllUsed()), user.getActiveApplications(), user.getPendingApplications(), Resources.clone((Resource)user.getConsumedAMResources()), Resources.clone((Resource)user.getUserResourceLimit()), user.getResourceUsage()));
        }
        return usersToReturn;
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof LeafQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        LeafQueue newlyParsedLeafQueue = (LeafQueue)newlyParsedQueue;
        Resource oldMax = this.getMaximumAllocation();
        Resource newMax = newlyParsedLeafQueue.getMaximumAllocation();
        if (newMax.getMemorySize() < oldMax.getMemorySize() || newMax.getVirtualCores() < oldMax.getVirtualCores()) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " the maximum allocation size can not be decreased!" + " Current setting: " + oldMax + ", trying to set it to: " + newMax);
        }
        this.setupQueueConfigs(clusterResource);
        this.activateApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            User user = this.getUser(userName);
            this.addApplicationAttempt(application, user);
        }
        if (application.isPending()) {
            this.metrics.submitAppAttempt(userName);
        }
        this.getParent().submitApplicationAttempt(application, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String userName, String queue) throws AccessControlException {
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)userName);
        if (!this.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !this.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            throw new AccessControlException("User " + userName + " cannot submit" + " applications to queue " + this.getQueuePath());
        }
        User user = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications," + " cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            user = this.getUser(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + applicationId;
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
        }
        try {
            this.getParent().submitApplication(applicationId, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.getParent().getQueuePath()), (Throwable)ace);
            throw ace;
        }
    }

    public Resource getAMResourceLimit() {
        return this.queueUsage.getAMLimit();
    }

    public Resource getAMResourceLimitPerPartition(String nodePartition) {
        return this.queueUsage.getAMLimit(nodePartition);
    }

    public synchronized Resource calculateAndGetAMResourceLimit() {
        return this.calculateAndGetAMResourceLimitPerPartition("");
    }

    @VisibleForTesting
    public synchronized Resource getUserAMResourceLimit() {
        return this.getUserAMResourceLimitPerPartition("");
    }

    public synchronized Resource getUserAMResourceLimitPerPartition(String nodePartition) {
        float effectiveUserLimit = Math.max((float)this.userLimit / 100.0f, 1.0f / (float)Math.max(this.getActiveUsersManager().getNumActiveUsers(), 1));
        Resource queuePartitionResource = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, this.lastClusterResource), (double)this.queueCapacities.getAbsoluteCapacity(nodePartition), (Resource)this.minimumAllocation);
        Resource userAMLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionResource, (double)(this.queueCapacities.getMaxAMResourcePercentage(nodePartition) * effectiveUserLimit * this.userLimitFactor), (Resource)this.minimumAllocation);
        return Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)userAMLimit, (Resource)this.getAMResourceLimitPerPartition(nodePartition)) ? userAMLimit : this.getAMResourceLimitPerPartition(nodePartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Resource calculateAndGetAMResourceLimitPerPartition(String nodePartition) {
        Resource queuePartitionResource = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, this.lastClusterResource), (double)this.queueCapacities.getAbsoluteCapacity(nodePartition), (Resource)this.minimumAllocation);
        Resource queueCurrentLimit = Resources.none();
        if (nodePartition.equals("")) {
            QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
            synchronized (queueResourceLimitsInfo) {
                queueCurrentLimit = this.queueResourceLimitsInfo.getQueueCurrentLimit();
            }
        }
        float amResourcePercent = this.queueCapacities.getMaxAMResourcePercentage(nodePartition);
        Resource queuePartitionUsableResource = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)queueCurrentLimit, (Resource)queuePartitionResource);
        Resource amResouceLimit = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)queuePartitionUsableResource, (double)amResourcePercent, (Resource)this.minimumAllocation);
        this.metrics.setAMResouceLimit(amResouceLimit);
        this.queueUsage.setAMLimit(nodePartition, amResouceLimit);
        return amResouceLimit;
    }

    private synchronized void activateApplications() {
        HashMap<String, Resource> userAmPartitionLimit = new HashMap<String, Resource>();
        for (String nodePartition : this.getNodeLabelsForQueue()) {
            this.calculateAndGetAMResourceLimitPerPartition(nodePartition);
        }
        Iterator<FiCaSchedulerApp> fsApp = this.getPendingAppsOrderingPolicy().getAssignmentIterator();
        while (fsApp.hasNext()) {
            Resource userAmIfStarted;
            FiCaSchedulerApp application = fsApp.next();
            ApplicationId applicationId = application.getApplicationId();
            String partitionName = application.getAppAMNodePartitionName();
            Resource amLimit = this.getAMResourceLimitPerPartition(partitionName);
            if (amLimit == null) {
                amLimit = this.calculateAndGetAMResourceLimitPerPartition(partitionName);
            }
            Resource amIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)this.queueUsage.getAMUsed(partitionName));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("application " + application.getId() + " AMResource " + application.getAMResource(partitionName) + " maxAMResourcePerQueuePercent " + this.maxAMResourcePerQueuePercent + " amLimit " + amLimit + " lastClusterResource " + this.lastClusterResource + " amIfStarted " + amIfStarted + " AM node-partition name " + partitionName));
            }
            if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)amIfStarted, (Resource)amLimit)) {
                if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.queueUsage.getAMUsed(partitionName), (Resource)Resources.none())) {
                    LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue, it is likely set too low. skipping enforcement to allow at least one application to start");
                } else {
                    application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Queue's AM resource limit exceeded. ");
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Not activating application " + applicationId + " as  amIfStarted: " + amIfStarted + " exceeds amLimit: " + amLimit));
                    continue;
                }
            }
            User user = this.getUser(application.getUser());
            Resource userAMLimit = (Resource)userAmPartitionLimit.get(partitionName);
            if (userAMLimit == null) {
                userAMLimit = this.getUserAMResourceLimitPerPartition(partitionName);
                userAmPartitionLimit.put(partitionName, userAMLimit);
            }
            if (!Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)(userAmIfStarted = Resources.add((Resource)application.getAMResource(partitionName), (Resource)user.getConsumedAMResources(partitionName))), (Resource)userAMLimit)) {
                if (this.getNumActiveApplications() < 1 || Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.queueUsage.getAMUsed(partitionName), (Resource)Resources.none())) {
                    LOG.warn((Object)"maximum-am-resource-percent is insufficient to start a single application in queue for user, it is likely set too low. skipping enforcement to allow at least one application to start");
                } else {
                    application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "User's AM resource limit exceeded. ");
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Not activating application " + applicationId + " for user: " + user + " as userAmIfStarted: " + userAmIfStarted + " exceeds userAmLimit: " + userAMLimit));
                    continue;
                }
            }
            user.activateApplication();
            this.orderingPolicy.addSchedulableEntity(application);
            application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, null);
            this.queueUsage.incAMUsed(partitionName, application.getAMResource(partitionName));
            user.getResourceUsage().incAMUsed(partitionName, application.getAMResource(partitionName));
            user.getResourceUsage().setAMLimit(partitionName, userAMLimit);
            this.metrics.incAMUsed(application.getUser(), application.getAMResource(partitionName));
            this.metrics.setAMResouceLimitForUser(application.getUser(), userAMLimit);
            fsApp.remove();
            LOG.info((Object)("Application " + applicationId + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
        }
    }

    private synchronized void addApplicationAttempt(FiCaSchedulerApp application, User user) {
        user.submitApplication();
        this.getPendingAppsOrderingPolicy().addSchedulableEntity(application);
        this.applicationAttemptMap.put(application.getApplicationAttemptId(), application);
        if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)this.lastClusterResource, (Resource)this.lastClusterResource, (Resource)Resources.none())) {
            this.activateApplications();
        } else {
            application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.INACTIVATED, "Skipping AM assignment as cluster resource is empty. ");
            LOG.info((Object)("Skipping activateApplications for " + application.getApplicationAttemptId() + " since cluster resource is " + Resources.none()));
        }
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + application.getUser() + "," + " leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    @Override
    public void finishApplication(ApplicationId application, String user) {
        this.activeUsersManager.deactivateApplication(user, application);
        this.getParent().finishApplication(application, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.removeApplicationAttempt(application, this.getUser(application.getUser()));
        }
        this.getParent().finishApplicationAttempt(application, queue);
    }

    public synchronized void removeApplicationAttempt(FiCaSchedulerApp application, User user) {
        String partitionName = application.getAppAMNodePartitionName();
        boolean wasActive = this.orderingPolicy.removeSchedulableEntity(application);
        if (!wasActive) {
            this.pendingOrderingPolicy.removeSchedulableEntity(application);
        } else {
            this.queueUsage.decAMUsed(partitionName, application.getAMResource(partitionName));
            user.getResourceUsage().decAMUsed(partitionName, application.getAMResource(partitionName));
            this.metrics.decAMUsed(application.getUser(), application.getAMResource());
        }
        this.applicationAttemptMap.remove(application.getApplicationAttemptId());
        user.finishApplication(wasActive);
        if (user.getTotalApplications() == 0) {
            this.users.remove(application.getUser());
        }
        this.activateApplications();
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    private synchronized FiCaSchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationAttemptMap.get(applicationAttemptId);
    }

    private void handleExcessReservedContainer(Resource clusterResource, CSAssignment assignment, FiCaSchedulerNode node, FiCaSchedulerApp app) {
        if (assignment.getExcessReservation() != null) {
            RMContainer excessReservedContainer = assignment.getExcessReservation();
            if (excessReservedContainer.hasIncreaseReservation()) {
                this.unreserveIncreasedContainer(clusterResource, app, node, excessReservedContainer);
            } else {
                this.completedContainer(clusterResource, assignment.getApplication(), this.scheduler.getNode(excessReservedContainer.getAllocatedNode()), excessReservedContainer, SchedulerUtils.createAbnormalContainerStatus(excessReservedContainer.getContainerId(), "Container reservation no longer required."), RMContainerEventType.RELEASED, null, false);
            }
            assignment.setExcessReservation(null);
        }
    }

    private void killToPreemptContainers(Resource clusterResource, FiCaSchedulerNode node, CSAssignment assignment) {
        if (assignment.getContainersToKill() != null) {
            StringBuilder sb = new StringBuilder("Killing containers: [");
            for (RMContainer c : assignment.getContainersToKill()) {
                FiCaSchedulerApp application = this.csContext.getApplicationAttempt(c.getApplicationAttemptId());
                LeafQueue q = application.getCSLeafQueue();
                q.completedContainer(clusterResource, application, node, c, SchedulerUtils.createPreemptedContainerStatus(c.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
                sb.append("(container=" + c.getContainerId() + " resource=" + c.getAllocatedResource() + ")");
            }
            sb.append("] for container=" + assignment.getAssignmentInformation().getFirstAllocatedOrReservedContainerId() + " resource=" + assignment.getResource());
            LOG.info((Object)sb.toString());
        }
    }

    private void setPreemptionAllowed(ResourceLimits limits, String nodePartition) {
        float guaranteedCapacity;
        float usedCapacity = this.queueCapacities.getAbsoluteUsedCapacity(nodePartition);
        limits.setIsAllowPreemption(usedCapacity < (guaranteedCapacity = this.queueCapacities.getAbsoluteCapacity(nodePartition)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode) {
        FiCaSchedulerApp reservedApp = null;
        CSAssignment reservedCSAssignment = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("assignContainers: node=" + node.getNodeName() + " #applications=" + this.orderingPolicy.getNumSchedulableEntities()));
            }
            this.setPreemptionAllowed(currentResourceLimits, node.getPartition());
            RMContainer reservedContainer = node.getReservedContainer();
            if (reservedContainer != null) {
                FiCaSchedulerApp fiCaSchedulerApp = reservedApp = this.getApplication(reservedContainer.getApplicationAttemptId());
                synchronized (fiCaSchedulerApp) {
                    reservedCSAssignment = reservedApp.assignContainers(clusterResource, node, currentResourceLimits, schedulingMode, reservedContainer);
                }
            }
        }
        if (reservedCSAssignment != null) {
            this.handleExcessReservedContainer(clusterResource, reservedCSAssignment, node, reservedApp);
            this.killToPreemptContainers(clusterResource, node, reservedCSAssignment);
            return reservedCSAssignment;
        }
        leafQueue = this;
        synchronized (leafQueue) {
            if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.accessibleToPartition(node.getPartition())) {
                return CSAssignment.NULL_ASSIGNMENT;
            }
            if (!this.hasPendingResourceRequest(node.getPartition(), clusterResource, schedulingMode)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + node.getPartition()));
                }
                return CSAssignment.NULL_ASSIGNMENT;
            }
            Iterator<FiCaSchedulerApp> assignmentIterator = this.orderingPolicy.getAssignmentIterator();
            while (assignmentIterator.hasNext()) {
                FiCaSchedulerApp application = assignmentIterator.next();
                if (!super.canAssignToThisQueue(clusterResource, node.getPartition(), currentResourceLimits, application.getCurrentReservation(), schedulingMode)) {
                    return CSAssignment.NULL_ASSIGNMENT;
                }
                Resource userLimit = this.computeUserLimitAndSetHeadroom(application, clusterResource, node.getPartition(), schedulingMode);
                if (!this.canAssignToUser(clusterResource, application.getUser(), userLimit, application, node.getPartition(), currentResourceLimits)) {
                    application.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, "User capacity has reached its maximum limit.");
                    continue;
                }
                CSAssignment assignment = application.assignContainers(clusterResource, node, currentResourceLimits, schedulingMode, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
                    application.showRequests();
                }
                Resource assigned = assignment.getResource();
                this.handleExcessReservedContainer(clusterResource, assignment, node, application);
                this.killToPreemptContainers(clusterResource, node, assignment);
                if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assigned, (Resource)Resources.none())) {
                    RMContainer reservedOrAllocatedRMContainer = application.getRMContainer(assignment.getAssignmentInformation().getFirstAllocatedOrReservedContainerId());
                    this.allocateResource(clusterResource, application, assigned, node.getPartition(), reservedOrAllocatedRMContainer, assignment.isIncreasedAllocation());
                    Resource reservedRes = assignment.getAssignmentInformation().getReserved();
                    if (reservedRes != null && !reservedRes.equals((Object)Resources.none())) {
                        this.incReservedResource(node.getPartition(), reservedRes);
                    }
                    return assignment;
                }
                if (assignment.getSkippedType() == CSAssignment.SkippedType.OTHER) {
                    application.updateNodeInfoForAMDiagnostics(node);
                    continue;
                }
                if (assignment.getSkippedType() == CSAssignment.SkippedType.QUEUE_LIMIT) {
                    return assignment;
                }
                return CSAssignment.NULL_ASSIGNMENT;
            }
            return CSAssignment.NULL_ASSIGNMENT;
        }
    }

    protected Resource getHeadroom(User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, application, "");
    }

    protected Resource getHeadroom(User user, Resource queueCurrentLimit, Resource clusterResource, FiCaSchedulerApp application, String partition) {
        return this.getHeadroom(user, queueCurrentLimit, clusterResource, this.computeUserLimit(application.getUser(), clusterResource, user, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), partition);
    }

    private Resource getHeadroom(User user, Resource currentPartitionResourceLimit, Resource clusterResource, Resource userLimitResource, String partition) {
        currentPartitionResourceLimit = partition.equals("") ? currentPartitionResourceLimit : this.getQueueMaxResource(partition, clusterResource);
        Resource headroom = Resources.componentwiseMin((Resource)Resources.subtract((Resource)userLimitResource, (Resource)user.getUsed(partition)), (Resource)Resources.subtract((Resource)currentPartitionResourceLimit, (Resource)this.queueUsage.getUsed(partition)));
        headroom = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)headroom, (Resource)this.minimumAllocation);
        Resource clusterPartitionResource = this.labelManager.getResourceByLabel(partition, clusterResource);
        Resource clusterFreePartitionResource = Resources.subtract((Resource)clusterPartitionResource, (Resource)this.csContext.getClusterResourceUsage().getUsed(partition));
        headroom = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterPartitionResource, (Resource)clusterFreePartitionResource, (Resource)headroom);
        return headroom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueueResourceLimitsInfo(Resource clusterResource) {
        QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
        synchronized (queueResourceLimitsInfo) {
            this.queueResourceLimitsInfo.setQueueCurrentLimit(this.cachedResourceLimitsForHeadroom.getLimit());
            this.queueResourceLimitsInfo.setClusterResource(clusterResource);
        }
    }

    @Lock(value={LeafQueue.class, FiCaSchedulerApp.class})
    Resource computeUserLimitAndSetHeadroom(FiCaSchedulerApp application, Resource clusterResource, String nodePartition, SchedulingMode schedulingMode) {
        String user = application.getUser();
        User queueUser = this.getUser(user);
        Resource userLimit = this.computeUserLimit(application.getUser(), clusterResource, queueUser, nodePartition, schedulingMode);
        this.setQueueResourceLimitsInfo(clusterResource);
        Resource headroom = this.getHeadroom(queueUser, this.cachedResourceLimitsForHeadroom.getLimit(), clusterResource, userLimit, nodePartition);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for user " + user + ": " + " userLimit=" + userLimit + " queueMaxAvailRes=" + this.cachedResourceLimitsForHeadroom.getLimit() + " consumed=" + queueUser.getUsed() + " headroom=" + headroom));
        }
        CapacityHeadroomProvider headroomProvider = new CapacityHeadroomProvider(queueUser, this, application, this.queueResourceLimitsInfo);
        application.setHeadroomProvider(headroomProvider);
        this.metrics.setAvailableResourcesToUser(user, headroom);
        return userLimit;
    }

    @Lock(value={Lock.NoLock.class})
    public int getNodeLocalityDelay() {
        return this.nodeLocalityDelay;
    }

    @Lock(value={Lock.NoLock.class})
    public boolean getRackLocalityFullReset() {
        return this.rackLocalityFullReset;
    }

    @Lock(value={Lock.NoLock.class})
    private Resource computeUserLimit(String userName, Resource clusterResource, User user, String nodePartition, SchedulingMode schedulingMode) {
        Resource partitionResource = this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        Resource queueCapacity = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (double)this.queueCapacities.getAbsoluteCapacity(nodePartition), (Resource)this.minimumAllocation);
        Resource required = this.minimumAllocation;
        queueCapacity = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)queueCapacity, (Resource)required);
        Resource consumed = Resources.multiplyAndNormalizeUp((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (double)this.qUsageRatios.getUsageRatio(nodePartition), (Resource)this.minimumAllocation);
        Resource currentCapacity = Resources.lessThan((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)consumed, (Resource)queueCapacity) ? queueCapacity : Resources.add((Resource)consumed, (Resource)required);
        int activeUsers = this.activeUsersManager.getNumActiveUsers();
        Resource userLimitResource = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)currentCapacity, (int)activeUsers), (Resource)Resources.divideAndCeil((ResourceCalculator)this.resourceCalculator, (Resource)Resources.multiplyAndRoundDown((Resource)currentCapacity, (double)this.userLimit), (int)100));
        Resource maxUserLimit = Resources.none();
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY) {
            maxUserLimit = Resources.multiplyAndRoundDown((Resource)queueCapacity, (double)this.userLimitFactor);
        } else if (schedulingMode == SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY) {
            maxUserLimit = partitionResource;
        }
        userLimitResource = Resources.roundUp((ResourceCalculator)this.resourceCalculator, (Resource)Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)userLimitResource, (Resource)maxUserLimit), (Resource)this.minimumAllocation);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User limit computation for " + userName + " in queue " + this.getQueueName() + " userLimitPercent=" + this.userLimit + " userLimitFactor=" + this.userLimitFactor + " required: " + required + " consumed: " + consumed + " user-limit-resource: " + userLimitResource + " queueCapacity: " + queueCapacity + " qconsumed: " + this.queueUsage.getUsed() + " consumedRatio: " + this.totalUserConsumedRatio + " currentCapacity: " + currentCapacity + " activeUsers: " + activeUsers + " clusterCapacity: " + clusterResource + " resourceByLabel: " + partitionResource + " usageratio: " + this.qUsageRatios.getUsageRatio(nodePartition) + " Partition: " + nodePartition));
        }
        user.setUserResourceLimit(userLimitResource);
        return userLimitResource;
    }

    @InterfaceAudience.Private
    protected synchronized boolean canAssignToUser(Resource clusterResource, String userName, Resource limit, FiCaSchedulerApp application, String nodePartition, ResourceLimits currentResourceLimits) {
        User user = this.getUser(userName);
        currentResourceLimits.setAmountNeededUnreserve(Resources.none());
        if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)user.getUsed(nodePartition), (Resource)limit)) {
            if (this.reservationsContinueLooking && nodePartition.equals("") && Resources.lessThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.subtract((Resource)user.getUsed(), (Resource)application.getCurrentReservation()), (Resource)limit)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit based on reservations - " + " consumed: " + user.getUsed() + " reserved: " + application.getCurrentReservation() + " limit: " + limit));
                }
                Resource amountNeededToUnreserve = Resources.subtract((Resource)user.getUsed(nodePartition), (Resource)limit);
                currentResourceLimits.setAmountNeededUnreserve(amountNeededToUnreserve);
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit - " + " consumed: " + user.getUsed(nodePartition) + " limit: " + limit));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unreserveIncreasedContainer(Resource clusterResource, FiCaSchedulerApp app, FiCaSchedulerNode node, RMContainer rmContainer) {
        boolean removed = false;
        Priority priority = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (rmContainer.getContainer() != null) {
                priority = rmContainer.getContainer().getPriority();
            }
            if (null != priority) {
                removed = app.unreserve(rmContainer.getContainer().getPriority(), node, rmContainer);
            }
            if (removed) {
                this.orderingPolicy.containerReleased(app, rmContainer);
                this.releaseResource(clusterResource, app, rmContainer.getReservedResource(), node.getPartition(), rmContainer, true);
            }
        }
        if (removed) {
            this.getParent().unreserveIncreasedContainer(clusterResource, app, node, rmContainer);
        }
    }

    private synchronized float calculateUserUsageRatio(Resource clusterResource, String nodePartition) {
        Resource resourceByLabel = this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        float consumed = 0.0f;
        for (Map.Entry<String, User> entry : this.users.entrySet()) {
            User user = entry.getValue();
            consumed += user.resetAndUpdateUsageRatio(this.resourceCalculator, resourceByLabel, nodePartition);
        }
        return consumed;
    }

    private synchronized void recalculateQueueUsageRatio(Resource clusterResource, String nodePartition) {
        ResourceUsage queueResourceUsage = this.getQueueResourceUsage();
        if (nodePartition == null) {
            for (String partition : Sets.union(this.queueCapacities.getNodePartitionsSet(), queueResourceUsage.getNodePartitionsSet())) {
                this.qUsageRatios.setUsageRatio(partition, this.calculateUserUsageRatio(clusterResource, partition));
            }
        } else {
            this.qUsageRatios.setUsageRatio(nodePartition, this.calculateUserUsageRatio(clusterResource, nodePartition));
        }
    }

    private synchronized void updateQueueUsageRatio(String nodePartition, float delta) {
        this.qUsageRatios.incUsageRatio(nodePartition, delta);
    }

    private void updateSchedulerHealthForCompletedContainer(RMContainer rmContainer, ContainerStatus containerStatus) {
        SchedulerHealth schedulerHealth = this.csContext.getSchedulerHealth();
        if (null == schedulerHealth) {
            return;
        }
        if (containerStatus.getExitStatus() == -102) {
            schedulerHealth.updatePreemption(Time.now(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
            schedulerHealth.updateSchedulerPreemptionCounts(1L);
        } else {
            schedulerHealth.updateRelease(this.csContext.getLastNodeUpdateTime(), rmContainer.getAllocatedNode(), rmContainer.getContainerId(), this.getQueuePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue childQueue, boolean sortQueues) {
        this.updateSchedulerHealthForCompletedContainer(rmContainer, containerStatus);
        if (application != null) {
            if (rmContainer.hasIncreaseReservation()) {
                this.unreserveIncreasedContainer(clusterResource, application, node, rmContainer);
            }
            application.removeIncreaseRequest(node.getNodeID(), rmContainer.getAllocatedPriority(), rmContainer.getContainerId());
            boolean removed = false;
            LeafQueue leafQueue = this;
            synchronized (leafQueue) {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    removed = application.unreserve(rmContainer.getReservedPriority(), node, rmContainer);
                } else {
                    removed = application.containerCompleted(rmContainer, containerStatus, event, node.getPartition());
                    node.releaseContainer(rmContainer.getContainerId(), false);
                }
                if (removed) {
                    this.orderingPolicy.containerReleased(application, rmContainer);
                    this.releaseResource(clusterResource, application, container.getResource(), node.getPartition(), rmContainer, false);
                }
            }
            if (removed) {
                this.getParent().completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
        this.csContext.getPreemptionManager().removeKillableContainer(new KillableContainer(rmContainer, node.getPartition(), this.queueName));
    }

    synchronized void allocateResource(Resource clusterResource, SchedulerApplicationAttempt application, Resource resource, String nodePartition, RMContainer rmContainer, boolean isIncreasedAllocation) {
        super.allocateResource(clusterResource, resource, nodePartition, isIncreasedAllocation);
        Resource resourceByLabel = this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("")) {
            TreeSet<RMContainer> rmContainers = null;
            rmContainers = this.ignorePartitionExclusivityRMContainers.get(nodePartition);
            if (null == rmContainers) {
                rmContainers = new TreeSet();
                this.ignorePartitionExclusivityRMContainers.put(nodePartition, rmContainers);
            }
            rmContainers.add(rmContainer);
        }
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.assignContainer(resource, nodePartition);
        this.updateQueueUsageRatio(nodePartition, user.updateUsageRatio(this.resourceCalculator, resourceByLabel, nodePartition));
        Resources.subtractFrom((Resource)application.getHeadroom(), (Resource)resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getQueueName() + " user=" + userName + " used=" + this.queueUsage.getUsed() + " numContainers=" + this.numContainers + " headroom = " + application.getHeadroom() + " user-resources=" + user.getUsed()));
        }
    }

    synchronized void releaseResource(Resource clusterResource, FiCaSchedulerApp application, Resource resource, String nodePartition, RMContainer rmContainer, boolean isChangeResource) {
        super.releaseResource(clusterResource, resource, nodePartition, isChangeResource);
        Resource resourceByLabel = this.labelManager.getResourceByLabel(nodePartition, clusterResource);
        if (null != rmContainer && rmContainer.getNodeLabelExpression().equals("") && !nodePartition.equals("") && this.ignorePartitionExclusivityRMContainers.containsKey(nodePartition)) {
            Set rmContainers = this.ignorePartitionExclusivityRMContainers.get(nodePartition);
            rmContainers.remove(rmContainer);
            if (rmContainers.isEmpty()) {
                this.ignorePartitionExclusivityRMContainers.remove(nodePartition);
            }
        }
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.releaseContainer(resource, nodePartition);
        this.updateQueueUsageRatio(nodePartition, user.updateUsageRatio(this.resourceCalculator, resourceByLabel, nodePartition));
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getQueueName() + " used=" + this.queueUsage.getUsed() + " numContainers=" + this.numContainers + " user=" + userName + " user-resources=" + user.getUsed()));
        }
    }

    private void updateCurrentResourceLimits(ResourceLimits currentResourceLimits, Resource clusterResource) {
        this.cachedResourceLimitsForHeadroom = new ResourceLimits(currentResourceLimits.getLimit());
        Resource queueMaxResource = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel("", clusterResource), (double)this.queueCapacities.getAbsoluteMaximumCapacity(""), (Resource)this.minimumAllocation);
        this.cachedResourceLimitsForHeadroom.setLimit(Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)queueMaxResource, (Resource)currentResourceLimits.getLimit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateClusterResource(Resource clusterResource, ResourceLimits currentResourceLimits) {
        this.updateCurrentResourceLimits(currentResourceLimits, clusterResource);
        this.lastClusterResource = clusterResource;
        this.setQueueResourceLimitsInfo(clusterResource);
        this.recalculateQueueUsageRatio(clusterResource, null);
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this.minimumAllocation, this, this.labelManager, null);
        this.activateApplications();
        Iterator<FiCaSchedulerApp> i$ = this.orderingPolicy.getSchedulableEntities().iterator();
        while (i$.hasNext()) {
            FiCaSchedulerApp application;
            FiCaSchedulerApp fiCaSchedulerApp = application = i$.next();
            synchronized (fiCaSchedulerApp) {
                this.computeUserLimitAndSetHeadroom(application, clusterResource, "", SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            }
        }
    }

    @Override
    public void incUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().incUsed(nodeLabel, resourceToInc);
        super.incUsedResource(nodeLabel, resourceToInc, application);
    }

    @Override
    public void decUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().decUsed(nodeLabel, resourceToDec);
        super.decUsedResource(nodeLabel, resourceToDec, application);
    }

    public void incAMUsedResource(String nodeLabel, Resource resourceToInc, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().incAMUsed(nodeLabel, resourceToInc);
        this.queueUsage.incAMUsed(nodeLabel, resourceToInc);
    }

    public void decAMUsedResource(String nodeLabel, Resource resourceToDec, SchedulerApplicationAttempt application) {
        this.getUser(application.getUser()).getResourceUsage().decAMUsed(nodeLabel, resourceToDec);
        this.queueUsage.decAMUsed(nodeLabel, resourceToDec);
    }

    @VisibleForTesting
    public float getUsageRatio(String label) {
        return this.qUsageRatios.getUsageRatio(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, attempt, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer, false);
        }
        this.getParent().recoverContainer(clusterResource, attempt, rmContainer);
    }

    public Collection<FiCaSchedulerApp> getPendingApplications() {
        return Collections.unmodifiableCollection(this.pendingOrderingPolicy.getSchedulableEntities());
    }

    public synchronized Collection<FiCaSchedulerApp> getApplications() {
        return Collections.unmodifiableCollection(this.orderingPolicy.getSchedulableEntities());
    }

    public synchronized Collection<FiCaSchedulerApp> getAllApplications() {
        HashSet<FiCaSchedulerApp> apps = new HashSet<FiCaSchedulerApp>(this.pendingOrderingPolicy.getSchedulableEntities());
        apps.addAll(this.orderingPolicy.getSchedulableEntities());
        return Collections.unmodifiableCollection(apps);
    }

    public synchronized Resource getTotalPendingResourcesConsideringUserLimit(Resource resources, String partition) {
        HashMap<String, Resource> userNameToHeadroom = new HashMap<String, Resource>();
        Resource pendingConsideringUserLimit = Resource.newInstance((int)0, (int)0);
        for (FiCaSchedulerApp app : this.getApplications()) {
            String userName = app.getUser();
            if (!userNameToHeadroom.containsKey(userName)) {
                User user = this.getUser(userName);
                Resource headroom = Resources.subtract((Resource)this.computeUserLimit(app.getUser(), resources, user, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY), (Resource)user.getUsed(partition));
                headroom = Resources.componentwiseMax((Resource)headroom, (Resource)Resources.none());
                userNameToHeadroom.put(userName, headroom);
            }
            Resource minpendingConsideringUserLimit = Resources.componentwiseMin((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)app.getAppAttemptResourceUsage().getPending(partition));
            Resources.addTo((Resource)pendingConsideringUserLimit, (Resource)minpendingConsideringUserLimit);
            Resources.subtractFrom((Resource)((Resource)userNameToHeadroom.get(userName)), (Resource)minpendingConsideringUserLimit);
        }
        return pendingConsideringUserLimit;
    }

    public synchronized Resource getUserLimitPerUser(String userName, Resource resources, String partition) {
        User user = this.getUser(userName);
        return this.computeUserLimit(userName, resources, user, partition, SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
    }

    @Override
    public synchronized void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (FiCaSchedulerApp pendingApp : this.pendingOrderingPolicy.getSchedulableEntities()) {
            apps.add(pendingApp.getApplicationAttemptId());
        }
        for (FiCaSchedulerApp app : this.orderingPolicy.getSchedulableEntities()) {
            apps.add(app.getApplicationAttemptId());
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer, false);
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveIn=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().attachContainer(clusterResource, application, rmContainer);
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.releaseResource(clusterResource, application, rmContainer.getContainer().getResource(), node.getPartition(), rmContainer, false);
            LOG.info((Object)("movedContainer container=" + rmContainer.getContainer() + " resource=" + rmContainer.getContainer().getResource() + " queueMoveOut=" + this + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            this.getParent().detachContainer(clusterResource, application, rmContainer);
        }
    }

    public synchronized Map<String, TreeSet<RMContainer>> getIgnoreExclusivityRMContainers() {
        return this.ignorePartitionExclusivityRMContainers;
    }

    public void setCapacity(float capacity) {
        this.queueCapacities.setCapacity(capacity);
    }

    public void setAbsoluteCapacity(float absoluteCapacity) {
        this.queueCapacities.setAbsoluteCapacity(absoluteCapacity);
    }

    public void setMaxApplications(int maxApplications) {
        this.maxApplications = maxApplications;
    }

    public synchronized OrderingPolicy<FiCaSchedulerApp> getOrderingPolicy() {
        return this.orderingPolicy;
    }

    public synchronized void setOrderingPolicy(OrderingPolicy<FiCaSchedulerApp> orderingPolicy) {
        if (null != this.orderingPolicy) {
            orderingPolicy.addAllSchedulableEntities(this.orderingPolicy.getSchedulableEntities());
        }
        this.orderingPolicy = orderingPolicy;
    }

    @Override
    public Priority getDefaultApplicationPriority() {
        return this.defaultAppPriorityPerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decreaseContainer(Resource clusterResource, SchedContainerChangeRequest decreaseRequest, FiCaSchedulerApp app) throws InvalidResourceRequestException {
        Resource resourceBeforeDecrease;
        RMContainer rmContainer = decreaseRequest.getRMContainer();
        if (rmContainer.hasIncreaseReservation()) {
            this.unreserveIncreasedContainer(clusterResource, app, (FiCaSchedulerNode)decreaseRequest.getSchedulerNode(), rmContainer);
        }
        boolean resourceDecreased = false;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            Resource absDelta;
            RMServerUtils.checkSchedContainerChangeRequest(decreaseRequest, false);
            resourceBeforeDecrease = Resources.clone((Resource)rmContainer.getAllocatedResource());
            boolean hasIncreaseRequest = app.removeIncreaseRequest(decreaseRequest.getNodeId(), decreaseRequest.getPriority(), decreaseRequest.getContainerId());
            if (hasIncreaseRequest && LOG.isDebugEnabled()) {
                LOG.debug((Object)("While processing decrease requests, found an increase request for the same container " + decreaseRequest.getContainerId() + ", removed the increase request"));
            }
            if (Resources.equals((Resource)(absDelta = Resources.negate((Resource)decreaseRequest.getDeltaCapacity())), (Resource)Resources.none())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Decrease target resource equals to existing resource for container:" + decreaseRequest.getContainerId() + " ignore this decrease request."));
                }
            } else {
                this.releaseResource(clusterResource, app, absDelta, decreaseRequest.getNodePartition(), decreaseRequest.getRMContainer(), true);
                app.decreaseContainer(decreaseRequest);
                decreaseRequest.getSchedulerNode().decreaseContainer(decreaseRequest.getContainerId(), absDelta);
                resourceDecreased = true;
            }
        }
        if (resourceDecreased) {
            this.getParent().decreaseContainer(clusterResource, decreaseRequest, app);
            LOG.info((Object)("Application attempt " + app.getApplicationAttemptId() + " decreased container:" + decreaseRequest.getContainerId() + " from " + resourceBeforeDecrease + " to " + decreaseRequest.getTargetCapacity()));
        }
    }

    public synchronized OrderingPolicy<FiCaSchedulerApp> getPendingAppsOrderingPolicy() {
        return this.pendingOrderingPolicy;
    }

    static class QueueResourceLimitsInfo {
        private Resource queueCurrentLimit;
        private Resource clusterResource;

        QueueResourceLimitsInfo() {
        }

        public void setQueueCurrentLimit(Resource currentLimit) {
            this.queueCurrentLimit = currentLimit;
        }

        public Resource getQueueCurrentLimit() {
            return this.queueCurrentLimit;
        }

        public void setClusterResource(Resource clusterResource) {
            this.clusterResource = clusterResource;
        }

        public Resource getClusterResource() {
            return this.clusterResource;
        }
    }

    @VisibleForTesting
    public static class User {
        ResourceUsage userResourceUsage = new ResourceUsage();
        volatile Resource userResourceLimit = Resource.newInstance((int)0, (int)0);
        int pendingApplications = 0;
        int activeApplications = 0;
        private UsageRatios userUsageRatios = new UsageRatios();

        public ResourceUsage getResourceUsage() {
            return this.userResourceUsage;
        }

        public synchronized float resetAndUpdateUsageRatio(ResourceCalculator resourceCalculator, Resource resource, String nodePartition) {
            this.userUsageRatios.setUsageRatio(nodePartition, 0.0f);
            return this.updateUsageRatio(resourceCalculator, resource, nodePartition);
        }

        public synchronized float updateUsageRatio(ResourceCalculator resourceCalculator, Resource resource, String nodePartition) {
            float newRatio = Resources.ratio((ResourceCalculator)resourceCalculator, (Resource)this.getUsed(nodePartition), (Resource)resource);
            float delta = newRatio - this.userUsageRatios.getUsageRatio(nodePartition);
            this.userUsageRatios.setUsageRatio(nodePartition, newRatio);
            return delta;
        }

        public Resource getUsed() {
            return this.userResourceUsage.getUsed();
        }

        public Resource getAllUsed() {
            return this.userResourceUsage.getAllUsed();
        }

        public Resource getUsed(String label) {
            return this.userResourceUsage.getUsed(label);
        }

        public int getPendingApplications() {
            return this.pendingApplications;
        }

        public int getActiveApplications() {
            return this.activeApplications;
        }

        public Resource getConsumedAMResources() {
            return this.userResourceUsage.getAMUsed();
        }

        public Resource getConsumedAMResources(String label) {
            return this.userResourceUsage.getAMUsed(label);
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public synchronized void submitApplication() {
            ++this.pendingApplications;
        }

        public synchronized void activateApplication() {
            --this.pendingApplications;
            ++this.activeApplications;
        }

        public synchronized void finishApplication(boolean wasActive) {
            if (wasActive) {
                --this.activeApplications;
            } else {
                --this.pendingApplications;
            }
        }

        public void assignContainer(Resource resource, String nodePartition) {
            this.userResourceUsage.incUsed(nodePartition, resource);
        }

        public void releaseContainer(Resource resource, String nodePartition) {
            this.userResourceUsage.decUsed(nodePartition, resource);
        }

        public Resource getUserResourceLimit() {
            return this.userResourceLimit;
        }

        public void setUserResourceLimit(Resource userResourceLimit) {
            this.userResourceLimit = userResourceLimit;
        }
    }

    private static class UsageRatios {
        private Map<String, Float> usageRatios;
        private ReentrantReadWriteLock.ReadLock readLock;
        private ReentrantReadWriteLock.WriteLock writeLock;

        public UsageRatios() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
            this.usageRatios = new HashMap<String, Float>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incUsageRatio(String label, float delta) {
            try {
                this.writeLock.lock();
                Float fl = this.usageRatios.get(label);
                if (null == fl) {
                    fl = new Float(0.0);
                }
                fl = Float.valueOf(fl.floatValue() + delta);
                this.usageRatios.put(label, new Float(fl.floatValue()));
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        float getUsageRatio(String label) {
            try {
                this.readLock.lock();
                Float f = this.usageRatios.get(label);
                if (null == f) {
                    float f2 = 0.0f;
                    return f2;
                }
                float f3 = f.floatValue();
                return f3;
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setUsageRatio(String label, float ratio) {
            try {
                this.writeLock.lock();
                this.usageRatios.put(label, new Float(ratio));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

