/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.junit.Assert;

public class MetricsAssertHelperImpl
implements MetricsAssertHelper {
    private Map<String, String> tags = new HashMap<String, String>();
    private Map<String, Number> gauges = new HashMap<String, Number>();
    private Map<String, Long> counters = new HashMap<String, Long>();

    public void init() {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    public void assertTag(String name, String expected, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        Assert.assertEquals((String)"Tags should be equal", (Object)expected, (Object)this.tags.get(cName));
    }

    public void assertGauge(String name, long expected, BaseSource source) {
        long found = this.getGaugeLong(name, source);
        Assert.assertEquals((String)"Metrics Should be equal", (long)expected, (long)found);
    }

    public void assertGaugeGt(String name, long expected, BaseSource source) {
        double found = this.getGaugeDouble(name, source);
        Assert.assertTrue((String)(name + " (" + found + ") should be greater than " + expected), (found > (double)expected ? 1 : 0) != 0);
    }

    public void assertGaugeLt(String name, long expected, BaseSource source) {
        double found = this.getGaugeDouble(name, source);
        Assert.assertTrue((String)(name + "(" + found + ") should be less than " + expected), (found < (double)expected ? 1 : 0) != 0);
    }

    public void assertGauge(String name, double expected, BaseSource source) {
        double found = this.getGaugeDouble(name, source);
        Assert.assertEquals((String)"Metrics Should be equal", (double)expected, (double)found, (double)0.01);
    }

    public void assertGaugeGt(String name, double expected, BaseSource source) {
        double found = this.getGaugeDouble(name, source);
        Assert.assertTrue((String)(name + "(" + found + ") should be greater than " + expected), (found > expected ? 1 : 0) != 0);
    }

    public void assertGaugeLt(String name, double expected, BaseSource source) {
        double found = this.getGaugeDouble(name, source);
        Assert.assertTrue((String)(name + "(" + found + ") should be less than " + expected), (found < expected ? 1 : 0) != 0);
    }

    public void assertCounter(String name, long expected, BaseSource source) {
        long found = this.getCounter(name, source);
        Assert.assertEquals((String)"Metrics Counters should be equal", (long)expected, (long)found);
    }

    public void assertCounterGt(String name, long expected, BaseSource source) {
        long found = this.getCounter(name, source);
        Assert.assertTrue((String)(name + " (" + found + ") should be greater than " + expected), (found > expected ? 1 : 0) != 0);
    }

    public void assertCounterLt(String name, long expected, BaseSource source) {
        long found = this.getCounter(name, source);
        Assert.assertTrue((String)(name + "(" + found + ") should be less than " + expected), (found < expected ? 1 : 0) != 0);
    }

    public long getCounter(String name, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        Assert.assertNotNull((String)("Should get counter " + cName + " but did not"), (Object)this.counters.get(cName));
        return this.counters.get(cName);
    }

    public boolean checkCounterExists(String name, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        return this.counters.get(cName) != null;
    }

    public boolean checkGaugeExists(String name, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        return this.gauges.get(cName) != null;
    }

    public double getGaugeDouble(String name, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        Assert.assertNotNull((String)("Should get gauge " + cName + " but did not"), (Object)this.gauges.get(cName));
        return this.gauges.get(cName).doubleValue();
    }

    public long getGaugeLong(String name, BaseSource source) {
        this.getMetrics(source);
        String cName = this.canonicalizeMetricName(name);
        Assert.assertNotNull((String)("Should get gauge " + cName + " but did not"), (Object)this.gauges.get(cName));
        return this.gauges.get(cName).longValue();
    }

    public String toDebugString(BaseSource source) {
        this.getMetrics(source);
        StringBuilder sb = new StringBuilder();
        sb.append("Tags=").append(this.tags).append(", Counters=").append(this.counters);
        return sb.append(", Gauges=").append(this.gauges).toString();
    }

    private void reset() {
        this.tags.clear();
        this.gauges.clear();
        this.counters.clear();
    }

    private void getMetrics(BaseSource source) {
        this.reset();
        if (!(source instanceof MetricsSource)) {
            Assert.assertTrue((String)"The Source passed must be a MetricsSource", (boolean)false);
        }
        MetricsSource impl = (MetricsSource)source;
        impl.getMetrics((MetricsCollector)new MockMetricsBuilder(), true);
    }

    private String canonicalizeMetricName(String in) {
        return in.toLowerCase(Locale.ROOT).replaceAll("[^A-Za-z0-9 ]", "");
    }

    public class MockRecordBuilder
    extends MetricsRecordBuilder {
        private final MetricsCollector mockMetricsBuilder;

        public MockRecordBuilder(MetricsCollector mockMetricsBuilder) {
            this.mockMetricsBuilder = mockMetricsBuilder;
        }

        public MetricsRecordBuilder tag(MetricsInfo metricsInfo, String s) {
            MetricsAssertHelperImpl.this.tags.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), s);
            return this;
        }

        public MetricsRecordBuilder add(MetricsTag metricsTag) {
            MetricsAssertHelperImpl.this.tags.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsTag.name()), metricsTag.value());
            return this;
        }

        public MetricsRecordBuilder add(AbstractMetric abstractMetric) {
            MetricsAssertHelperImpl.this.gauges.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(abstractMetric.name()), abstractMetric.value());
            return this;
        }

        public MetricsRecordBuilder setContext(String s) {
            return this;
        }

        public MetricsRecordBuilder addCounter(MetricsInfo metricsInfo, int i) {
            MetricsAssertHelperImpl.this.counters.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), Long.valueOf(i));
            return this;
        }

        public MetricsRecordBuilder addCounter(MetricsInfo metricsInfo, long l) {
            MetricsAssertHelperImpl.this.counters.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), l);
            return this;
        }

        public MetricsRecordBuilder addGauge(MetricsInfo metricsInfo, int i) {
            MetricsAssertHelperImpl.this.gauges.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), Long.valueOf(i));
            return this;
        }

        public MetricsRecordBuilder addGauge(MetricsInfo metricsInfo, long l) {
            MetricsAssertHelperImpl.this.gauges.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), l);
            return this;
        }

        public MetricsRecordBuilder addGauge(MetricsInfo metricsInfo, float v) {
            MetricsAssertHelperImpl.this.gauges.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), Double.valueOf(v));
            return this;
        }

        public MetricsRecordBuilder addGauge(MetricsInfo metricsInfo, double v) {
            MetricsAssertHelperImpl.this.gauges.put(MetricsAssertHelperImpl.this.canonicalizeMetricName(metricsInfo.name()), v);
            return this;
        }

        public MetricsCollector parent() {
            return this.mockMetricsBuilder;
        }
    }

    public class MockMetricsBuilder
    implements MetricsCollector {
        public MetricsRecordBuilder addRecord(String s) {
            return new MockRecordBuilder(this);
        }

        public MetricsRecordBuilder addRecord(MetricsInfo metricsInfo) {
            return new MockRecordBuilder(this);
        }
    }
}

