/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.annotation.NoReconnect;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RetryingMetaStoreClient
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)RetryingMetaStoreClient.class.getName());
    private final IMetaStoreClient base;
    private final int retryLimit;
    private final long retryDelaySeconds;
    private final ConcurrentHashMap<String, Long> metaCallTimeMap;
    private final long connectionLifeTimeInMillis;
    private long lastConnectionTime;
    private boolean localMetaStore;

    protected RetryingMetaStoreClient(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, ConcurrentHashMap<String, Long> metaCallTimeMap, Class<? extends IMetaStoreClient> msClientClass) throws MetaException {
        this.retryLimit = hiveConf.getIntVar(HiveConf.ConfVars.METASTORETHRIFTFAILURERETRIES);
        this.retryDelaySeconds = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
        this.metaCallTimeMap = metaCallTimeMap;
        this.connectionLifeTimeInMillis = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_LIFETIME, TimeUnit.MILLISECONDS);
        this.lastConnectionTime = System.currentTimeMillis();
        String msUri = hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
        this.localMetaStore = msUri == null || msUri.trim().isEmpty();
        this.reloginExpiringKeytabUser();
        this.base = MetaStoreUtils.newInstance(msClientClass, constructorArgTypes, constructorArgs);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, boolean allowEmbedded) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, new Class[]{HiveConf.class, Boolean.class}, new Object[]{hiveConf, allowEmbedded}, null, HiveMetaStoreClient.class.getName());
    }

    @VisibleForTesting
    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, hookLoader, null, mscClassName, true);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, HiveMetaHookLoader hookLoader, ConcurrentHashMap<String, Long> metaCallTimeMap, String mscClassName, boolean allowEmbedded) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, new Class[]{HiveConf.class, HiveMetaHookLoader.class, Boolean.class}, new Object[]{hiveConf, hookLoader, allowEmbedded}, metaCallTimeMap, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, String mscClassName) throws MetaException {
        return RetryingMetaStoreClient.getProxy(hiveConf, constructorArgTypes, constructorArgs, null, mscClassName);
    }

    public static IMetaStoreClient getProxy(HiveConf hiveConf, Class<?>[] constructorArgTypes, Object[] constructorArgs, ConcurrentHashMap<String, Long> metaCallTimeMap, String mscClassName) throws MetaException {
        Class<? extends RawStore> baseClass = MetaStoreUtils.getClass(mscClassName);
        RetryingMetaStoreClient handler = new RetryingMetaStoreClient(hiveConf, constructorArgTypes, constructorArgs, metaCallTimeMap, baseClass);
        return (IMetaStoreClient)Proxy.newProxyInstance(RetryingMetaStoreClient.class.getClassLoader(), baseClass.getInterfaces(), (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        int retriesMade = 0;
        Object caughtException = null;
        boolean allowReconnect = !method.isAnnotationPresent(NoReconnect.class);
        boolean allowRetry = true;
        Annotation[] directives = method.getDeclaredAnnotations();
        if (directives != null) {
            for (Annotation a : directives) {
                if (!(a instanceof RetrySemantics.CannotRetry)) continue;
                allowRetry = false;
            }
        }
        while (true) {
            try {
                this.reloginExpiringKeytabUser();
                if (allowReconnect && (retriesMade > 0 || this.hasConnectionLifeTimeReached(method))) {
                    this.base.reconnect();
                    this.lastConnectionTime = System.currentTimeMillis();
                }
                if (this.metaCallTimeMap == null) {
                    ret = method.invoke((Object)this.base, args);
                    break;
                }
                long startTime = System.currentTimeMillis();
                ret = method.invoke((Object)this.base, args);
                long timeTaken = System.currentTimeMillis() - startTime;
                this.addMethodTime(method, timeTaken);
                break;
            }
            catch (UndeclaredThrowableException e) {
                throw e.getCause();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                if (t instanceof TApplicationException) {
                    TApplicationException tae = (TApplicationException)t;
                    switch (tae.getType()) {
                        case 1: 
                        case 3: 
                        case 9: 
                        case 10: {
                            throw t;
                        }
                    }
                    caughtException = tae;
                }
                if (t instanceof TProtocolException || t instanceof TTransportException) {
                    caughtException = (TException)t;
                }
                if (t instanceof MetaException && t.getMessage().matches("(?s).*(JDO[a-zA-Z]*|TProtocol|TTransport)Exception.*") && !t.getMessage().contains("java.sql.SQLIntegrityConstraintViolationException")) {
                    caughtException = (MetaException)((Object)t);
                }
                throw t;
            }
            catch (MetaException e) {
                if (e.getMessage().matches("(?s).*(IO|TTransport)Exception.*") && !e.getMessage().contains("java.sql.SQLIntegrityConstraintViolationException")) {
                    caughtException = e;
                }
                throw e;
            }
            if (retriesMade >= this.retryLimit || this.base.isLocalMetaStore() || !allowRetry) {
                throw caughtException;
            }
            LOG.warn("MetaStoreClient lost connection. Attempting to reconnect (" + ++retriesMade + " of " + this.retryLimit + ") after " + this.retryDelaySeconds + "s. " + method.getName(), (Throwable)caughtException);
            Thread.sleep(this.retryDelaySeconds * 1000L);
        }
        return ret;
    }

    private void addMethodTime(Method method, long timeTaken) {
        Long newTime;
        Long curTime;
        String methodStr = this.getMethodString(method);
        do {
            curTime = this.metaCallTimeMap.get(methodStr);
            newTime = timeTaken;
        } while ((curTime == null || !this.metaCallTimeMap.replace(methodStr, curTime, newTime + curTime)) && (curTime != null || null != this.metaCallTimeMap.putIfAbsent(methodStr, newTime)));
    }

    private String getMethodString(Method method) {
        StringBuilder methodSb = new StringBuilder(method.getName());
        methodSb.append("_(");
        for (Class<?> paramClass : method.getParameterTypes()) {
            methodSb.append(paramClass.getSimpleName());
            methodSb.append(", ");
        }
        methodSb.append(")");
        return methodSb.toString();
    }

    private boolean hasConnectionLifeTimeReached(Method method) {
        boolean shouldReconnect;
        if (this.connectionLifeTimeInMillis <= 0L || this.localMetaStore) {
            return false;
        }
        boolean bl = shouldReconnect = System.currentTimeMillis() - this.lastConnectionTime >= this.connectionLifeTimeInMillis;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconnection status for Method: " + method.getName() + " is " + shouldReconnect);
        }
        return shouldReconnect;
    }

    private void reloginExpiringKeytabUser() throws MetaException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            if (ugi.isFromKeytab()) {
                ugi.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            String msg = "Error doing relogin using keytab " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new MetaException(msg);
        }
    }
}

