/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieIndexCommitMetadata;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.callback.HoodieWriteCommitCallback;
import org.apache.hudi.callback.common.HoodieWriteCommitCallbackMessage;
import org.apache.hudi.callback.util.HoodieCommitCallbackFactory;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.RunsTableService;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieRestoreException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.action.InternalSchemaChangeApplier;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.restore.RestoreUtils;
import org.apache.hudi.table.action.savepoint.SavepointHelpers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseHoodieWriteClient<T, I, K, O>
extends BaseHoodieClient
implements RunsTableService {
    protected static final String LOOKUP_STR = "lookup";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(BaseHoodieWriteClient.class);
    private final transient HoodieIndex<?, ?> index;
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private transient WriteOperationType operationType;
    private transient HoodieWriteCommitCallback commitCallback;
    protected transient Timer.Context writeTimer = null;
    protected Option<Pair<HoodieInstant, Map<String, String>>> lastCompletedTxnAndMetadata = Option.empty();
    protected Set<String> pendingInflightAndRequestedInstants;
    protected BaseHoodieTableServiceClient<O> tableServiceClient;

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this(context, writeConfig, Option.empty(), upgradeDowngradeHelper);
    }

    @Deprecated
    public BaseHoodieWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        super(context, writeConfig, timelineService);
        this.index = this.createIndex(writeConfig);
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    protected abstract HoodieIndex<?, ?> createIndex(HoodieWriteConfig var1);

    public void setOperationType(WriteOperationType operationType) {
        this.operationType = operationType;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public BaseHoodieTableServiceClient<O> getTableServiceClient() {
        return this.tableServiceClient;
    }

    public boolean commit(String instantTime, O writeStatuses) {
        return this.commit(instantTime, writeStatuses, Option.empty());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata) {
        HoodieTableMetaClient metaClient = this.createMetaClient(false);
        String actionType = metaClient.getCommitActionType();
        return this.commit(instantTime, writeStatuses, extraMetadata, actionType, Collections.emptyMap());
    }

    public boolean commit(String instantTime, O writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        return this.commit(instantTime, writeStatuses, extraMetadata, commitActionType, partitionToReplacedFileIds, Option.empty());
    }

    public abstract boolean commit(String var1, O var2, Option<Map<String, String>> var3, String var4, Map<String, List<String>> var5, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> var6);

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType) {
        return this.commitStats(instantTime, stats, extraMetadata, commitActionType, Collections.emptyMap(), Option.empty());
    }

    public boolean commitStats(String instantTime, List<HoodieWriteStat> stats, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplaceFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        if (!this.config.allowEmptyCommit() && stats.isEmpty()) {
            return true;
        }
        LOG.info((Object)("Committing " + instantTime + " action " + commitActionType));
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        HoodieCommitMetadata metadata = CommitUtils.buildMetadata(stats, partitionToReplaceFileIds, extraMetadata, this.operationType, this.config.getWriteSchema(), commitActionType);
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, table.getMetaClient().getCommitActionType(), instantTime);
        HeartbeatUtils.abortIfHeartbeatExpired(instantTime, table, this.heartbeatClient, this.config);
        this.txnManager.beginTransaction(Option.of(inflightInstant), this.lastCompletedTxnAndMetadata.isPresent() ? Option.of(this.lastCompletedTxnAndMetadata.get().getLeft()) : Option.empty());
        try {
            this.preCommit(inflightInstant, metadata);
            if (extraPreCommitFunc.isPresent()) {
                extraPreCommitFunc.get().accept(table.getMetaClient(), metadata);
            }
            this.commit(table, commitActionType, instantTime, metadata, stats);
            this.postCommit(table, metadata, instantTime, extraMetadata);
            LOG.info((Object)("Committed " + instantTime));
            this.releaseResources();
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to complete commit " + this.config.getBasePath() + " at time " + instantTime, e);
        }
        finally {
            this.txnManager.endTransaction(Option.of(inflightInstant));
        }
        this.mayBeCleanAndArchive(table);
        try {
            this.runTableServicesInline(table, metadata, extraMetadata);
        }
        catch (Exception e) {
            if (this.config.isFailOnInlineTableServiceExceptionEnabled()) {
                throw e;
            }
            LOG.warn((Object)("Inline compaction or clustering failed with exception: " + e.getMessage() + ". Moving further since \"hoodie.fail.writes.on.inline.table.service.exception\" is set to false."));
        }
        this.emitCommitMetrics(instantTime, metadata, commitActionType);
        if (this.config.writeCommitCallbackOn()) {
            if (null == this.commitCallback) {
                this.commitCallback = HoodieCommitCallbackFactory.create(this.config);
            }
            this.commitCallback.call(new HoodieWriteCommitCallbackMessage(instantTime, this.config.getTableName(), this.config.getBasePath(), stats));
        }
        return true;
    }

    protected void commit(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata metadata, List<HoodieWriteStat> stats) throws IOException {
        LOG.info((Object)("Committing " + instantTime + " action " + commitActionType));
        HoodieActiveTimeline activeTimeline = table.getActiveTimeline();
        this.finalizeWrite(table, instantTime, stats);
        if (!metadata.getExtraMetadata().containsKey("latest_schema") && metadata.getExtraMetadata().containsKey("schema") && table.getConfig().getSchemaEvolutionEnable()) {
            this.saveInternalSchema(table, instantTime, metadata);
        }
        this.writeTableMetadata(table, instantTime, commitActionType, metadata);
        activeTimeline.saveAsComplete(new HoodieInstant(true, commitActionType, instantTime), Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
    }

    private void saveInternalSchema(HoodieTable table, String instantTime, HoodieCommitMetadata metadata) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(table.getMetaClient());
        String historySchemaStr = schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElse("");
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(table.getMetaClient());
        if (!historySchemaStr.isEmpty() || Boolean.parseBoolean(this.config.getString(HoodieCommonConfig.RECONCILE_SCHEMA.key()))) {
            InternalSchema internalSchema;
            Schema avroSchema = HoodieAvroUtils.createHoodieWriteSchema(this.config.getSchema(), this.config.allowOperationMetadataField());
            if (historySchemaStr.isEmpty()) {
                internalSchema = SerDeHelper.fromJson(this.config.getInternalSchema()).orElse(AvroInternalSchemaConverter.convert(avroSchema));
                internalSchema.setSchemaId(Long.parseLong(instantTime));
            } else {
                internalSchema = InternalSchemaUtils.searchSchema(Long.parseLong(instantTime), SerDeHelper.parseSchemas(historySchemaStr));
            }
            InternalSchema evolvedSchema = AvroSchemaEvolutionUtils.reconcileSchema(avroSchema, internalSchema);
            if (evolvedSchema.equals(internalSchema)) {
                metadata.addMetadata("latest_schema", SerDeHelper.toJson(evolvedSchema));
                schemasManager.persistHistorySchemaStr(instantTime, historySchemaStr.isEmpty() ? SerDeHelper.inheritSchemas(evolvedSchema, "") : historySchemaStr);
            } else {
                evolvedSchema.setSchemaId(Long.parseLong(instantTime));
                String newSchemaStr = SerDeHelper.toJson(evolvedSchema);
                metadata.addMetadata("latest_schema", newSchemaStr);
                schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(evolvedSchema, historySchemaStr));
            }
            metadata.addMetadata("schema", AvroInternalSchemaConverter.convert(evolvedSchema, avroSchema.getFullName()).toString());
        }
    }

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, Configuration var2);

    protected abstract HoodieTable<T, I, K, O> createTable(HoodieWriteConfig var1, Configuration var2, HoodieTableMetaClient var3);

    void emitCommitMetrics(String instantTime, HoodieCommitMetadata metadata, String actionType) {
        if (this.writeTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.writeTimer.stop());
            HoodieActiveTimeline.parseDateFromInstantTimeSafely(instantTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, actionType));
            this.writeTimer = null;
        }
    }

    protected void preCommit(HoodieInstant inflightInstant, HoodieCommitMetadata metadata) {
    }

    protected void writeTableMetadata(HoodieTable table, String instantTime, String actionType, HoodieCommitMetadata metadata) {
        if (table.isTableServiceAction(actionType, instantTime)) {
            this.tableServiceClient.writeTableMetadata(table, instantTime, actionType, metadata);
        } else {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Committing to metadata table: " + this.config.getTableName());
            table.getMetadataWriter(instantTime).ifPresent(w -> ((HoodieTableMetadataWriter)w).update(metadata, instantTime, false));
        }
    }

    public abstract I filterExists(I var1);

    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        if (this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl()) {
            throw new HoodieException("Cannot bootstrap the table in multi-writer mode");
        }
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable("00000000000001"));
        this.tableServiceClient.rollbackFailedBootstrap();
        table.bootstrap(this.context, extraMetadata);
    }

    public abstract O upsert(I var1, String var2);

    public abstract O upsertPreppedRecords(I var1, String var2);

    public abstract O insert(I var1, String var2);

    public abstract O insertPreppedRecords(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2);

    public abstract O bulkInsert(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O bulkInsertPreppedRecords(I var1, String var2, Option<BulkInsertPartitioner> var3);

    public abstract O delete(K var1, String var2);

    public void preWrite(String instantTime, WriteOperationType writeOperationType, HoodieTableMetaClient metaClient) {
        this.setOperationType(writeOperationType);
        this.lastCompletedTxnAndMetadata = this.txnManager.isOptimisticConcurrencyControlEnabled() ? TransactionUtils.getLastCompletedTxnInstantAndMetadata(metaClient) : Option.empty();
        this.pendingInflightAndRequestedInstants = TransactionUtils.getInflightAndRequestedInstants(metaClient);
        this.pendingInflightAndRequestedInstants.remove(instantTime);
        this.tableServiceClient.setPendingInflightAndRequestedInstants(this.pendingInflightAndRequestedInstants);
        this.tableServiceClient.startAsyncCleanerService(this);
        this.tableServiceClient.startAsyncArchiveService(this);
    }

    protected abstract O postWrite(HoodieWriteMetadata<O> var1, String var2, HoodieTable var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postCommit(HoodieTable table, HoodieCommitMetadata metadata, String instantTime, Option<Map<String, String>> extraMetadata) {
        try {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Cleaning up marker directories for commit " + instantTime + " in table " + this.config.getTableName());
            WriteMarkersFactory.get(this.config.getMarkersType(), table, instantTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        }
        finally {
            this.heartbeatClient.stop(instantTime);
        }
    }

    protected void mayBeCleanAndArchive(HoodieTable table) {
        this.autoCleanOnCommit();
        this.autoArchiveOnCommit(table);
    }

    protected void runTableServicesInline(HoodieTable table, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        this.tableServiceClient.runTableServicesInline(table, metadata, extraMetadata);
    }

    protected void autoCleanOnCommit() {
        if (!this.config.isAutoClean()) {
            return;
        }
        if (this.config.isAsyncClean()) {
            LOG.info((Object)"Async cleaner has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncClean();
            LOG.info((Object)"Async cleaner has finished");
        } else {
            LOG.info((Object)"Start to clean synchronously.");
            this.clean();
        }
    }

    protected void autoArchiveOnCommit(HoodieTable table) {
        if (!this.config.isAutoArchive()) {
            return;
        }
        if (this.config.isAsyncArchive()) {
            LOG.info((Object)"Async archiver has been spawned. Waiting for it to finish");
            this.tableServiceClient.asyncArchive();
            LOG.info((Object)"Async archiver has finished");
        } else {
            LOG.info((Object)"Start to archive synchronously.");
            this.archive(table);
        }
    }

    public void runAnyPendingCompactions() {
        this.tableServiceClient.runAnyPendingCompactions(this.createTable(this.config, this.hadoopConf));
    }

    public void savepoint(String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        if (table.getCompletedCommitsTimeline().empty()) {
            throw new HoodieSavepointException("Could not savepoint. Commit timeline is empty");
        }
        String latestCommit = table.getCompletedCommitsTimeline().lastInstant().get().getTimestamp();
        LOG.info((Object)("Savepointing latest commit " + latestCommit));
        this.savepoint(latestCommit, user, comment);
    }

    public void savepoint(String instantTime, String user, String comment) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        table.savepoint(this.context, instantTime, user, comment);
    }

    public void deleteSavepoint(String savepointTime) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        SavepointHelpers.deleteSavepoint(table, savepointTime);
    }

    public void restoreToSavepoint(String savepointTime) {
        boolean initialMetadataTableIfNecessary = this.config.isMetadataTableEnabled();
        if (initialMetadataTableIfNecessary) {
            try {
                String metadataTableBasePathStr = HoodieTableMetadata.getMetadataTableBasePath(this.config.getBasePath());
                HoodieTableMetaClient mdtClient = HoodieTableMetaClient.builder().setConf(this.hadoopConf).setBasePath(metadataTableBasePathStr).build();
                HoodieInstant syncedInstant = new HoodieInstant(false, "deltacommit", savepointTime);
                if (mdtClient.getCommitsTimeline().isBeforeTimelineStarts(syncedInstant.getTimestamp())) {
                    mdtClient.getFs().delete(new Path(metadataTableBasePathStr), true);
                    initialMetadataTableIfNecessary = false;
                }
            }
            catch (Exception metadataTableBasePathStr) {
                // empty catch block
            }
        }
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty(), initialMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointPresence(table, savepointTime);
        ValidationUtils.checkArgument(!this.config.shouldArchiveBeyondSavepoint(), "Restore is not supported when " + HoodieArchivalConfig.ARCHIVE_BEYOND_SAVEPOINT.key() + " is enabled");
        this.restoreToInstant(savepointTime, initialMetadataTableIfNecessary);
        SavepointHelpers.validateSavepointRestore(table, savepointTime);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime) throws HoodieRollbackException {
        HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty());
        Option<HoodiePendingRollbackInfo> pendingRollbackInfo = this.tableServiceClient.getPendingRollbackInfo(table.getMetaClient(), commitInstantTime);
        return this.tableServiceClient.rollback(commitInstantTime, pendingRollbackInfo, false);
    }

    public HoodieRestoreMetadata restoreToInstant(String savepointToRestoreTimestamp, boolean initialMetadataTableIfNecessary) throws HoodieRestoreException {
        LOG.info((Object)("Begin restore to instant " + savepointToRestoreTimestamp));
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable table = this.initTable(WriteOperationType.UNKNOWN, Option.empty(), initialMetadataTableIfNecessary);
            Pair<String, Option<HoodieRestorePlan>> timestampAndRestorePlan = this.scheduleAndGetRestorePlan(savepointToRestoreTimestamp, table);
            String restoreInstantTimestamp = timestampAndRestorePlan.getLeft();
            Option<HoodieRestorePlan> restorePlanOption = timestampAndRestorePlan.getRight();
            if (restorePlanOption.isPresent()) {
                HoodieRestoreMetadata restoreMetadata = table.restore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp);
                if (timerContext != null) {
                    long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                    long totalFilesDeleted = restoreMetadata.getHoodieRestoreMetadata().values().stream().flatMap(Collection::stream).mapToLong(HoodieRollbackMetadata::getTotalFilesDeleted).sum();
                    this.metrics.updateRollbackMetrics(durationInMs, totalFilesDeleted);
                }
                return restoreMetadata;
            }
            throw new HoodieRestoreException("Failed to restore " + this.config.getBasePath() + " to commit " + savepointToRestoreTimestamp);
        }
        catch (Exception e) {
            throw new HoodieRestoreException("Failed to restore to " + savepointToRestoreTimestamp, e);
        }
    }

    private Pair<String, Option<HoodieRestorePlan>> scheduleAndGetRestorePlan(String savepointToRestoreTimestamp, HoodieTable<T, I, K, O> table) throws IOException {
        Option<HoodieInstant> failedRestore = table.getRestoreTimeline().filterInflightsAndRequested().lastInstant();
        if (failedRestore.isPresent() && savepointToRestoreTimestamp.equals(RestoreUtils.getSavepointToRestoreTimestamp(table, failedRestore.get()))) {
            return Pair.of(failedRestore.get().getTimestamp(), Option.of(RestoreUtils.getRestorePlan(table.getMetaClient(), failedRestore.get())));
        }
        String restoreInstantTimestamp = HoodieActiveTimeline.createNewInstantTime();
        return Pair.of(restoreInstantTimestamp, table.scheduleRestore(this.context, restoreInstantTimestamp, savepointToRestoreTimestamp));
    }

    public HoodieCleanMetadata clean(String cleanInstantTime) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    @Deprecated
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, true, false);
    }

    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        return this.tableServiceClient.clean(cleanInstantTime, scheduleInline);
    }

    public HoodieCleanMetadata clean() {
        return this.clean(HoodieActiveTimeline.createNewInstantTime());
    }

    @Deprecated
    public HoodieCleanMetadata clean(boolean skipLocking) {
        return this.clean(HoodieActiveTimeline.createNewInstantTime());
    }

    protected void archive(HoodieTable table) {
        this.tableServiceClient.archive(table);
    }

    public void archive() {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        this.archive(table);
    }

    public String startCommit() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        return this.startCommit(metaClient.getCommitActionType(), metaClient);
    }

    public String startCommit(String actionType, HoodieTableMetaClient metaClient) {
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.tableServiceClient.rollbackFailedWrites());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        this.startCommit(instantTime, actionType, metaClient);
        return instantTime;
    }

    public void startCommitWithTime(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, metaClient.getCommitActionType(), metaClient);
    }

    public void startCommitWithTime(String instantTime, String actionType) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        this.startCommitWithTime(instantTime, actionType, metaClient);
    }

    private void startCommitWithTime(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "commit", () -> this.tableServiceClient.rollbackFailedWrites());
        this.startCommit(instantTime, actionType, metaClient);
    }

    private void startCommit(String instantTime, String actionType, HoodieTableMetaClient metaClient) {
        LOG.info((Object)("Generate a new instant time: " + instantTime + " action: " + actionType));
        metaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant().ifPresent(latestPending -> ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(latestPending.getTimestamp(), HoodieTimeline.LESSER_THAN, instantTime), "Latest pending compaction instant time must be earlier than this instant time. Latest Compaction :" + latestPending + ",  Ingesting at " + instantTime));
        if (this.config.getFailedWritesCleanPolicy().isLazy()) {
            this.heartbeatClient.start(instantTime);
        }
        if (actionType.equals("replacecommit")) {
            metaClient.getActiveTimeline().createRequestedReplaceCommit(instantTime, actionType);
        } else {
            metaClient.getActiveTimeline().createNewInstant(new HoodieInstant(HoodieInstant.State.REQUESTED, actionType, instantTime));
        }
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public Option<String> scheduleIndexing(List<MetadataPartitionType> partitionTypes) {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        Option<HoodieIndexPlan> indexPlan = this.createTable(this.config, this.hadoopConf).scheduleIndexing(this.context, instantTime, partitionTypes);
        return indexPlan.isPresent() ? Option.of(instantTime) : Option.empty();
    }

    public Option<HoodieIndexCommitMetadata> index(String indexInstantTime) {
        return this.createTable(this.config, this.hadoopConf).index(this.context, indexInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(List<MetadataPartitionType> partitionTypes) {
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf);
        String dropInstant = HoodieActiveTimeline.createNewInstantTime();
        HoodieInstant ownerInstant = new HoodieInstant(true, "indexing", dropInstant);
        this.txnManager.beginTransaction(Option.of(ownerInstant), Option.empty());
        try {
            this.context.setJobStatus(this.getClass().getSimpleName(), "Dropping partitions from metadata table: " + this.config.getTableName());
            table.getMetadataWriter(dropInstant).ifPresent(w -> {
                try {
                    ((HoodieTableMetadataWriter)w).dropMetadataPartitions(partitionTypes);
                }
                catch (IOException e) {
                    throw new HoodieIndexException("Failed to drop metadata index. ", e);
                }
            });
        }
        finally {
            this.txnManager.endTransaction(Option.of(ownerInstant));
        }
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.replacecommit)) {
            throw new UnsupportedOperationException("Clustering should be delegated to table service manager instead of direct run.");
        }
        return this.cluster(clusteringInstantTime, true);
    }

    public HoodieWriteMetadata<O> compact(String compactionInstantTime) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.compaction)) {
            throw new UnsupportedOperationException("Compaction should be delegated to table service manager instead of direct run.");
        }
        return this.compact(compactionInstantTime, this.config.shouldAutoCommit());
    }

    public abstract void commitCompaction(String var1, HoodieCommitMetadata var2, Option<Map<String, String>> var3);

    protected abstract void completeCompaction(HoodieCommitMetadata var1, HoodieTable var2, String var3);

    public Option<String> scheduleLogCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleLogCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleLogCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.LOG_COMPACT).isPresent();
    }

    public HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime) {
        return this.logCompact(logCompactionInstantTime, this.config.shouldAutoCommit());
    }

    public void commitLogCompaction(String logCompactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        throw new UnsupportedOperationException("Log compaction is not supported yet.");
    }

    protected void completeLogCompaction(HoodieCommitMetadata metadata, HoodieTable<T, I, K, O> table, String logCompactionCommitTime) {
        throw new UnsupportedOperationException("Log compaction is not supported yet.");
    }

    protected abstract HoodieWriteMetadata<O> compact(String var1, boolean var2);

    protected Option<String> inlineScheduleCompaction(Option<Map<String, String>> extraMetadata) {
        return this.scheduleCompaction(extraMetadata);
    }

    protected HoodieWriteMetadata<O> logCompact(String compactionInstantTime, boolean shouldComplete) {
        throw new UnsupportedOperationException("Log compaction is not supported yet.");
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    protected boolean scheduleCleaningAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLEAN).isPresent();
    }

    public abstract HoodieWriteMetadata<O> cluster(String var1, boolean var2);

    public Option<String> scheduleTableService(Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleTableService(instantTime, extraMetadata, tableServiceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        Option<HoodieInstant> inflightInstant = Option.of(new HoodieInstant(HoodieInstant.State.REQUESTED, tableServiceType.getAction(), instantTime));
        try {
            this.txnManager.beginTransaction(inflightInstant, Option.empty());
            LOG.info((Object)("Scheduling table service " + (Object)((Object)tableServiceType)));
            Option<String> option = this.tableServiceClient.scheduleTableServiceInternal(instantTime, extraMetadata, tableServiceType);
            return option;
        }
        finally {
            this.txnManager.endTransaction(inflightInstant);
        }
    }

    public HoodieMetrics getMetrics() {
        return this.metrics;
    }

    public HoodieIndex<?, ?> getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitTable(HoodieTableMetaClient metaClient, Option<String> instantTime, boolean initialMetadataTableIfNecessary) {
        Option<HoodieInstant> ownerInstant = Option.empty();
        if (instantTime.isPresent()) {
            ownerInstant = Option.of(new HoodieInstant(true, CommitUtils.getCommitActionType(this.operationType, metaClient.getTableType()), instantTime.get()));
        }
        this.txnManager.beginTransaction(ownerInstant, Option.empty());
        try {
            this.tryUpgrade(metaClient, instantTime);
            if (initialMetadataTableIfNecessary) {
                this.initMetadataTable(instantTime);
            }
        }
        finally {
            this.txnManager.endTransaction(ownerInstant);
        }
    }

    protected void initMetadataTable(Option<String> instantTime) {
    }

    protected final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime, boolean initialMetadataTableIfNecessary) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        if (operationType == WriteOperationType.DELETE) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.doInitTable(metaClient, instantTime, initialMetadataTableIfNecessary);
        HoodieTable<T, I, K, O> table = this.createTable(this.config, this.hadoopConf, metaClient);
        metaClient.validateTableProperties(this.config.getProps());
        switch (operationType) {
            case INSERT: 
            case INSERT_PREPPED: 
            case UPSERT: 
            case UPSERT_PREPPED: 
            case BULK_INSERT: 
            case BULK_INSERT_PREPPED: 
            case INSERT_OVERWRITE: 
            case INSERT_OVERWRITE_TABLE: {
                this.setWriteTimer(table);
                break;
            }
            case CLUSTER: 
            case COMPACT: 
            case LOG_COMPACT: {
                this.tableServiceClient.setTableServiceTimer(operationType);
                break;
            }
        }
        return table;
    }

    protected final HoodieTable initTable(WriteOperationType operationType, Option<String> instantTime) {
        return this.initTable(operationType, instantTime, this.config.isMetadataTableEnabled());
    }

    protected void setWriteSchemaForDeletes(HoodieTableMetaClient metaClient) {
        try {
            HoodieCommitMetadata commitMetadata;
            HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
            Option<HoodieInstant> lastInstant = activeTimeline.filterCompletedInstants().filter(s -> s.getAction().equals(metaClient.getCommitActionType()) || s.getAction().equals("replacecommit")).lastInstant();
            if (lastInstant.isPresent()) {
                commitMetadata = HoodieCommitMetadata.fromBytes(activeTimeline.getInstantDetails(lastInstant.get()).get(), HoodieCommitMetadata.class);
                String extraSchema = commitMetadata.getExtraMetadata().get("schema");
                if (StringUtils.isNullOrEmpty(extraSchema)) {
                    throw new HoodieIOException("Latest commit does not have any schema in commit metadata");
                }
            } else {
                throw new HoodieIOException("Deletes issued without any prior commits");
            }
            this.config.setSchema(commitMetadata.getExtraMetadata().get("schema"));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException thrown while reading last commit metadata", e);
        }
    }

    protected void releaseResources() {
    }

    @Override
    public void close() {
        super.close();
        this.index.close();
        this.tableServiceClient.close();
    }

    private void setWriteTimer(HoodieTable table) {
        String commitType = table.getMetaClient().getCommitActionType();
        if (commitType.equals("commit")) {
            this.writeTimer = this.metrics.getCommitCtx();
        } else if (commitType.equals("deltacommit")) {
            this.writeTimer = this.metrics.getDeltaCommitCtx();
        }
    }

    protected void tryUpgrade(HoodieTableMetaClient metaClient, Option<String> instantTime) {
        UpgradeDowngrade upgradeDowngrade = new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper);
        if (upgradeDowngrade.needsUpgradeOrDowngrade(HoodieTableVersion.current())) {
            List<String> instantsToRollback = this.tableServiceClient.getInstantsToRollback(metaClient = HoodieTableMetaClient.reload(metaClient), HoodieFailedWritesCleaningPolicy.EAGER, instantTime);
            if (!instantsToRollback.isEmpty()) {
                Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.tableServiceClient.getPendingRollbackInfos(metaClient);
                instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
                this.tableServiceClient.rollbackFailedWrites(pendingRollbacks, true);
            }
            new UpgradeDowngrade(metaClient, this.config, this.context, this.upgradeDowngradeHelper).run(HoodieTableVersion.current(), instantTime.orElse(null));
            metaClient.reloadActiveTimeline();
        }
    }

    public boolean lazyRollbackFailedIndexing() {
        return this.tableServiceClient.rollbackFailedIndexingCommits();
    }

    public boolean rollbackFailedWrites() {
        return this.tableServiceClient.rollbackFailedWrites();
    }

    public void addColumn(String colName, Schema schema, String doc, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyAddChange(colName, AvroInternalSchemaConverter.convertToField(schema), doc, position, positionType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void addColumn(String colName, Schema schema) {
        this.addColumn(colName, schema, null, "", TableChange.ColumnPositionChange.ColumnPositionType.NO_OPERATION);
    }

    public void deleteColumns(String ... colNames) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyDeleteChange(colNames);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void renameColumn(String colName, String newName) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyRenameChange(colName, newName);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnNullability(String colName, boolean nullable) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnNullabilityChange(colName, nullable);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnType(String colName, Type newType) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnTypeChange(colName, newType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void updateColumnComment(String colName, String doc) {
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyColumnCommentChange(colName, doc);
        this.commitTableChange(newSchema, pair.getRight());
    }

    public void reOrderColPosition(String colName, String referColName, TableChange.ColumnPositionChange.ColumnPositionType orderType) {
        if (colName == null || orderType == null || referColName == null) {
            return;
        }
        Pair<InternalSchema, HoodieTableMetaClient> pair = this.getInternalSchemaAndMetaClient();
        InternalSchema newSchema = new InternalSchemaChangeApplier(pair.getLeft()).applyReOrderColPositionChange(colName, referColName, orderType);
        this.commitTableChange(newSchema, pair.getRight());
    }

    private Pair<InternalSchema, HoodieTableMetaClient> getInternalSchemaAndMetaClient() {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        return Pair.of(this.getInternalSchema(schemaUtil), metaClient);
    }

    private void commitTableChange(InternalSchema newSchema, HoodieTableMetaClient metaClient) {
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String historySchemaStr = schemaUtil.getTableHistorySchemaStrFromCommitMetadata().orElseGet(() -> SerDeHelper.inheritSchemas(this.getInternalSchema(schemaUtil), ""));
        Schema schema = AvroInternalSchemaConverter.convert(newSchema, AvroSchemaUtils.getAvroRecordQualifiedName(this.config.getTableName()));
        String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.ALTER_SCHEMA, metaClient.getTableType());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        this.startCommitWithTime(instantTime, commitActionType, metaClient);
        this.config.setSchema(schema.toString());
        HoodieActiveTimeline timeLine = metaClient.getActiveTimeline();
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        try {
            timeLine.transitionRequestedToInflight(requested, Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException io) {
            throw new HoodieCommitException("Failed to commit " + instantTime + " unable to save inflight metadata ", io);
        }
        HashMap<String, String> extraMeta = new HashMap<String, String>();
        extraMeta.put("latest_schema", SerDeHelper.toJson(newSchema.setSchemaId(Long.parseLong(instantTime))));
        FileBasedInternalSchemaStorageManager schemasManager = new FileBasedInternalSchemaStorageManager(metaClient);
        schemasManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(newSchema, historySchemaStr));
        this.commitStats(instantTime, Collections.emptyList(), Option.of(extraMeta), commitActionType);
    }

    private InternalSchema getInternalSchema(TableSchemaResolver schemaUtil) {
        return schemaUtil.getTableInternalSchemaFromCommitMetadata().orElseGet(() -> {
            try {
                return AvroInternalSchemaConverter.convert(schemaUtil.getTableAvroSchema());
            }
            catch (Exception e) {
                throw new HoodieException(String.format("cannot find schema for current table: %s", this.config.getBasePath()));
            }
        });
    }
}

