/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.HashMap;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.io.storage.row.parquet.ParquetRowDataWriter;
import org.apache.hudi.io.storage.row.parquet.ParquetSchemaConverter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;

public class RowDataParquetWriteSupport
extends WriteSupport<RowData> {
    private final RowType rowType;
    private final MessageType schema;
    private ParquetRowDataWriter writer;

    public RowDataParquetWriteSupport(RowType rowType) {
        this.rowType = rowType;
        this.schema = ParquetSchemaConverter.convertToParquetMessageType("flink_schema", rowType);
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.writer = new ParquetRowDataWriter(recordConsumer, this.rowType, this.schema, true);
    }

    @Override
    public void write(RowData record) {
        try {
            this.writer.write(record);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

