/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.cleaner;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class BaseTimeToLiveFileCleaner
extends BaseLogCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger((String)BaseTimeToLiveFileCleaner.class.getName());
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.systemDefault());
    private long ttlMs;
    private volatile boolean stopped = false;

    @Override
    public final void setConf(Configuration conf) {
        super.setConf(conf);
        this.ttlMs = this.getTtlMs(conf);
    }

    @Override
    public boolean isFileDeletable(FileStatus status) {
        if (!this.valiateFilename(status.getPath())) {
            return true;
        }
        long currentTime = EnvironmentEdgeManager.currentTime();
        long time = status.getModificationTime();
        long life = currentTime - time;
        if (LOG.isTraceEnabled()) {
            LOG.trace("File life:{}ms, ttl:{}ms, current:{}, from{}", new Object[]{life, this.ttlMs, FORMATTER.format(Instant.ofEpochMilli(currentTime)), FORMATTER.format(Instant.ofEpochMilli(time))});
        }
        if (life < 0L) {
            LOG.warn("Found a file ({}) newer than current time ({} < {}), probably a clock skew", new Object[]{status.getPath(), FORMATTER.format(Instant.ofEpochMilli(currentTime)), FORMATTER.format(Instant.ofEpochMilli(time))});
            return false;
        }
        return life > this.ttlMs;
    }

    @Override
    public void stop(String why) {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    protected abstract long getTtlMs(Configuration var1);

    protected abstract boolean valiateFilename(Path var1);
}

