/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.OptionGroup;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class HFileProcedurePrettyPrinter
extends AbstractHBaseTool {
    private Long procId;
    private List<Path> files = new ArrayList<Path>();
    private final PrintStream out;

    public HFileProcedurePrettyPrinter() {
        this(System.out);
    }

    public HFileProcedurePrettyPrinter(PrintStream out) {
        this.out = out;
    }

    @Override
    protected void addOptions() {
        this.addOptWithArg("w", "seekToPid", "Seek to this procedure id and print this procedure only");
        OptionGroup files = new OptionGroup();
        files.addOption(new Option("f", "file", true, "File to scan. Pass full-path; e.g. hdfs://a:9000/MasterProcs/master/local/proc/xxx"));
        files.addOption(new Option("a", "all", false, "Scan the whole procedure region."));
        files.setRequired(true);
        this.options.addOptionGroup(files);
    }

    private void addAllHFiles() throws IOException {
        Path masterProcDir = new Path(CommonFSUtils.getRootDir(this.conf), "MasterData");
        Path tableDir = CommonFSUtils.getTableDir(masterProcDir, MasterRegionFactory.TABLE_NAME);
        FileSystem fs = tableDir.getFileSystem(this.conf);
        Path regionDir = fs.listStatus(tableDir, p -> RegionInfo.isEncodedRegionName(Bytes.toBytes(p.getName())))[0].getPath();
        List<Path> regionFiles = HFile.getStoreFiles(fs, regionDir);
        this.files.addAll(regionFiles);
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        if (cmd.hasOption("w")) {
            String key = cmd.getOptionValue("w");
            if (key != null && key.length() != 0) {
                this.procId = Long.parseLong(key);
            } else {
                throw new IllegalArgumentException("Invalid row is specified.");
            }
        }
        if (cmd.hasOption("f")) {
            this.files.add(new Path(cmd.getOptionValue("f")));
        }
        if (cmd.hasOption("a")) {
            try {
                this.addAllHFiles();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void printCell(Cell cell) throws IOException {
        this.out.print("K: " + CellUtil.getCellKeyAsString(cell, c -> Long.toString(Bytes.toLong(c.getRowArray(), c.getRowOffset(), c.getRowLength()))));
        if (cell.getType() == Cell.Type.Put) {
            if (cell.getValueLength() == 0) {
                this.out.println(" V: mark deleted");
            } else {
                Procedure proc = ProcedureUtil.convertToProcedure((ProcedureProtos.Procedure)ProcedureProtos.Procedure.parser().parseFrom(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                this.out.println(" V: " + proc.toStringDetails());
            }
        } else {
            this.out.println();
        }
    }

    private void processFile(Path file) throws IOException {
        block29: {
            this.out.println("Scanning -> " + file);
            FileSystem fs = file.getFileSystem(this.conf);
            try (HFile.Reader reader = HFile.createReader(fs, file, CacheConfig.DISABLED, true, this.conf);
                 HFileScanner scanner = reader.getScanner(false, false, false);){
                Cell cell;
                if (this.procId != null) {
                    if (scanner.seekTo(PrivateCellUtil.createFirstOnRow(Bytes.toBytes(this.procId))) == -1) break block29;
                    do {
                        long currentProcId;
                        if ((currentProcId = Bytes.toLong((cell = scanner.getCell()).getRowArray(), cell.getRowOffset(), cell.getRowLength())) != this.procId) {
                            break block29;
                        }
                        this.printCell(cell);
                    } while (scanner.next());
                    break block29;
                }
                if (scanner.seekTo()) {
                    do {
                        cell = scanner.getCell();
                        this.printCell(cell);
                    } while (scanner.next());
                }
            }
        }
    }

    @Override
    protected int doWork() throws Exception {
        for (Path file : this.files) {
            this.processFile(file);
        }
        return 0;
    }

    public static void main(String[] args2) {
        new HFileProcedurePrettyPrinter().doStaticMain(args2);
    }
}

