/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.vm.sa;

import java.lang.reflect.Method;
import org.apache.hudi.org.openjdk.jol.util.ClassUtils;
import org.apache.hudi.org.openjdk.jol.vm.sa.Task;
import org.apache.hudi.org.openjdk.jol.vm.sa.UniverseData;

class UniverseTask
implements Task {
    UniverseTask() {
    }

    @Override
    public UniverseData process() {
        try {
            Class<?> universeClass = ClassUtils.loadClass("sun.jvm.hotspot.memory.Universe");
            Class<?> vmClass = ClassUtils.loadClass("sun.jvm.hotspot.runtime.VM");
            Object vm = ClassUtils.loadClass("sun.jvm.hotspot.runtime.VM").getMethod("getVM", new Class[0]).invoke(null, new Object[0]);
            Method getOopSizeMethod = vmClass.getMethod("getOopSize", new Class[0]);
            Method getObjectAlignmentInBytesMethod = vmClass.getMethod("getObjectAlignmentInBytes", new Class[0]);
            Method getHeapOopSizeMethod = vmClass.getMethod("getHeapOopSize", new Class[0]);
            Method isCompressedOopsEnabledMethod = vmClass.getMethod("isCompressedOopsEnabled", new Class[0]);
            Method getNarrowOopBaseMethod = universeClass.getMethod("getNarrowOopBase", new Class[0]);
            Method getNarrowOopShiftMethod = universeClass.getMethod("getNarrowOopShift", new Class[0]);
            Method isCompressedKlassPtrsEnabledMethod = null;
            Method getNarrowKlassBaseMethod = null;
            Method getNarrowKlassShiftMethod = null;
            try {
                isCompressedKlassPtrsEnabledMethod = vmClass.getMethod("isCompressedKlassPointersEnabled", new Class[0]);
                getNarrowKlassBaseMethod = universeClass.getMethod("getNarrowKlassBase", new Class[0]);
                getNarrowKlassShiftMethod = universeClass.getMethod("getNarrowKlassShift", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            int addressSize = ((Long)getOopSizeMethod.invoke(vm, new Object[0])).intValue();
            int objectAlignment = (Integer)getObjectAlignmentInBytesMethod.invoke(vm, new Object[0]);
            int oopSize = (Integer)getHeapOopSizeMethod.invoke(vm, new Object[0]);
            boolean compressedOopsEnabled = (Boolean)isCompressedOopsEnabledMethod.invoke(vm, new Object[0]);
            long narrowOopBase = (Long)getNarrowOopBaseMethod.invoke(null, new Object[0]);
            int narrowOopShift = (Integer)getNarrowOopShiftMethod.invoke(null, new Object[0]);
            boolean compressedKlassPtrsEnabled = isCompressedKlassPtrsEnabledMethod != null ? (Boolean)isCompressedKlassPtrsEnabledMethod.invoke(vm, new Object[0]) : compressedOopsEnabled;
            long narrowKlassBase = getNarrowKlassBaseMethod != null ? (Long)getNarrowKlassBaseMethod.invoke(null, new Object[0]) : narrowOopBase;
            int narrowKlassShift = getNarrowKlassShiftMethod != null ? (Integer)getNarrowKlassShiftMethod.invoke(null, new Object[0]) : narrowOopShift;
            return new UniverseData(addressSize, objectAlignment, oopSize, compressedOopsEnabled, narrowOopBase, narrowOopShift, compressedKlassPtrsEnabled, narrowKlassBase, narrowKlassShift);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

