/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.plan.generators;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.plan.generators.BaseHoodieCompactionPlanGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
extends BaseHoodieCompactionPlanGenerator<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieCompactionPlanGenerator.class);

    public HoodieCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    protected HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, List<HoodieCompactionOperation> operations) {
        return this.writeConfig.getCompactionStrategy().generateCompactionPlan(this.writeConfig, operations, CompactionUtils.getAllPendingCompactionPlans(metaClient).stream().map(Pair::getValue).collect(Collectors.toList()));
    }

    @Override
    protected List<String> filterPartitionPathsByStrategy(HoodieWriteConfig writeConfig, List<String> partitionPaths) {
        return writeConfig.getCompactionStrategy().filterPartitionPaths(writeConfig, partitionPaths);
    }

    @Override
    protected boolean filterLogCompactionOperations() {
        return false;
    }
}

