/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hudi.exception.HoodieCatalogException;
import org.apache.hudi.table.catalog.CatalogOptions;
import org.apache.hudi.table.catalog.HoodieCatalog;
import org.apache.hudi.table.catalog.HoodieHiveCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCatalogFactory.class);
    public static final String IDENTIFIER = "hudi";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Catalog createCatalog(CatalogFactory.Context context) {
        FactoryUtil.CatalogFactoryHelper helper = FactoryUtil.createCatalogFactoryHelper((CatalogFactory)this, (CatalogFactory.Context)context);
        helper.validate();
        String mode = (String)helper.getOptions().get(CatalogOptions.MODE);
        switch (mode.toLowerCase(Locale.ROOT)) {
            case "hms": {
                return new HoodieHiveCatalog(context.getName(), (Configuration)helper.getOptions());
            }
            case "dfs": {
                return new HoodieCatalog(context.getName(), (Configuration)helper.getOptions());
            }
        }
        throw new HoodieCatalogException(String.format("Invalid catalog mode: %s, supported modes: [hms, dfs].", mode));
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet(CatalogOptions.allOptions());
    }
}

