/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.DataInput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.com.esotericsoftware.kryo.Kryo;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class WritableComparator<T extends Writable & Comparable<T>>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private Class<T> type;
    private final boolean ascendingComparison;
    private transient T reference;
    private transient T tempReference;
    private transient Kryo kryo;
    private final TypeComparator[] comparators = new TypeComparator[]{this};

    public WritableComparator(boolean ascending, Class<T> type) {
        this.type = type;
        this.ascendingComparison = ascending;
    }

    public int hash(T record) {
        return record.hashCode();
    }

    public void setReference(T toCompare) {
        this.checkKryoInitialized();
        this.reference = (Writable)KryoUtils.copy(toCompare, (Kryo)this.kryo, new WritableSerializer<T>(this.type));
    }

    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        T otherRef = ((WritableComparator)referencedComparator).reference;
        int comp = ((Comparable)otherRef).compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compare(T first, T second) {
        int comp = ((Comparable)first).compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        this.ensureReferenceInstantiated();
        this.ensureTempReferenceInstantiated();
        this.reference.readFields((DataInput)firstSource);
        this.tempReference.readFields((DataInput)secondSource);
        int comp = ((Comparable)this.reference).compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(this.type);
    }

    public int getNormalizeKeyLen() {
        this.ensureReferenceInstantiated();
        NormalizableKey key = (NormalizableKey)this.reference;
        return key.getMaxNormalizedKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)record;
        key.copyNormalizedKey(target, offset, numBytes);
    }

    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    public TypeComparator<T> duplicate() {
        return new WritableComparator<T>(this.ascendingComparison, this.type);
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy(instantiatorStrategy);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    private void ensureReferenceInstantiated() {
        if (this.reference == null) {
            this.reference = (Writable)InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }

    private void ensureTempReferenceInstantiated() {
        if (this.tempReference == null) {
            this.tempReference = (Writable)InstantiationUtil.instantiate(this.type, Writable.class);
        }
    }
}

