/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.client.utils.MetadataConversionUtils;
import org.apache.hudi.common.model.HoodieMetadataWrapper;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;

public class ConcurrentOperation {
    private WriteOperationType operationType;
    private final HoodieMetadataWrapper metadataWrapper;
    private final Option<org.apache.hudi.common.model.HoodieCommitMetadata> commitMetadataOption;
    private final String actionState;
    private final String actionType;
    private final String instantTime;
    private Set<String> mutatedFileIds = Collections.EMPTY_SET;

    public ConcurrentOperation(HoodieInstant instant, HoodieTableMetaClient metaClient) throws IOException {
        this.metadataWrapper = new HoodieMetadataWrapper(MetadataConversionUtils.createMetaWrapper(instant, metaClient));
        this.commitMetadataOption = Option.empty();
        this.actionState = instant.getState().name();
        this.actionType = instant.getAction();
        this.instantTime = instant.getTimestamp();
        this.init(instant);
    }

    public ConcurrentOperation(HoodieInstant instant, org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata) {
        this.commitMetadataOption = Option.of(commitMetadata);
        this.metadataWrapper = new HoodieMetadataWrapper(commitMetadata);
        this.actionState = instant.getState().name();
        this.actionType = instant.getAction();
        this.instantTime = instant.getTimestamp();
        this.init(instant);
    }

    public String getInstantActionState() {
        return this.actionState;
    }

    public String getInstantActionType() {
        return this.actionType;
    }

    public String getInstantTimestamp() {
        return this.instantTime;
    }

    public WriteOperationType getOperationType() {
        return this.operationType;
    }

    public Set<String> getMutatedFileIds() {
        return this.mutatedFileIds;
    }

    public Option<org.apache.hudi.common.model.HoodieCommitMetadata> getCommitMetadataOption() {
        return this.commitMetadataOption;
    }

    private void init(HoodieInstant instant) {
        block25: {
            block24: {
                if (!this.metadataWrapper.isAvroMetadata()) break block24;
                switch (this.getInstantActionType()) {
                    case "compaction": {
                        this.operationType = WriteOperationType.COMPACT;
                        this.mutatedFileIds = this.metadataWrapper.getMetadataFromTimeline().getHoodieCompactionPlan().getOperations().stream().map(op -> op.getFileId()).collect(Collectors.toSet());
                        break;
                    }
                    case "commit": 
                    case "deltacommit": {
                        this.mutatedFileIds = CommitUtils.getFileIdWithoutSuffixAndRelativePathsFromSpecificRecord(this.metadataWrapper.getMetadataFromTimeline().getHoodieCommitMetadata().getPartitionToWriteStats()).keySet();
                        this.operationType = WriteOperationType.fromValue(this.metadataWrapper.getMetadataFromTimeline().getHoodieCommitMetadata().getOperationType());
                        break;
                    }
                    case "replacecommit": {
                        if (instant.isCompleted()) {
                            this.mutatedFileIds = CommitUtils.getFileIdWithoutSuffixAndRelativePathsFromSpecificRecord(this.metadataWrapper.getMetadataFromTimeline().getHoodieReplaceCommitMetadata().getPartitionToWriteStats()).keySet();
                            this.operationType = WriteOperationType.fromValue(this.metadataWrapper.getMetadataFromTimeline().getHoodieReplaceCommitMetadata().getOperationType());
                            break;
                        }
                        HoodieRequestedReplaceMetadata requestedReplaceMetadata = this.metadataWrapper.getMetadataFromTimeline().getHoodieRequestedReplaceMetadata();
                        HoodieCommitMetadata inflightCommitMetadata = this.metadataWrapper.getMetadataFromTimeline().getHoodieInflightReplaceMetadata();
                        if (instant.isRequested()) {
                            if (requestedReplaceMetadata != null) {
                                this.mutatedFileIds = ConcurrentOperation.getFileIdsFromRequestedReplaceMetadata(requestedReplaceMetadata);
                                this.operationType = WriteOperationType.CLUSTER;
                                break;
                            }
                        } else {
                            if (inflightCommitMetadata != null) {
                                this.mutatedFileIds = CommitUtils.getFileIdWithoutSuffixAndRelativePathsFromSpecificRecord(inflightCommitMetadata.getPartitionToWriteStats()).keySet();
                                this.operationType = WriteOperationType.fromValue(this.metadataWrapper.getMetadataFromTimeline().getHoodieCommitMetadata().getOperationType());
                                break;
                            }
                            if (requestedReplaceMetadata != null) {
                                this.mutatedFileIds = ConcurrentOperation.getFileIdsFromRequestedReplaceMetadata(requestedReplaceMetadata);
                                this.operationType = WriteOperationType.CLUSTER;
                                break;
                            }
                        }
                        break block25;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported Action Type " + this.getInstantActionType());
                    }
                }
                break block25;
            }
            switch (this.getInstantActionType()) {
                case "commit": 
                case "deltacommit": {
                    this.mutatedFileIds = CommitUtils.getFileIdWithoutSuffixAndRelativePaths(this.metadataWrapper.getCommitMetadata().getPartitionToWriteStats()).keySet();
                    this.operationType = this.metadataWrapper.getCommitMetadata().getOperationType();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Action Type " + this.getInstantActionType());
                }
            }
        }
    }

    private static Set<String> getFileIdsFromRequestedReplaceMetadata(HoodieRequestedReplaceMetadata requestedReplaceMetadata) {
        return requestedReplaceMetadata.getClusteringPlan().getInputGroups().stream().flatMap(ig -> ig.getSlices().stream()).map(file -> file.getFileId()).collect(Collectors.toSet());
    }

    public String toString() {
        return "{actionType=" + this.getInstantActionType() + ", instantTime=" + this.getInstantTimestamp() + ", actionState=" + this.getInstantActionState() + '\'' + '}';
    }
}

