/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.BloomFilterUtils;
import org.apache.hudi.common.bloom.InternalDynamicBloomFilter;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.exception.HoodieIndexException;

public class HoodieDynamicBoundedBloomFilter
implements BloomFilter {
    public static final String TYPE_CODE_PREFIX = "DYNAMIC";
    private InternalDynamicBloomFilter internalDynamicBloomFilter;

    HoodieDynamicBoundedBloomFilter(int numEntries, double errorRate, int hashType, int maxNoOfEntries) {
        int bitSize = BloomFilterUtils.getBitSize(numEntries, errorRate);
        int numHashs = BloomFilterUtils.getNumHashes(bitSize, numEntries);
        this.internalDynamicBloomFilter = new InternalDynamicBloomFilter(bitSize, numHashs, hashType, numEntries, maxNoOfEntries);
    }

    public HoodieDynamicBoundedBloomFilter(String serString, BloomFilterTypeCode typeCode) {
        byte[] bytes = Base64CodecUtil.decode(serString);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            this.internalDynamicBloomFilter = new InternalDynamicBloomFilter();
            this.internalDynamicBloomFilter.readFields(dis);
            dis.close();
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter instance", e);
        }
    }

    @Override
    public void add(String key) {
        this.internalDynamicBloomFilter.add(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public boolean mightContain(String key) {
        return this.internalDynamicBloomFilter.membershipTest(new Key(key.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.internalDynamicBloomFilter.write(dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return Base64CodecUtil.encode(bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }

    @Override
    public BloomFilterTypeCode getBloomFilterTypeCode() {
        return BloomFilterTypeCode.DYNAMIC_V0;
    }
}

