/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;

public class HoodieInstant
implements Serializable,
Comparable<HoodieInstant> {
    private static final Map<String, String> COMPARABLE_ACTIONS = CollectionUtils.createImmutableMap("compaction", "commit");
    public static final Comparator<HoodieInstant> ACTION_COMPARATOR = Comparator.comparing(instant -> HoodieInstant.getComparableAction(instant.getAction()));
    public static final Comparator<HoodieInstant> COMPARATOR = Comparator.comparing(HoodieInstant::getTimestamp).thenComparing(ACTION_COMPARATOR).thenComparing(HoodieInstant::getState);
    private State state = State.COMPLETED;
    private String action;
    private String timestamp;

    public static String getComparableAction(String action) {
        return COMPARABLE_ACTIONS.getOrDefault(action, action);
    }

    public static String getTimelineFileExtension(String fileName) {
        Objects.requireNonNull(fileName);
        int dotIndex = fileName.indexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex);
    }

    public HoodieInstant(FileStatus fileStatus) {
        String fileName = fileStatus.getPath().getName();
        String fileExtension = HoodieInstant.getTimelineFileExtension(fileName);
        this.timestamp = fileName.replace(fileExtension, "");
        this.action = fileExtension.replaceFirst(".", "");
        if (this.action.equals("inflight")) {
            this.action = "commit";
            this.state = State.INFLIGHT;
        } else if (this.action.contains(".inflight")) {
            this.state = State.INFLIGHT;
            this.action = this.action.replace(".inflight", "");
        } else if (this.action.contains(".requested")) {
            this.state = State.REQUESTED;
            this.action = this.action.replace(".requested", "");
        }
    }

    public HoodieInstant(boolean isInflight, String action, String timestamp) {
        this.state = isInflight ? State.INFLIGHT : State.COMPLETED;
        this.action = action;
        this.timestamp = timestamp;
    }

    public HoodieInstant(State state, String action, String timestamp) {
        this.state = state;
        this.action = action;
        this.timestamp = timestamp;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isInflight() {
        return this.state == State.INFLIGHT;
    }

    public boolean isRequested() {
        return this.state == State.REQUESTED;
    }

    public String getAction() {
        return this.action;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getFileName() {
        if ("commit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCommitFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedCommitFileName(this.timestamp) : HoodieTimeline.makeCommitFileName(this.timestamp));
        }
        if ("clean".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightCleanerFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedCleanerFileName(this.timestamp) : HoodieTimeline.makeCleanerFileName(this.timestamp));
        }
        if ("rollback".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRollbackFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedRollbackFileName(this.timestamp) : HoodieTimeline.makeRollbackFileName(this.timestamp));
        }
        if ("savepoint".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightSavePointFileName(this.timestamp) : HoodieTimeline.makeSavePointFileName(this.timestamp);
        }
        if ("deltacommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightDeltaFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedDeltaFileName(this.timestamp) : HoodieTimeline.makeDeltaFileName(this.timestamp));
        }
        if ("compaction".equals(this.action)) {
            if (this.isInflight()) {
                return HoodieTimeline.makeInflightCompactionFileName(this.timestamp);
            }
            if (this.isRequested()) {
                return HoodieTimeline.makeRequestedCompactionFileName(this.timestamp);
            }
            return HoodieTimeline.makeCommitFileName(this.timestamp);
        }
        if ("restore".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightRestoreFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedRestoreFileName(this.timestamp) : HoodieTimeline.makeRestoreFileName(this.timestamp));
        }
        if ("replacecommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightReplaceFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedReplaceFileName(this.timestamp) : HoodieTimeline.makeReplaceFileName(this.timestamp));
        }
        if ("indexing".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightIndexFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestedIndexFileName(this.timestamp) : HoodieTimeline.makeIndexCommitFileName(this.timestamp));
        }
        if ("schemacommit".equals(this.action)) {
            return this.isInflight() ? HoodieTimeline.makeInflightSchemaFileName(this.timestamp) : (this.isRequested() ? HoodieTimeline.makeRequestSchemaFileName(this.timestamp) : HoodieTimeline.makeSchemaFileName(this.timestamp));
        }
        throw new IllegalArgumentException("Cannot get file name for unknown action " + this.action);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieInstant that = (HoodieInstant)o;
        return this.state == that.state && Objects.equals(this.action, that.action) && Objects.equals(this.timestamp, that.timestamp);
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.action, this.timestamp});
    }

    @Override
    public int compareTo(HoodieInstant o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "[" + (this.isInflight() || this.isRequested() ? "==>" : "") + this.timestamp + "__" + this.action + "__" + (Object)((Object)this.state) + "]";
    }

    public static enum State {
        REQUESTED,
        INFLIGHT,
        COMPLETED,
        INVALID;

    }
}

