/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.PartitionValueExtractor;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.sync.common.AbstractSyncHoodieClient;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.parquet.schema.MessageType;

public abstract class AbstractHiveSyncHoodieClient
extends AbstractSyncHoodieClient {
    protected final HoodieTimeline activeTimeline;
    protected final HiveSyncConfig syncConfig;
    protected final Configuration hadoopConf;
    protected final PartitionValueExtractor partitionValueExtractor;

    public AbstractHiveSyncHoodieClient(HiveSyncConfig syncConfig, Configuration hadoopConf, FileSystem fs) {
        super(syncConfig.basePath, syncConfig.assumeDatePartitioning, syncConfig.useFileListingFromMetadata, syncConfig.withOperationField, fs);
        this.syncConfig = syncConfig;
        this.hadoopConf = hadoopConf;
        this.partitionValueExtractor = (PartitionValueExtractor)ReflectionUtils.loadClass(syncConfig.partitionValueExtractorClass);
        this.activeTimeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getActiveTimeline() {
        return this.activeTimeline;
    }

    protected List<AbstractSyncHoodieClient.PartitionEvent> getPartitionEvents(List<Partition> tablePartitions, List<String> partitionStoragePartitions, boolean isDropPartition) {
        HashMap<String, String> paths = new HashMap<String, String>();
        for (Partition tablePartition : tablePartitions) {
            List<String> hivePartitionValues = tablePartition.getValues();
            String fullTablePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tablePartition.getStorageLocation())).toUri().getPath();
            paths.put(String.join((CharSequence)", ", hivePartitionValues), fullTablePartitionPath);
        }
        ArrayList<AbstractSyncHoodieClient.PartitionEvent> events = new ArrayList<AbstractSyncHoodieClient.PartitionEvent>();
        for (String storagePartition : partitionStoragePartitions) {
            Path storagePartitionPath = FSUtils.getPartitionPath(this.syncConfig.basePath, storagePartition);
            String fullStoragePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)storagePartitionPath).toUri().getPath();
            List<String> storagePartitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(storagePartition);
            if (isDropPartition) {
                events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionDropEvent(storagePartition));
                continue;
            }
            if (storagePartitionValues.isEmpty()) continue;
            String storageValue = String.join((CharSequence)", ", storagePartitionValues);
            if (!paths.containsKey(storageValue)) {
                events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionAddEvent(storagePartition));
                continue;
            }
            if (((String)paths.get(storageValue)).equals(fullStoragePartitionPath)) continue;
            events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionUpdateEvent(storagePartition));
        }
        return events;
    }

    public abstract List<Partition> getAllPartitions(String var1);

    public abstract boolean databaseExists(String var1);

    public abstract void createDatabase(String var1);

    public abstract void updateTableDefinition(String var1, MessageType var2);

    public Schema getAvroSchemaWithoutMetadataFields() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchemaWithoutMetadataFields();
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read avro schema", e);
        }
    }

    public abstract List<FieldSchema> getTableCommentUsingMetastoreClient(String var1);

    public abstract void updateTableComments(String var1, List<FieldSchema> var2, List<Schema.Field> var3);

    public abstract void updateTableComments(String var1, List<FieldSchema> var2, Map<String, String> var3);
}

