/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.hive.AbstractHiveSyncHoodieClient;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.ddl.HMSDDLExecutor;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.ddl.JDBCExecutor;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;

public class HoodieHiveClient
extends AbstractHiveSyncHoodieClient {
    private static final Logger LOG = LogManager.getLogger(HoodieHiveClient.class);
    DDLExecutor ddlExecutor;
    private IMetaStoreClient client;

    public HoodieHiveClient(HiveSyncConfig cfg, HiveConf configuration, FileSystem fs) {
        super(cfg, (Configuration)configuration, fs);
        try {
            if (!StringUtils.isNullOrEmpty(cfg.syncMode)) {
                HiveSyncMode syncMode = HiveSyncMode.of(cfg.syncMode);
                switch (syncMode) {
                    case HMS: {
                        this.ddlExecutor = new HMSDDLExecutor(configuration, cfg, fs);
                        break;
                    }
                    case HIVEQL: {
                        this.ddlExecutor = new HiveQueryDDLExecutor(cfg, fs, configuration);
                        break;
                    }
                    case JDBC: {
                        this.ddlExecutor = new JDBCExecutor(cfg, fs);
                        break;
                    }
                    default: {
                        throw new HoodieHiveSyncException("Invalid sync mode given " + cfg.syncMode);
                    }
                }
            } else {
                this.ddlExecutor = cfg.useJdbc != false ? new JDBCExecutor(cfg, fs) : new HiveQueryDDLExecutor(cfg, fs, configuration);
            }
            this.client = Hive.get((HiveConf)configuration).getMSC();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to create HiveMetaStoreClient", e);
        }
    }

    @Override
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        this.ddlExecutor.addPartitionsToTable(tableName, partitionsToAdd);
    }

    @Override
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        this.ddlExecutor.updatePartitionsToTable(tableName, changedPartitions);
    }

    @Override
    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        this.ddlExecutor.dropPartitionsToTable(tableName, partitionsToDrop);
    }

    @Override
    public void updateTableProperties(String tableName, Map<String, String> tableProperties) {
        if (tableProperties == null || tableProperties.isEmpty()) {
            return;
        }
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            for (Map.Entry<String, String> entry : tableProperties.entrySet()) {
                table.putToParameters(entry.getKey(), entry.getValue());
            }
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update table properties for table: " + tableName, e);
        }
    }

    @Deprecated
    public List<Partition> scanTablePartitions(String tableName) throws TException {
        return this.client.listPartitions(this.syncConfig.databaseName, tableName, (short)-1);
    }

    @Override
    public void updateTableDefinition(String tableName, MessageType newSchema) {
        this.ddlExecutor.updateTableDefinition(tableName, newSchema);
    }

    @Override
    public List<org.apache.hudi.sync.common.model.Partition> getAllPartitions(String tableName) {
        try {
            return this.client.listPartitions(this.syncConfig.databaseName, tableName, (short)-1).stream().map(p -> new org.apache.hudi.sync.common.model.Partition(p.getValues(), p.getSd().getLocation())).collect(Collectors.toList());
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to get all partitions for table " + TableUtils.tableId(this.syncConfig.databaseName, tableName), e);
        }
    }

    @Override
    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        this.ddlExecutor.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
    }

    @Override
    public Map<String, String> getTableSchema(String tableName) {
        if (!this.tableExists(tableName)) {
            throw new IllegalArgumentException("Failed to get schema for table " + tableName + " does not exist");
        }
        return this.ddlExecutor.getTableSchema(tableName);
    }

    @Override
    @Deprecated
    public boolean doesTableExist(String tableName) {
        return this.tableExists(tableName);
    }

    @Override
    public boolean tableExists(String tableName) {
        try {
            return this.client.tableExists(this.syncConfig.databaseName, tableName);
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if table exists " + tableName, e);
        }
    }

    @Deprecated
    public boolean doesDataBaseExist(String databaseName) {
        return this.databaseExists(databaseName);
    }

    @Override
    public boolean databaseExists(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return false;
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if database exists " + databaseName, e);
        }
    }

    @Override
    public void createDatabase(String databaseName) {
        this.ddlExecutor.createDatabase(databaseName);
    }

    @Override
    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_commit_time_sync", null));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last commit time synced from the table " + tableName, e);
        }
    }

    @Override
    public Option<String> getLastReplicatedTime(String tableName) {
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            return Option.ofNullable(table.getParameters().getOrDefault("last_replication_timestamp", null));
        }
        catch (NoSuchObjectException e) {
            LOG.warn((Object)("the said table not found in hms " + this.syncConfig.databaseName + "." + tableName));
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last replicated time from the table " + tableName, e);
        }
    }

    @Override
    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        if (!this.activeTimeline.filterCompletedInstants().getInstants().anyMatch(i -> i.getTimestamp().equals(timeStamp))) {
            throw new HoodieHiveSyncException("Not a valid completed timestamp " + timeStamp + " for table " + tableName);
        }
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            table.putToParameters("last_replication_timestamp", timeStamp);
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update last replicated time to " + timeStamp + " for " + tableName, e);
        }
    }

    @Override
    public void deleteLastReplicatedTimeStamp(String tableName) {
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            String timestamp = (String)table.getParameters().remove("last_replication_timestamp");
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
            if (timestamp != null) {
                LOG.info((Object)("deleted last replicated timestamp " + timestamp + " for table " + tableName));
            }
        }
        catch (NoSuchObjectException table) {
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to delete last replicated timestamp for " + tableName, e);
        }
    }

    @Override
    public void close() {
        try {
            this.ddlExecutor.close();
            if (this.client != null) {
                Hive.closeCurrent();
                this.client = null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not close connection ", (Throwable)e);
        }
    }

    @Override
    public void updateLastCommitTimeSynced(String tableName) {
        Option<String> lastCommitSynced = this.activeTimeline.lastInstant().map(HoodieInstant::getTimestamp);
        if (lastCommitSynced.isPresent()) {
            try {
                Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
                table.putToParameters("last_commit_time_sync", lastCommitSynced.get());
                this.client.alter_table(this.syncConfig.databaseName, tableName, table);
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Failed to get update last commit time synced to " + lastCommitSynced, e);
            }
        }
    }

    @Override
    public List<FieldSchema> getTableCommentUsingMetastoreClient(String tableName) {
        try {
            return this.client.getSchema(this.syncConfig.databaseName, tableName);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get table comments for : " + tableName, e);
        }
    }

    @Override
    public void updateTableComments(String tableName, List<FieldSchema> oldSchema, List<Schema.Field> newSchema) {
        Map<String, String> newComments = newSchema.stream().collect(Collectors.toMap(field -> field.name().toLowerCase(Locale.ROOT), field -> StringUtils.isNullOrEmpty(field.doc()) ? "" : field.doc()));
        this.updateTableComments(tableName, oldSchema, newComments);
    }

    @Override
    public void updateTableComments(String tableName, List<FieldSchema> oldSchema, Map<String, String> newComments) {
        Map<String, String> oldComments = oldSchema.stream().collect(Collectors.toMap(fieldSchema -> fieldSchema.getName().toLowerCase(Locale.ROOT), fieldSchema -> StringUtils.isNullOrEmpty(fieldSchema.getComment()) ? "" : fieldSchema.getComment()));
        Map<String, String> types = oldSchema.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
        HashMap<String, ImmutablePair<String, String>> alterComments = new HashMap<String, ImmutablePair<String, String>>();
        oldComments.forEach((name, comment) -> {
            String newComment = newComments.getOrDefault(name, "");
            if (!newComment.equals(comment)) {
                alterComments.put((String)name, new ImmutablePair(types.get(name), newComment));
            }
        });
        if (alterComments.size() > 0) {
            this.ddlExecutor.updateTableComments(tableName, alterComments);
        } else {
            LOG.info((Object)String.format("No comment difference of %s ", tableName));
        }
    }
}

