/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.ddl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.ddl.QueryBasedDDLExecutor;
import org.apache.hudi.hive.util.HivePartitionUtil;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HiveQueryDDLExecutor
extends QueryBasedDDLExecutor {
    private static final Logger LOG = LogManager.getLogger(HiveQueryDDLExecutor.class);
    private final HiveSyncConfig config;
    private final IMetaStoreClient metaStoreClient;
    private SessionState sessionState = null;
    private Driver hiveDriver = null;

    public HiveQueryDDLExecutor(HiveSyncConfig config, FileSystem fs, HiveConf configuration) throws HiveException, MetaException {
        super(config, fs);
        this.config = config;
        this.metaStoreClient = Hive.get((HiveConf)configuration).getMSC();
        try {
            this.sessionState = new SessionState(configuration, UserGroupInformation.getCurrentUser().getShortUserName());
            SessionState.start((SessionState)this.sessionState);
            this.sessionState.setCurrentDatabase(config.databaseName);
            this.hiveDriver = new Driver(configuration);
        }
        catch (Exception e) {
            if (this.sessionState != null) {
                try {
                    this.sessionState.close();
                }
                catch (IOException ioException) {
                    LOG.error((Object)"Error while closing SessionState", (Throwable)ioException);
                }
            }
            if (this.hiveDriver != null) {
                this.hiveDriver.close();
            }
            throw new HoodieHiveSyncException("Failed to create HiveQueryDDL object", e);
        }
    }

    @Override
    public void runSQL(String sql) {
        this.updateHiveSQLs(Collections.singletonList(sql));
    }

    private List<CommandProcessorResponse> updateHiveSQLs(List<String> sqls) {
        ArrayList<CommandProcessorResponse> responses = new ArrayList<CommandProcessorResponse>();
        try {
            for (String sql : sqls) {
                if (this.hiveDriver == null) continue;
                HoodieTimer timer = new HoodieTimer().startTimer();
                responses.add(this.hiveDriver.run(sql));
                LOG.info((Object)String.format("Time taken to execute [%s]: %s ms", sql, timer.endTimer()));
            }
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed in executing SQL", e);
        }
        return responses;
    }

    @Override
    public Map<String, String> getTableSchema(String tableName) {
        try {
            long start = System.currentTimeMillis();
            Table table = this.metaStoreClient.getTable(this.config.databaseName, tableName);
            Map<String, String> partitionKeysMap = table.getPartitionKeys().stream().collect(Collectors.toMap(FieldSchema::getName, f -> f.getType().toUpperCase()));
            Map<String, String> columnsMap = table.getSd().getCols().stream().collect(Collectors.toMap(FieldSchema::getName, f -> f.getType().toUpperCase()));
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.putAll(columnsMap);
            schema.putAll(partitionKeysMap);
            long end = System.currentTimeMillis();
            LOG.info((Object)String.format("Time taken to getTableSchema: %s ms", end - start));
            return schema;
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get table schema for : " + tableName, e);
        }
    }

    @Override
    public void dropPartitionsToTable(String tableName, List<String> partitionsToDrop) {
        if (partitionsToDrop.isEmpty()) {
            LOG.info((Object)("No partitions to drop for " + tableName));
            return;
        }
        LOG.info((Object)("Drop partitions " + partitionsToDrop.size() + " on " + tableName));
        try {
            for (String dropPartition : partitionsToDrop) {
                if (HivePartitionUtil.partitionExists(this.metaStoreClient, tableName, dropPartition, this.partitionValueExtractor, this.config).booleanValue()) {
                    String partitionClause = HivePartitionUtil.getPartitionClauseForDrop(dropPartition, this.partitionValueExtractor, this.config);
                    this.metaStoreClient.dropPartition(this.config.databaseName, tableName, partitionClause, false);
                }
                LOG.info((Object)("Drop partition " + dropPartition + " on " + tableName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)(this.config.databaseName + "." + tableName + " drop partition failed"), (Throwable)e);
            throw new HoodieHiveSyncException(this.config.databaseName + "." + tableName + " drop partition failed", e);
        }
    }

    @Override
    public void close() {
        if (this.metaStoreClient != null) {
            Hive.closeCurrent();
        }
    }
}

