/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.Parameters;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hive.replication.GlobalHiveSyncConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@Parameters(commandDescription="A tool to sync the hudi table to hive from different clusters. Similar to HiveSyncTool but syncs it to morethan one hive cluster ( currently a local and remote cluster). The common timestamp that was synced is stored as a new table property This is most useful when we want to ensure that across different hive clusters we want ensure consistent reads. If that is not a requirementthen it is better to run HiveSyncTool separately.Note:   The tool tries to be transactional but does not guarantee it. If the sync fails midway in one cluster it will try to roll back the committed   timestamp from already successful sync on other clusters but that can also fail.  The tool does not roll back any synced partitions but only the timestamp.")
public class HiveSyncGlobalCommitConfig
extends GlobalHiveSyncConfig {
    private static final Logger LOG = LogManager.getLogger(HiveSyncGlobalCommitConfig.class);
    public static String LOCAL_HIVE_SITE_URI = "hivesyncglobal.local_hive_site_uri";
    public static String REMOTE_HIVE_SITE_URI = "hivesyncglobal.remote_hive_site_uri";
    public static String REMOTE_BASE_PATH = "hivesyncglobal.remote_base_path";
    public static String LOCAL_BASE_PATH = "hivesyncglobal.local_base_path";
    public static String REMOTE_HIVE_SERVER_JDBC_URLS = "hivesyncglobal.remote_hs2_jdbc_urls";
    public static String LOCAL_HIVE_SERVER_JDBC_URLS = "hivesyncglobal.local_hs2_jdbc_urls";
    @Parameter(names={"--config-xml-file"}, description="path to the config file in Hive", required=true)
    public String configFile;
    public Properties properties = new Properties();
    private boolean finalize = false;

    public void load() throws IOException {
        if (this.finalize) {
            throw new RuntimeException("trying to modify finalized config");
        }
        this.finalize = true;
        try (FileInputStream configStream = new FileInputStream(new File(this.configFile));){
            this.properties.loadFromXML(configStream);
        }
        if (StringUtils.isNullOrEmpty(this.globallyReplicatedTimeStamp)) {
            throw new RuntimeException("globally replicated timestamp not set");
        }
    }

    GlobalHiveSyncConfig mkGlobalHiveSyncConfig(boolean forRemote) {
        GlobalHiveSyncConfig cfg = GlobalHiveSyncConfig.copy(this);
        cfg.basePath = forRemote ? this.properties.getProperty(REMOTE_BASE_PATH) : this.properties.getProperty(LOCAL_BASE_PATH, cfg.basePath);
        cfg.jdbcUrl = forRemote ? this.properties.getProperty(REMOTE_HIVE_SERVER_JDBC_URLS) : this.properties.getProperty(LOCAL_HIVE_SERVER_JDBC_URLS, cfg.jdbcUrl);
        LOG.info((Object)("building hivesync config forRemote: " + forRemote + " " + cfg.jdbcUrl + " " + cfg.basePath));
        return cfg;
    }

    @Override
    public String toString() {
        return "HiveSyncGlobalCommitConfig{ configFile=" + this.configFile + ", properties=" + this.properties + ", " + super.toString() + " }";
    }

    public void storeToXML(OutputStream configStream) throws IOException {
        this.properties.storeToXML(configStream, "hivesync global config");
    }
}

