/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.FlinkMergeAndReplaceHandle;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConcatAndReplaceHandle<T extends HoodieRecordPayload, I, K, O>
extends FlinkMergeAndReplaceHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkConcatAndReplaceHandle.class);
    private final Iterator<HoodieRecord<T>> recordItr;

    public FlinkConcatAndReplaceHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Path basePath) {
        super(config, instantTime, hoodieTable, Collections.emptyIterator(), partitionPath, fileId, taskContextSupplier, basePath);
        this.recordItr = recordItr;
    }

    @Override
    public void write(GenericRecord oldRecord) {
        String key = KeyGenUtils.getRecordKeyFromGenericRecord(oldRecord, this.keyGeneratorOpt);
        try {
            this.fileWriter.writeAvro(key, oldRecord);
        }
        catch (IOException | RuntimeException e) {
            String errMsg = String.format("Failed to write old record into new file for key %s from old file %s to new file %s with writerSchema %s", key, this.getOldFilePath(), this.newFilePath, this.writeSchemaWithMetaFields.toString(true));
            LOG.debug("Old record is " + oldRecord);
            throw new HoodieUpsertException(errMsg, e);
        }
        ++this.recordsWritten;
    }

    @Override
    protected void writeIncomingRecords() throws IOException {
        while (this.recordItr.hasNext()) {
            HoodieRecord<T> record = this.recordItr.next();
            this.writeInsertRecord(record);
        }
    }
}

