/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;

public class ComplexAvroKeyGenerator
extends BaseKeyGenerator {
    public static final String DEFAULT_RECORD_KEY_SEPARATOR = ":";

    public ComplexAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields(), this.isConsistentLogicalTimestampEnabled());
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getRecordPartitionPath(record, this.getPartitionPathFields(), this.hiveStylePartitioning, this.encodePartitionPath, this.isConsistentLogicalTimestampEnabled());
    }
}

