/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.factory;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieAvroKeyGeneratorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieAvroKeyGeneratorFactory.class);

    public static KeyGenerator createKeyGenerator(TypedProperties props) throws IOException {
        KeyGenerator keyGenerator = KeyGenUtils.createKeyGeneratorByClassName(props);
        return Objects.isNull(keyGenerator) ? HoodieAvroKeyGeneratorFactory.createAvroKeyGeneratorByType(props) : keyGenerator;
    }

    private static KeyGenerator createAvroKeyGeneratorByType(TypedProperties props) throws IOException {
        KeyGeneratorType keyGeneratorTypeEnum;
        String keyGeneratorType = props.getString(HoodieWriteConfig.KEYGENERATOR_TYPE.key(), null);
        if (StringUtils.isNullOrEmpty(keyGeneratorType)) {
            LOG.info("The value of {} is empty, using SIMPLE", (Object)HoodieWriteConfig.KEYGENERATOR_TYPE.key());
            keyGeneratorType = KeyGeneratorType.SIMPLE.name();
        }
        try {
            keyGeneratorTypeEnum = KeyGeneratorType.valueOf(keyGeneratorType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
        }
        switch (keyGeneratorTypeEnum) {
            case SIMPLE: {
                return new SimpleAvroKeyGenerator(props);
            }
            case COMPLEX: {
                return new ComplexAvroKeyGenerator(props);
            }
            case TIMESTAMP: {
                return new TimestampBasedAvroKeyGenerator(props);
            }
            case CUSTOM: {
                return new CustomAvroKeyGenerator(props);
            }
            case NON_PARTITION: {
                return new NonpartitionedAvroKeyGenerator(props);
            }
            case GLOBAL_DELETE: {
                return new GlobalAvroDeleteKeyGenerator(props);
            }
        }
        throw new HoodieKeyGeneratorException("Unsupported keyGenerator Type " + keyGeneratorType);
    }
}

