/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.FileSystemBackedTableMetadata;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataPayload;

public interface HoodieTableMetadata
extends Serializable,
AutoCloseable {
    public static final String METADATA_TABLE_NAME_SUFFIX = "_metadata";
    public static final String SOLO_COMMIT_TIMESTAMP = "00000000000000";
    public static final String RECORDKEY_PARTITION_LIST = "__all_partitions__";
    public static final String NON_PARTITIONED_NAME = ".";
    public static final String EMPTY_PARTITION_NAME = "";

    public static String getMetadataTableBasePath(String dataTableBasePath) {
        return dataTableBasePath + "/" + ".hoodie/metadata";
    }

    public static String getDataTableBasePathFromMetadataTable(String metadataTableBasePath) {
        ValidationUtils.checkArgument(HoodieTableMetadata.isMetadataTable(metadataTableBasePath));
        return metadataTableBasePath.substring(0, metadataTableBasePath.lastIndexOf(".hoodie/metadata") - 1);
    }

    public static String getDatasetBasePath(String metadataTableBasePath) {
        int endPos = metadataTableBasePath.lastIndexOf("/.hoodie/metadata");
        ValidationUtils.checkState(endPos != -1, metadataTableBasePath + " should be base path of the metadata table");
        return metadataTableBasePath.substring(0, endPos);
    }

    public static boolean isMetadataTable(String basePath) {
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath.endsWith(".hoodie/metadata");
    }

    public static HoodieTableMetadata create(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapPath) {
        return HoodieTableMetadata.create(engineContext, metadataConfig, datasetBasePath, spillableMapPath, false);
    }

    public static HoodieTableMetadata create(HoodieEngineContext engineContext, HoodieMetadataConfig metadataConfig, String datasetBasePath, String spillableMapPath, boolean reuse) {
        if (metadataConfig.enabled()) {
            return new HoodieBackedTableMetadata(engineContext, metadataConfig, datasetBasePath, spillableMapPath, reuse);
        }
        return new FileSystemBackedTableMetadata(engineContext, new SerializableConfiguration(engineContext.getHadoopConf()), datasetBasePath, metadataConfig.shouldAssumeDatePartitioning());
    }

    public FileStatus[] getAllFilesInPartition(Path var1) throws IOException;

    public List<String> getAllPartitionPaths() throws IOException;

    public Map<String, FileStatus[]> getAllFilesInPartitions(List<String> var1) throws IOException;

    public Option<BloomFilter> getBloomFilter(String var1, String var2) throws HoodieMetadataException;

    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> var1) throws HoodieMetadataException;

    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> var1, String var2) throws HoodieMetadataException;

    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> var1, String var2);

    public Option<String> getSyncedInstantTime();

    public Option<String> getLatestCompactionTime();

    public void reset();
}

