/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class NormalizeTableFilterParams {
    private final List<TableName> tableNames;
    private final String regex;
    private final String namespace;

    private NormalizeTableFilterParams(List<TableName> tableNames, String regex, String namespace) {
        this.tableNames = tableNames;
        this.regex = regex;
        this.namespace = namespace;
    }

    public List<TableName> getTableNames() {
        return this.tableNames;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static class Builder {
        private List<TableName> tableNames;
        private String regex;
        private String namespace;

        public Builder tableFilterParams(NormalizeTableFilterParams ntfp) {
            this.tableNames = ntfp.getTableNames();
            this.regex = ntfp.getRegex();
            this.namespace = ntfp.getNamespace();
            return this;
        }

        public Builder tableNames(List<TableName> tableNames) {
            this.tableNames = tableNames;
            return this;
        }

        public Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public NormalizeTableFilterParams build() {
            return new NormalizeTableFilterParams(this.tableNames, this.regex, this.namespace);
        }
    }
}

