/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.metrics.impl;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.impl.DropwizardMeter;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TimerImpl
implements Timer {
    private final HistogramImpl histogram = new HistogramImpl();
    private final DropwizardMeter meter = new DropwizardMeter();
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.MICROSECONDS;

    @Override
    public void update(long duration, TimeUnit unit) {
        if (duration >= 0L) {
            this.histogram.update(DEFAULT_UNIT.convert(duration, unit));
            this.meter.mark();
        }
    }

    @Override
    public HistogramImpl getHistogram() {
        return this.histogram;
    }

    @Override
    public DropwizardMeter getMeter() {
        return this.meter;
    }
}

