/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellSet
implements NavigableSet<Cell> {
    public static final int UNKNOWN_NUM_UNIQUES = -1;
    private final NavigableMap<Cell, Cell> delegatee;
    private final int numUniqueKeys;

    public CellSet(CellComparator c) {
        this.delegatee = new ConcurrentSkipListMap<Cell, Cell>(c.getSimpleComparator());
        this.numUniqueKeys = -1;
    }

    CellSet(NavigableMap<Cell, Cell> m, int numUniqueKeys) {
        this.delegatee = m;
        this.numUniqueKeys = numUniqueKeys;
    }

    CellSet(NavigableMap<Cell, Cell> m) {
        this.delegatee = m;
        this.numUniqueKeys = -1;
    }

    NavigableMap<Cell, Cell> getDelegatee() {
        return this.delegatee;
    }

    @Override
    public Cell ceiling(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<Cell> descendingIterator() {
        return this.delegatee.descendingMap().values().iterator();
    }

    @Override
    public NavigableSet<Cell> descendingSet() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell floor(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> headSet(Cell toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public NavigableSet<Cell> headSet(Cell toElement, boolean inclusive) {
        return new CellSet(this.delegatee.headMap(toElement, inclusive), -1);
    }

    @Override
    public Cell higher(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.delegatee.values().iterator();
    }

    @Override
    public Cell lower(Cell e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell pollFirst() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell pollLast() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> subSet(Cell fromElement, Cell toElement) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public NavigableSet<Cell> subSet(Cell fromElement, boolean fromInclusive, Cell toElement, boolean toInclusive) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public SortedSet<Cell> tailSet(Cell fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public NavigableSet<Cell> tailSet(Cell fromElement, boolean inclusive) {
        return new CellSet(this.delegatee.tailMap(fromElement, inclusive), -1);
    }

    @Override
    public Comparator<? super Cell> comparator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Cell first() {
        return this.delegatee.firstEntry().getValue();
    }

    @Override
    public Cell last() {
        return this.delegatee.lastEntry().getValue();
    }

    @Override
    public boolean add(Cell e) {
        return this.delegatee.put(e, e) == null;
    }

    @Override
    public boolean addAll(Collection<? extends Cell> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void clear() {
        this.delegatee.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegatee.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean isEmpty() {
        return this.delegatee.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegatee.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Cell get(Cell kv) {
        return (Cell)this.delegatee.get(kv);
    }

    @Override
    public int size() {
        if (this.delegatee instanceof ConcurrentSkipListMap) {
            throw new UnsupportedOperationException("ConcurrentSkipListMap.size() is time-consuming");
        }
        return this.delegatee.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getNumUniqueKeys() {
        return this.numUniqueKeys;
    }
}

